/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe für die allgemeinen Eigenschaften einer Video-Kamera.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class PdKamera extends AbstractParameterDatensatz<PdKamera.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _url
				= new String
				()
				;
				private String
				 _bezeichnung
				= new String
				()
				;
				private String
				 _hersteller
				= new String
				()
				;
				private String
				 _seriennummer
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.objekte.FahrtRichtung
				 _fahrtrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
				 _blickrichtung
				;
				private Feld<	Object
				> _parents = new Feld<	Object
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Url.
			*/
				public String
				 getUrl() {
				return _url;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _url der neue Wert von Url.
			*/
			public void setUrl(String
			 _url) {
				if (_url.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._url = _url;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public String
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(String
			 _hersteller) {
				if (_hersteller.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._hersteller = _hersteller;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Seriennummer.
			*/
				public String
				 getSeriennummer() {
				return _seriennummer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _seriennummer der neue Wert von Seriennummer.
			*/
			public void setSeriennummer(String
			 _seriennummer) {
				if (_seriennummer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._seriennummer = _seriennummer;
			}
		
			/**
			Optionaler Verweis auf ein Objekt vom Typ typ.fahrtRichtung.
			<p>
			
			</p>
			
			@return der Wert von Fahrtrichtung.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.objekte.FahrtRichtung
				 getFahrtrichtung() {
				return _fahrtrichtung;
			}
		
			/**
			Optionaler Verweis auf ein Objekt vom Typ typ.fahrtRichtung.
			<p>
			
			</p>
			
			@param _fahrtrichtung der neue Wert von Fahrtrichtung.
			*/
			public void setFahrtrichtung(	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.objekte.FahrtRichtung
			 _fahrtrichtung) {
				this._fahrtrichtung = _fahrtrichtung;
			}
		
			/**
			Float-Wert mit drei Nachkommastellen im Bereich
								0 ° bis
								+359,999 °, zur Darstellung von Winkeln (z.B.
								Blickrichtung,
								Himmerlsrichtung).
			<p>
			
			</p>
			
			@return der Wert von Blickrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
				 getBlickrichtung() {
				return _blickrichtung;
			}
		
			/**
			Float-Wert mit drei Nachkommastellen im Bereich
								0 ° bis
								+359,999 °, zur Darstellung von Winkeln (z.B.
								Blickrichtung,
								Himmerlsrichtung).
			<p>
			
			</p>
			
			@param _blickrichtung der neue Wert von Blickrichtung.
			*/
			public void setBlickrichtung(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
			 _blickrichtung) {
				this._blickrichtung = _blickrichtung;
			}
		
			/**
			Attribut zur Referenzierung von beliebigen Objekten (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@return der Wert von Parents.
			*/
				public Feld<	Object
				> getParents() {
				return _parents;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getUrl() != null) {
						datum.getTextValue("Url").setText(getUrl());
					}
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
					// ZeichenkettenAttributTyp
					if (getHersteller() != null) {
						datum.getTextValue("Hersteller").setText(getHersteller());
					}
					// ZeichenkettenAttributTyp
					if (getSeriennummer() != null) {
						datum.getTextValue("Seriennummer").setText(getSeriennummer());
					}
					// ObjektReferenzAttributTyp
						final Object soFahrtrichtung = getFahrtrichtung();
						final SystemObject tmpFahrtrichtung;
							if (soFahrtrichtung instanceof SystemObject) {
								tmpFahrtrichtung = (SystemObject)soFahrtrichtung;
							} else if(soFahrtrichtung instanceof SystemObjekt){
								tmpFahrtrichtung = ((SystemObjekt)soFahrtrichtung).getSystemObject();
							} else{
								tmpFahrtrichtung = null;
							}
						datum.getReferenceValue("Fahrtrichtung").setSystemObject(tmpFahrtrichtung);
					// GanzzahlAttributTyp
					if (getBlickrichtung() != null) {
		                if (getBlickrichtung().isZustand()) {
		                    datum.getUnscaledValue("Blickrichtung").setText(getBlickrichtung().toString());
		                } else {
							datum.
							getScaledValue
		                	("Blickrichtung").set(getBlickrichtung().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayParents = datum.getReferenceArray("Parents");
						arrayParents.setLength(getParents().size());
						for (int i = 0; i < arrayParents.getLength(); ++i) {
							final Object soParents = getParents().get(i);
							final SystemObject tmpParents;
							if (soParents instanceof SystemObject) {
								tmpParents = (SystemObject)soParents;
							} else if(soParents instanceof SystemObjekt){
								tmpParents = ((SystemObjekt)soParents).getSystemObject();
							} else{
								tmpParents = null;
							}
							arrayParents.getReferenceValue(i).setSystemObject(tmpParents);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setUrl(daten.getTextValue("Url").getText());
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
					// ZeichenkettenAttributTyp
						setHersteller(daten.getTextValue("Hersteller").getText());
					// ZeichenkettenAttributTyp
						setSeriennummer(daten.getTextValue("Seriennummer").getText());
					// ObjektReferenzAttributTyp
						final long idFahrtrichtung = daten.getReferenceValue("Fahrtrichtung").getId();
						final SystemObjekt tmpFahrtrichtung;
						if (idFahrtrichtung == 0) {
							tmpFahrtrichtung = null;
						} else {
							final SystemObject soFahrtrichtung = factory.getDav().getDataModel().getObject(idFahrtrichtung);
							if (soFahrtrichtung == null) {
									tmpFahrtrichtung = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.objekte.impl.FahrtRichtungUngueltig(idFahrtrichtung);
							} else {
								tmpFahrtrichtung = factory.getModellobjekt(soFahrtrichtung);
							}
						}
						setFahrtrichtung((	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.objekte.FahrtRichtung
						) tmpFahrtrichtung);
					// GanzzahlAttributTyp
							setBlickrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttRichtungInGrad
							(daten.
								getScaledValue
							("Blickrichtung").
								doubleValue
							()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayParents = daten.getReferenceArray("Parents");
						for (int i = 0; i < arrayParents.getLength(); ++i) {
							final long idParents = daten.getReferenceArray("Parents").getReferenceValue(i).getId();
							final SystemObjekt tmpParents;
							if (idParents == 0) {
								tmpParents = null;
							} else {
								final SystemObject soParents = factory.getDav().getDataModel().getObject(idParents);
								if (soParents == null) {
										tmpParents = new BaseUngueltigesSystemObjekt(idParents);
								} else {
									tmpParents = factory.getModellobjekt(soParents);
								}
							}
								getParents().add((	Object
								) tmpParents);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setUrl(getUrl());
							klon.setBezeichnung(getBezeichnung());
							klon.setHersteller(getHersteller());
							klon.setSeriennummer(getSeriennummer());
							klon.setFahrtrichtung(getFahrtrichtung());
							klon.setBlickrichtung(getBlickrichtung());
						klon._parents = getParents().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.kamera";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdKamera(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
