/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung eines Wetterberichts- oder
					Wetterwarnungstyps.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlWetterberichtsTyp implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _musterDerKennung
			= new String
			()
			;
			private String
			 _wetterberichtsTypID
			= new String
			()
			;
			private String
			 _displayText
			= new String
			()
			;
			private String
			 _voiceMailText
			= new String
			()
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			> _kindelemente = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			>(0, true);
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von MusterDerKennung.
		*/
			public String
			 getMusterDerKennung() {
			return _musterDerKennung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _musterDerKennung der neue Wert von MusterDerKennung.
		*/
		public void setMusterDerKennung(String
		 _musterDerKennung) {
			if (_musterDerKennung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._musterDerKennung = _musterDerKennung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von WetterberichtsTypID.
		*/
			public String
			 getWetterberichtsTypID() {
			return _wetterberichtsTypID;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _wetterberichtsTypID der neue Wert von WetterberichtsTypID.
		*/
		public void setWetterberichtsTypID(String
		 _wetterberichtsTypID) {
			if (_wetterberichtsTypID.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._wetterberichtsTypID = _wetterberichtsTypID;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von DisplayText.
		*/
			public String
			 getDisplayText() {
			return _displayText;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _displayText der neue Wert von DisplayText.
		*/
		public void setDisplayText(String
		 _displayText) {
			if (_displayText.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._displayText = _displayText;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von VoiceMailText.
		*/
			public String
			 getVoiceMailText() {
			return _voiceMailText;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _voiceMailText der neue Wert von VoiceMailText.
		*/
		public void setVoiceMailText(String
		 _voiceMailText) {
			if (_voiceMailText.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._voiceMailText = _voiceMailText;
		}
	
		/**
		Referenz auf ein Gebiet.
		<p>
		
		</p>
		
		@return der Wert von Kindelemente.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			> getKindelemente() {
			return _kindelemente;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getMusterDerKennung() != null) {
					datum.getTextValue("MusterDerKennung").setText(getMusterDerKennung());
				}
				// ZeichenkettenAttributTyp
				if (getWetterberichtsTypID() != null) {
					datum.getTextValue("WetterberichtsTypID").setText(getWetterberichtsTypID());
				}
				// ZeichenkettenAttributTyp
				if (getDisplayText() != null) {
					datum.getTextValue("DisplayText").setText(getDisplayText());
				}
				// ZeichenkettenAttributTyp
				if (getVoiceMailText() != null) {
					datum.getTextValue("VoiceMailText").setText(getVoiceMailText());
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKindelemente = datum.getReferenceArray("Kindelemente");
					arrayKindelemente.setLength(getKindelemente().size());
					for (int i = 0; i < arrayKindelemente.getLength(); ++i) {
						final Object soKindelemente = getKindelemente().get(i);
						final SystemObject tmpKindelemente;
						if (soKindelemente instanceof SystemObject) {
							tmpKindelemente = (SystemObject)soKindelemente;
						} else if(soKindelemente instanceof SystemObjekt){
							tmpKindelemente = ((SystemObjekt)soKindelemente).getSystemObject();
						} else{
							tmpKindelemente = null;
						}
						arrayKindelemente.getReferenceValue(i).setSystemObject(tmpKindelemente);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setMusterDerKennung(daten.getTextValue("MusterDerKennung").getText());
				// ZeichenkettenAttributTyp
					setWetterberichtsTypID(daten.getTextValue("WetterberichtsTypID").getText());
				// ZeichenkettenAttributTyp
					setDisplayText(daten.getTextValue("DisplayText").getText());
				// ZeichenkettenAttributTyp
					setVoiceMailText(daten.getTextValue("VoiceMailText").getText());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKindelemente = daten.getReferenceArray("Kindelemente");
					for (int i = 0; i < arrayKindelemente.getLength(); ++i) {
						final long idKindelemente = daten.getReferenceArray("Kindelemente").getReferenceValue(i).getId();
						final SystemObjekt tmpKindelemente;
						if (idKindelemente == 0) {
							tmpKindelemente = null;
						} else {
							final SystemObject soKindelemente = factory.getDav().getDataModel().getObject(idKindelemente);
							if (soKindelemente == null) {
									tmpKindelemente = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.impl.SwisGebietUngueltig(idKindelemente);
							} else {
								tmpKindelemente = factory.getModellobjekt(soKindelemente);
							}
						}
							getKindelemente().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
							) tmpKindelemente);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlWetterberichtsTyp clone() {
		AtlWetterberichtsTyp klon = new AtlWetterberichtsTyp();
		
						klon.setMusterDerKennung(getMusterDerKennung());
						klon.setWetterberichtsTypID(getWetterberichtsTypID());
						klon.setDisplayText(getDisplayText());
						klon.setVoiceMailText(getVoiceMailText());
					klon._kindelemente = getKindelemente().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
