/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mapping für die Umsetzung der DWD Zustände auf SWIS
					Zustände.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlZustandsMappingDWD implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _messwertTyp
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute.AtlMappingDWDNachSWIS
			> _mappingDWDNachSWIS = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute.AtlMappingDWDNachSWIS
			>(0, true);
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von MesswertTyp.
		*/
			public String
			 getMesswertTyp() {
			return _messwertTyp;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _messwertTyp der neue Wert von MesswertTyp.
		*/
		public void setMesswertTyp(String
		 _messwertTyp) {
			if (_messwertTyp.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._messwertTyp = _messwertTyp;
		}
	
		/**
		Mapping für einen konkreten Messwerttyp.
		<p>
		
		</p>
		
		@return der Wert von MappingDWDNachSWIS.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute.AtlMappingDWDNachSWIS
			> getMappingDWDNachSWIS() {
			return _mappingDWDNachSWIS;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getMesswertTyp() != null) {
					datum.getTextValue("messwertTyp").setText(getMesswertTyp());
				}
				// AttributListenDefinition
					final Data.Array arrayMappingDWDNachSWIS = datum.getArray("mappingDWDNachSWIS");
					arrayMappingDWDNachSWIS.setLength(getMappingDWDNachSWIS().size());
					for (int i = 0; i < arrayMappingDWDNachSWIS.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute.AtlMappingDWDNachSWIS
						 atl = getMappingDWDNachSWIS().get(i);
						atl.bean2Atl(arrayMappingDWDNachSWIS.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setMesswertTyp(daten.getTextValue("messwertTyp").getText());
				// AttributListenDefinition
					final Data.Array arrayMappingDWDNachSWIS = daten.getArray("mappingDWDNachSWIS");
					for (int i = 0; i < arrayMappingDWDNachSWIS.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute.AtlMappingDWDNachSWIS
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute.AtlMappingDWDNachSWIS
						 ();
						atl.atl2Bean(arrayMappingDWDNachSWIS.getItem(i), factory);
						getMappingDWDNachSWIS().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlZustandsMappingDWD clone() {
		AtlZustandsMappingDWD klon = new AtlZustandsMappingDWD();
		
						klon.setMesswertTyp(getMesswertTyp());
					klon._mappingDWDNachSWIS = getMappingDWDNachSWIS().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
