/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abbildung aller Eigenschaften eines Wetterberichts.
					Mittels Archivabfragen können alle
					Wetterberichte über einen
					gewissen Zeitraum ermittelt werden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class OdWetterbericht extends AbstractOnlineDatensatz<OdWetterbericht.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Empfangen,
				};
			}
	
			/**
			 * Empfangene Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Empfangen = new Aspekte("Empfangen", "asp.empfangen");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _dWDKennung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
				 _gebiet
				;
				private String
				 _wetterberichtsTyp
				= new String
				()
				;
				private String
				 _wetterwarnungsTyp
				= new String
				()
				;
				private 	Zeitstempel
				 _ausgegebenAm
				;
				private String
				 _ausgegebenVon
				= new String
				()
				;
				private Feld<String
				> _gesamttext = new Feld<String
				>(0, true);
				private String
				 _dateiname
				= new String
				()
				;
				private 	Zeitstempel
				 _gueltigAb
				;
				private 	Zeitstempel
				 _gueltigBis
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von DWDKennung.
			*/
				public String
				 getDWDKennung() {
				return _dWDKennung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _dWDKennung der neue Wert von DWDKennung.
			*/
			public void setDWDKennung(String
			 _dWDKennung) {
				if (_dWDKennung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._dWDKennung = _dWDKennung;
			}
		
			/**
			Optionale Referenz auf ein Gebiet.
			<p>
			
			</p>
			
			@return der Wert von Gebiet.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
				 getGebiet() {
				return _gebiet;
			}
		
			/**
			Optionale Referenz auf ein Gebiet.
			<p>
			
			</p>
			
			@param _gebiet der neue Wert von Gebiet.
			*/
			public void setGebiet(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			 _gebiet) {
				this._gebiet = _gebiet;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von WetterberichtsTyp.
			*/
				public String
				 getWetterberichtsTyp() {
				return _wetterberichtsTyp;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _wetterberichtsTyp der neue Wert von WetterberichtsTyp.
			*/
			public void setWetterberichtsTyp(String
			 _wetterberichtsTyp) {
				if (_wetterberichtsTyp.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._wetterberichtsTyp = _wetterberichtsTyp;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von WetterwarnungsTyp.
			*/
				public String
				 getWetterwarnungsTyp() {
				return _wetterwarnungsTyp;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _wetterwarnungsTyp der neue Wert von WetterwarnungsTyp.
			*/
			public void setWetterwarnungsTyp(String
			 _wetterwarnungsTyp) {
				if (_wetterwarnungsTyp.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._wetterwarnungsTyp = _wetterwarnungsTyp;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@return der Wert von AusgegebenAm.
			*/
				public 	Zeitstempel
				 getAusgegebenAm() {
				return _ausgegebenAm;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@param _ausgegebenAm der neue Wert von AusgegebenAm.
			*/
			public void setAusgegebenAm(	Zeitstempel
			 _ausgegebenAm) {
				this._ausgegebenAm = _ausgegebenAm;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von AusgegebenVon.
			*/
				public String
				 getAusgegebenVon() {
				return _ausgegebenVon;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _ausgegebenVon der neue Wert von AusgegebenVon.
			*/
			public void setAusgegebenVon(String
			 _ausgegebenVon) {
				if (_ausgegebenVon.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ausgegebenVon = _ausgegebenVon;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Gesamttext.
			*/
				public Feld<String
				> getGesamttext() {
				return _gesamttext;
			}
		
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Dateiname.
			*/
				public String
				 getDateiname() {
				return _dateiname;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _dateiname der neue Wert von Dateiname.
			*/
			public void setDateiname(String
			 _dateiname) {
				if (_dateiname.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._dateiname = _dateiname;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@return der Wert von GueltigAb.
			*/
				public 	Zeitstempel
				 getGueltigAb() {
				return _gueltigAb;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@param _gueltigAb der neue Wert von GueltigAb.
			*/
			public void setGueltigAb(	Zeitstempel
			 _gueltigAb) {
				this._gueltigAb = _gueltigAb;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@return der Wert von GueltigBis.
			*/
				public 	Zeitstempel
				 getGueltigBis() {
				return _gueltigBis;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@param _gueltigBis der neue Wert von GueltigBis.
			*/
			public void setGueltigBis(	Zeitstempel
			 _gueltigBis) {
				this._gueltigBis = _gueltigBis;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getDWDKennung() != null) {
						datum.getTextValue("DWDKennung").setText(getDWDKennung());
					}
					// ObjektReferenzAttributTyp
						final Object soGebiet = getGebiet();
						final SystemObject tmpGebiet;
							if (soGebiet instanceof SystemObject) {
								tmpGebiet = (SystemObject)soGebiet;
							} else if(soGebiet instanceof SystemObjekt){
								tmpGebiet = ((SystemObjekt)soGebiet).getSystemObject();
							} else{
								tmpGebiet = null;
							}
						datum.getReferenceValue("Gebiet").setSystemObject(tmpGebiet);
					// ZeichenkettenAttributTyp
					if (getWetterberichtsTyp() != null) {
						datum.getTextValue("WetterberichtsTyp").setText(getWetterberichtsTyp());
					}
					// ZeichenkettenAttributTyp
					if (getWetterwarnungsTyp() != null) {
						datum.getTextValue("WetterwarnungsTyp").setText(getWetterwarnungsTyp());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("AusgegebenAm").setMillis(getAusgegebenAm().getTime());
					// ZeichenkettenAttributTyp
					if (getAusgegebenVon() != null) {
						datum.getTextValue("AusgegebenVon").setText(getAusgegebenVon());
					}
					// ZeichenkettenAttributTyp
					if (getGesamttext() != null) {
						final Data.TextArray arrayGesamttext = datum.getTextArray("Gesamttext");
						arrayGesamttext.setLength(getGesamttext().size());
						for (int i = 0; i < arrayGesamttext.getLength(); ++i) {
							arrayGesamttext.getTextValue(i).setText(getGesamttext().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getDateiname() != null) {
						datum.getTextValue("Dateiname").setText(getDateiname());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("GültigAb").setMillis(getGueltigAb().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("GültigBis").setMillis(getGueltigBis().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setDWDKennung(daten.getTextValue("DWDKennung").getText());
					// ObjektReferenzAttributTyp
						final long idGebiet = daten.getReferenceValue("Gebiet").getId();
						final SystemObjekt tmpGebiet;
						if (idGebiet == 0) {
							tmpGebiet = null;
						} else {
							final SystemObject soGebiet = factory.getDav().getDataModel().getObject(idGebiet);
							if (soGebiet == null) {
									tmpGebiet = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.impl.SwisGebietUngueltig(idGebiet);
							} else {
								tmpGebiet = factory.getModellobjekt(soGebiet);
							}
						}
						setGebiet((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
						) tmpGebiet);
					// ZeichenkettenAttributTyp
						setWetterberichtsTyp(daten.getTextValue("WetterberichtsTyp").getText());
					// ZeichenkettenAttributTyp
						setWetterwarnungsTyp(daten.getTextValue("WetterwarnungsTyp").getText());
					// ZeitstempelAttributTyp
						setAusgegebenAm(new
							Zeitstempel
							(daten.getTimeValue("AusgegebenAm").getMillis()));
					// ZeichenkettenAttributTyp
						setAusgegebenVon(daten.getTextValue("AusgegebenVon").getText());
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayGesamttext = daten.getTextArray("Gesamttext");
						for (int i = 0; i < arrayGesamttext.getLength(); ++i) {
							getGesamttext().add(arrayGesamttext.getText(i));
						}
					// ZeichenkettenAttributTyp
						setDateiname(daten.getTextValue("Dateiname").getText());
					// ZeitstempelAttributTyp
						setGueltigAb(new
							Zeitstempel
							(daten.getTimeValue("GültigAb").getMillis()));
					// ZeitstempelAttributTyp
						setGueltigBis(new
							Zeitstempel
							(daten.getTimeValue("GültigBis").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDWDKennung(getDWDKennung());
							klon.setGebiet(getGebiet());
							klon.setWetterberichtsTyp(getWetterberichtsTyp());
							klon.setWetterwarnungsTyp(getWetterwarnungsTyp());
							klon.setAusgegebenAm(getAusgegebenAm());
							klon.setAusgegebenVon(getAusgegebenVon());
						klon._gesamttext = getGesamttext().clone();
							klon.setDateiname(getDateiname());
							klon.setGueltigAb(getGueltigAb());
							klon.setGueltigBis(getGueltigBis());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.wetterbericht";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdWetterbericht(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
