/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung eines Menüeintrags.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlMenueEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _pid
			= new String
			()
			;
			private String
			 _name
			= new String
			()
			;
			private Feld<String
			> _unterMenue = new Feld<String
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AtlFilter
			> _filter = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AtlFilter
			>(0, true);
	
		/**
		Eindeutige Pid eines Menüeintrags. Wird zur Referenzierung bei der Beschreibung des Gesamtmenüs erwendet.
		<p>
		
		</p>
		
		@return der Wert von Pid.
		*/
			public String
			 getPid() {
			return _pid;
		}
	
		/**
		Eindeutige Pid eines Menüeintrags. Wird zur Referenzierung bei der Beschreibung des Gesamtmenüs erwendet.
		<p>
		
		</p>
		
		@param _pid der neue Wert von Pid.
		*/
		public void setPid(String
		 _pid) {
			if (_pid.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._pid = _pid;
		}
	
		/**
		Name eines Menüeintrags. Wird zur Darstellung verwendet.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name eines Menüeintrags. Wird zur Darstellung verwendet.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Verweis auf einen definierten Menüeintrag über die Pid eines Menüeintrags.
		<p>
		
		</p>
		
		@return der Wert von UnterMenue.
		*/
			public Feld<String
			> getUnterMenue() {
			return _unterMenue;
		}
	
	
		/**
		Beschreibung eins Filters zur Datenauswahl.
		<p>
		
		</p>
		
		@return der Wert von Filter.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AtlFilter
			> getFilter() {
			return _filter;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getPid() != null) {
					datum.getTextValue("Pid").setText(getPid());
				}
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getUnterMenue() != null) {
					final Data.TextArray arrayUnterMenue = datum.getTextArray("UnterMenü");
					arrayUnterMenue.setLength(getUnterMenue().size());
					for (int i = 0; i < arrayUnterMenue.getLength(); ++i) {
						arrayUnterMenue.getTextValue(i).setText(getUnterMenue().get(i));
					}
				}
				// AttributListenDefinition
					final Data.Array arrayFilter = datum.getArray("Filter");
					arrayFilter.setLength(getFilter().size());
					for (int i = 0; i < arrayFilter.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AtlFilter
						 atl = getFilter().get(i);
						atl.bean2Atl(arrayFilter.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setPid(daten.getTextValue("Pid").getText());
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayUnterMenue = daten.getTextArray("UnterMenü");
					for (int i = 0; i < arrayUnterMenue.getLength(); ++i) {
						getUnterMenue().add(arrayUnterMenue.getText(i));
					}
				// AttributListenDefinition
					final Data.Array arrayFilter = daten.getArray("Filter");
					for (int i = 0; i < arrayFilter.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AtlFilter
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AtlFilter
						 ();
						atl.atl2Bean(arrayFilter.getItem(i), factory);
						getFilter().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMenueEintrag clone() {
		AtlMenueEintrag klon = new AtlMenueEintrag();
		
						klon.setPid(getPid());
						klon.setName(getName());
					klon._unterMenue = getUnterMenue().clone();
					klon._filter = getFilter().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
