/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung der OberflächenBerechtigung.
<p>
Hier wird die Oberflächenberechtigung beschrieben.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AtlOberflaechenBerechtigung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<String
			> _berechtigungsklasse = new Feld<String
			>(0, true);
			private Feld<String
			> _funktion = new Feld<String
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttOberflaechenBerechtigung
			 _berechtigung
			;
			private Feld<String
			> _objektMenge = new Feld<String
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _ausnahmeDefinition
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _ebene
			;
	
		/**
		Berechtigungsklasse der Definition (Wer).
		<p>
		Dieses Feld gibt an, für welche Berechtigungsklasse die Definition gilt.
								Hier können eine oder mehrere Berechtigungsklassen angegeben werden, der Stern
								wird stellvertretend für alle Berechtigungsklassen verwendet.
		</p>
		
		@return der Wert von Berechtigungsklasse.
		*/
			public Feld<String
			> getBerechtigungsklasse() {
			return _berechtigungsklasse;
		}
	
	
		/**
		Funktion (Was).
		<p>
		In diesem Feld wird die Funktion definiert, für die die Berechtigung vergeben wird.
								Ein * kann stellvertretend für alle Funktionen verwendet werden.
		</p>
		
		@return der Wert von Funktion.
		*/
			public Feld<String
			> getFunktion() {
			return _funktion;
		}
	
	
		/**
		Freigabe oder Sperrung (Wie).
		<p>
		In diesem Feld wird die Logik der Definition angegeben. Sperrung bedeutet, das den im 
								vorigen	Feld angegebenen Berechtigungsklassen die folgend definierten Funktionen auf
								den festgelegten Objekten nicht erlaubt werden. Freigabe heißt hingegen, dass die
								Berechtigungsklassen das Recht erhalten, diese Funktion auszuführen.
		</p>
		
		@return der Wert von Berechtigung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttOberflaechenBerechtigung
			 getBerechtigung() {
			return _berechtigung;
		}
	
		/**
		Freigabe oder Sperrung (Wie).
		<p>
		In diesem Feld wird die Logik der Definition angegeben. Sperrung bedeutet, das den im 
								vorigen	Feld angegebenen Berechtigungsklassen die folgend definierten Funktionen auf
								den festgelegten Objekten nicht erlaubt werden. Freigabe heißt hingegen, dass die
								Berechtigungsklassen das Recht erhalten, diese Funktion auszuführen.
		</p>
		
		@param _berechtigung der neue Wert von Berechtigung.
		*/
		public void setBerechtigung(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttOberflaechenBerechtigung
		 _berechtigung) {
			this._berechtigung = _berechtigung;
		}
	
		/**
		Objekte, auf welche diese Berechtigungsdefinition angewendet wird. (Worauf).
		<p>
		Dieses Feld dient der Spezifikation der betroffenen Objekte und&#47;oder Mengen auf denen
								die Funktion arbeitet. Der * kann stellvertretend für alle Objekte verwendet werden.
		</p>
		
		@return der Wert von ObjektMenge.
		*/
			public Feld<String
			> getObjektMenge() {
			return _objektMenge;
		}
	
	
		/**
		Index der Definition der Ausnahmen.
		<p>
		In diesem Feld wird eine Definition angegeben, die einschränkend gelesen wird. Die Definition wird durch den Feldindex unterhalb von Oberflächenberechtigung angegeben.
		</p>
		
		@return der Wert von AusnahmeDefinition.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getAusnahmeDefinition() {
			return _ausnahmeDefinition;
		}
	
		/**
		Index der Definition der Ausnahmen.
		<p>
		In diesem Feld wird eine Definition angegeben, die einschränkend gelesen wird. Die Definition wird durch den Feldindex unterhalb von Oberflächenberechtigung angegeben.
		</p>
		
		@param _ausnahmeDefinition der neue Wert von AusnahmeDefinition.
		*/
		public void setAusnahmeDefinition(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _ausnahmeDefinition) {
			this._ausnahmeDefinition = _ausnahmeDefinition;
		}
	
		/**
		Gibt die Tiefe der Ausnahmenrekursion an.
		<p>
		Mit diesem Attribut wird die geparste Tiefe der Ausnahmen angegeben. Ebene 0 entspricht
								einer einfachen Ausnahme. Hat diese Ausnahme eine Ausnahme, dann befindet diese sich auf
								Ebene 1. Hat diese Ausnahme wiederum eine Ausnahme, befindet diese sich auf Ebene 2 u.s.w.
		</p>
		
		@return der Wert von Ebene.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getEbene() {
			return _ebene;
		}
	
		/**
		Gibt die Tiefe der Ausnahmenrekursion an.
		<p>
		Mit diesem Attribut wird die geparste Tiefe der Ausnahmen angegeben. Ebene 0 entspricht
								einer einfachen Ausnahme. Hat diese Ausnahme eine Ausnahme, dann befindet diese sich auf
								Ebene 1. Hat diese Ausnahme wiederum eine Ausnahme, befindet diese sich auf Ebene 2 u.s.w.
		</p>
		
		@param _ebene der neue Wert von Ebene.
		*/
		public void setEbene(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _ebene) {
			this._ebene = _ebene;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBerechtigungsklasse() != null) {
					final Data.TextArray arrayBerechtigungsklasse = datum.getTextArray("Berechtigungsklasse");
					arrayBerechtigungsklasse.setLength(getBerechtigungsklasse().size());
					for (int i = 0; i < arrayBerechtigungsklasse.getLength(); ++i) {
						arrayBerechtigungsklasse.getTextValue(i).setText(getBerechtigungsklasse().get(i));
					}
				}
				// ZeichenkettenAttributTyp
				if (getFunktion() != null) {
					final Data.TextArray arrayFunktion = datum.getTextArray("Funktion");
					arrayFunktion.setLength(getFunktion().size());
					for (int i = 0; i < arrayFunktion.getLength(); ++i) {
						arrayFunktion.getTextValue(i).setText(getFunktion().get(i));
					}
				}
				// GanzzahlAttributTyp
				if (getBerechtigung() != null) {
	                if (getBerechtigung().isZustand()) {
	                    datum.getUnscaledValue("Berechtigung").setText(getBerechtigung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Berechtigung").set(getBerechtigung().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getObjektMenge() != null) {
					final Data.TextArray arrayObjektMenge = datum.getTextArray("ObjektMenge");
					arrayObjektMenge.setLength(getObjektMenge().size());
					for (int i = 0; i < arrayObjektMenge.getLength(); ++i) {
						arrayObjektMenge.getTextValue(i).setText(getObjektMenge().get(i));
					}
				}
				// GanzzahlAttributTyp
				if (getAusnahmeDefinition() != null) {
	                if (getAusnahmeDefinition().isZustand()) {
	                    datum.getUnscaledValue("AusnahmeDefinition").setText(getAusnahmeDefinition().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AusnahmeDefinition").set(getAusnahmeDefinition().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEbene() != null) {
	                if (getEbene().isZustand()) {
	                    datum.getUnscaledValue("Ebene").setText(getEbene().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Ebene").set(getEbene().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayBerechtigungsklasse = daten.getTextArray("Berechtigungsklasse");
					for (int i = 0; i < arrayBerechtigungsklasse.getLength(); ++i) {
						getBerechtigungsklasse().add(arrayBerechtigungsklasse.getText(i));
					}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayFunktion = daten.getTextArray("Funktion");
					for (int i = 0; i < arrayFunktion.getLength(); ++i) {
						getFunktion().add(arrayFunktion.getText(i));
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Berechtigung").isState()) {
							setBerechtigung(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttOberflaechenBerechtigung
							.getZustand(daten.getScaledValue("Berechtigung").getText()));
						} else {
						setBerechtigung(new de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttOberflaechenBerechtigung
						(daten.
							getUnscaledValue
						("Berechtigung").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayObjektMenge = daten.getTextArray("ObjektMenge");
					for (int i = 0; i < arrayObjektMenge.getLength(); ++i) {
						getObjektMenge().add(arrayObjektMenge.getText(i));
					}
				// GanzzahlAttributTyp
						setAusnahmeDefinition(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("AusnahmeDefinition").
								longValue
						()));
				// GanzzahlAttributTyp
						setEbene(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("Ebene").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlOberflaechenBerechtigung clone() {
		AtlOberflaechenBerechtigung klon = new AtlOberflaechenBerechtigung();
		
					klon._berechtigungsklasse = getBerechtigungsklasse().clone();
					klon._funktion = getFunktion().clone();
						klon.setBerechtigung(getBerechtigung());
					klon._objektMenge = getObjektMenge().clone();
						klon.setAusnahmeDefinition(getAusnahmeDefinition());
						klon.setEbene(getEbene());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
