/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Berechtigungen in der Oberfläche. Gibt die Logik der Definition an: Sperrung bedeutet, dass den im
					vorigen Feld angegebenen Berechtigungsklassen die folgend definierten Funktionen auf den festgelegten
					Objekten nicht erlaubt werden. Freigabe heißt hingegen, dass die Berechtigungsklassen das Recht erhalten,
					diese Funktionen auszuführen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AttOberflaechenBerechtigung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Sperrung der Funktion für die jeweilige Berechtigungsklasse.
	<p>
	
	</p>
	*/
	public static final AttOberflaechenBerechtigung ZUSTAND_0_SPERRUNG = new AttOberflaechenBerechtigung("Sperrung", 		Short
	.valueOf("0"));

	/**
	Freigabe der Funktion für die jeweilige Berechtigungsklasse.
	<p>
	
	</p>
	*/
	public static final AttOberflaechenBerechtigung ZUSTAND_1_FREIGABE = new AttOberflaechenBerechtigung("Freigabe", 		Short
	.valueOf("1"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttOberflaechenBerechtigung getZustand(final 		Short
	 value) {
		for (AttOberflaechenBerechtigung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttOberflaechenBerechtigung getZustand(final String value) {
		for (AttOberflaechenBerechtigung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttOberflaechenBerechtigung> getZustaende() {
		List<AttOberflaechenBerechtigung> list = new ArrayList<AttOberflaechenBerechtigung>();
		list.add(ZUSTAND_0_SPERRUNG);
		list.add(ZUSTAND_1_FREIGABE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut OberflächenBerechtigung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttOberflaechenBerechtigung(final 		Short
	 value) {
		super(value);
	}
	
	private AttOberflaechenBerechtigung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
