/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ des Anzeigeelementes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AttDaqAnzeigeElementTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Frühere zusätzliche Namen 'Label'.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_1_LABEL_ALLGEMEIN = new AttDaqAnzeigeElementTyp("Label, allgemein", 		Byte
	.valueOf("1"));

	/**
	Wechselprisma.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_2_PRISMA = new AttDaqAnzeigeElementTyp("Prisma", 		Byte
	.valueOf("2"));

	/**
	Freitextanzeige.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_3_FTA = new AttDaqAnzeigeElementTyp("FTA", 		Byte
	.valueOf("3"));

	/**
	Blinker.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_4_BLINKER = new AttDaqAnzeigeElementTyp("Blinker", 		Byte
	.valueOf("4"));

	/**
	Label, Autobahn.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_6_LABEL_AUTOBAHN = new AttDaqAnzeigeElementTyp("Label, Autobahn", 		Byte
	.valueOf("6"));

	/**
	Label, Bundesstraße.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_7_LABEL_BUNDESSTRASSE = new AttDaqAnzeigeElementTyp("Label, Bundesstraße", 		Byte
	.valueOf("7"));

	/**
	Label, innerorts.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_8_LABEL_INNERORTS = new AttDaqAnzeigeElementTyp("Label, innerorts", 		Byte
	.valueOf("8"));

	/**
	WVZ-Anzeige Typ B.
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeElementTyp ZUSTAND_9_WVZ_B = new AttDaqAnzeigeElementTyp("WVZ_B", 		Byte
	.valueOf("9"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDaqAnzeigeElementTyp getZustand(final 		Byte
	 value) {
		for (AttDaqAnzeigeElementTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDaqAnzeigeElementTyp getZustand(final String value) {
		for (AttDaqAnzeigeElementTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDaqAnzeigeElementTyp> getZustaende() {
		List<AttDaqAnzeigeElementTyp> list = new ArrayList<AttDaqAnzeigeElementTyp>();
		list.add(ZUSTAND_1_LABEL_ALLGEMEIN);
		list.add(ZUSTAND_2_PRISMA);
		list.add(ZUSTAND_3_FTA);
		list.add(ZUSTAND_4_BLINKER);
		list.add(ZUSTAND_6_LABEL_AUTOBAHN);
		list.add(ZUSTAND_7_LABEL_BUNDESSTRASSE);
		list.add(ZUSTAND_8_LABEL_INNERORTS);
		list.add(ZUSTAND_9_WVZ_B);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AnzeigeElementTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDaqAnzeigeElementTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttDaqAnzeigeElementTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
