/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Farbpalette für Anzeigeobjekte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttDaqAnzeigeFarbe extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_0_SCHWARZ = new AttDaqAnzeigeFarbe("Schwarz", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_1_BLAU = new AttDaqAnzeigeFarbe("Blau", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_2_GRUEN = new AttDaqAnzeigeFarbe("Grün", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_3_CYAN = new AttDaqAnzeigeFarbe("Cyan", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_4_ROT = new AttDaqAnzeigeFarbe("Rot", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_5_MAGENTA = new AttDaqAnzeigeFarbe("Magenta", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_6_GELB = new AttDaqAnzeigeFarbe("Gelb", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_7_WEISS = new AttDaqAnzeigeFarbe("Weiß", 		Short
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_8_GRAU = new AttDaqAnzeigeFarbe("Grau", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_9_HELLBLAU = new AttDaqAnzeigeFarbe("Hellblau", 		Short
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_10_HELLGRUEN = new AttDaqAnzeigeFarbe("Hellgrün", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_11_HELLCYAN = new AttDaqAnzeigeFarbe("Hellcyan", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_12_HELLROT = new AttDaqAnzeigeFarbe("Hellrot", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_13_HELLMAGENTA = new AttDaqAnzeigeFarbe("Hellmagenta", 		Short
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_14_HELLGELB = new AttDaqAnzeigeFarbe("Hellgelb", 		Short
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_15_WEISS_LEUCHTEND = new AttDaqAnzeigeFarbe("Weiß, leuchtend", 		Short
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDaqAnzeigeFarbe ZUSTAND_255_UNDEFINIERT = new AttDaqAnzeigeFarbe("undefiniert", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDaqAnzeigeFarbe getZustand(final 		Short
	 value) {
		for (AttDaqAnzeigeFarbe e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDaqAnzeigeFarbe getZustand(final String value) {
		for (AttDaqAnzeigeFarbe e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDaqAnzeigeFarbe> getZustaende() {
		List<AttDaqAnzeigeFarbe> list = new ArrayList<AttDaqAnzeigeFarbe>();
		list.add(ZUSTAND_0_SCHWARZ);
		list.add(ZUSTAND_1_BLAU);
		list.add(ZUSTAND_2_GRUEN);
		list.add(ZUSTAND_3_CYAN);
		list.add(ZUSTAND_4_ROT);
		list.add(ZUSTAND_5_MAGENTA);
		list.add(ZUSTAND_6_GELB);
		list.add(ZUSTAND_7_WEISS);
		list.add(ZUSTAND_8_GRAU);
		list.add(ZUSTAND_9_HELLBLAU);
		list.add(ZUSTAND_10_HELLGRUEN);
		list.add(ZUSTAND_11_HELLCYAN);
		list.add(ZUSTAND_12_HELLROT);
		list.add(ZUSTAND_13_HELLMAGENTA);
		list.add(ZUSTAND_14_HELLGELB);
		list.add(ZUSTAND_15_WEISS_LEUCHTEND);
		list.add(ZUSTAND_255_UNDEFINIERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AnzeigeFarbe.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDaqAnzeigeFarbe(final 		Short
	 value) {
		super(value);
	}
	
	private AttDaqAnzeigeFarbe(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
