/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ausrichtung des Schriftsatzes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AttDaqSchriftsatzAusrichtung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Neu eingeführt, hatte früher Wert 1 (siehe Info bei Wert 1).
	<p>
	
	</p>
	*/
	public static final AttDaqSchriftsatzAusrichtung ZUSTAND_0_UNDEFINIERT = new AttDaqSchriftsatzAusrichtung("undefiniert", 		Byte
	.valueOf("0"));

	/**
	Frühere zusätzliche Namen 'L', 'B', 'undefiniert'.
	<p>
	
	</p>
	*/
	public static final AttDaqSchriftsatzAusrichtung ZUSTAND_1_LINKSBUENDIG = new AttDaqSchriftsatzAusrichtung("Linksbündig", 		Byte
	.valueOf("1"));

	/**
	Frühere zusätzliche Namen 'Z'.
	<p>
	
	</p>
	*/
	public static final AttDaqSchriftsatzAusrichtung ZUSTAND_2_ZENTRIERT = new AttDaqSchriftsatzAusrichtung("Zentriert", 		Byte
	.valueOf("2"));

	/**
	Frühere zusätzliche Namen 'R'.
	<p>
	
	</p>
	*/
	public static final AttDaqSchriftsatzAusrichtung ZUSTAND_3_RECHTSBUENDIG = new AttDaqSchriftsatzAusrichtung("Rechtsbündig", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDaqSchriftsatzAusrichtung getZustand(final 		Byte
	 value) {
		for (AttDaqSchriftsatzAusrichtung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDaqSchriftsatzAusrichtung getZustand(final String value) {
		for (AttDaqSchriftsatzAusrichtung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDaqSchriftsatzAusrichtung> getZustaende() {
		List<AttDaqSchriftsatzAusrichtung> list = new ArrayList<AttDaqSchriftsatzAusrichtung>();
		list.add(ZUSTAND_0_UNDEFINIERT);
		list.add(ZUSTAND_1_LINKSBUENDIG);
		list.add(ZUSTAND_2_ZENTRIERT);
		list.add(ZUSTAND_3_RECHTSBUENDIG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut SchriftsatzAusrichtung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDaqSchriftsatzAusrichtung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttDaqSchriftsatzAusrichtung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
