/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anzeigegrafik einer Anzeigefläche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AttDaqSymbol extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Frühere zusätzliche Namen 'S1'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_1_AUTOBAHN = new AttDaqSymbol("Autobahn", 		Short
	.valueOf("1"));

	/**
	Frühere zusätzliche Namen 'S2'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_2_AUTOHOF = new AttDaqSymbol("Autohof", 		Short
	.valueOf("2"));

	/**
	Frühere zusätzliche Namen 'S3'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_3_AUTOZUG = new AttDaqSymbol("Autozug", 		Short
	.valueOf("3"));

	/**
	Frühere zusätzliche Namen 'S4'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_4_BAB_AUSFAHRT = new AttDaqSymbol("BAB-Ausfahrt", 		Short
	.valueOf("4"));

	/**
	Frühere zusätzliche Namen 'S5'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_5_BAB_KREUZ_DREIECK = new AttDaqSymbol("BAB-Kreuz/Dreieck", 		Short
	.valueOf("5"));

	/**
	Frühere zusätzliche Namen 'S6'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_6_BAHNHOF = new AttDaqSymbol("Bahnhof", 		Short
	.valueOf("6"));

	/**
	Frühere zusätzliche Namen 'S7'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_7_BEHINDERTEN_WC = new AttDaqSymbol("Behinderten-WC", 		Short
	.valueOf("7"));

	/**
	Frühere zusätzliche Namen 'S8'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_8_BUS = new AttDaqSymbol("Bus", 		Short
	.valueOf("8"));

	/**
	Frühere zusätzliche Namen 'S9'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_9_ERSTE_HILFE = new AttDaqSymbol("Erste Hilfe", 		Short
	.valueOf("9"));

	/**
	Frühere zusätzliche Namen 'S10'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_10_FERNSPRECHER = new AttDaqSymbol("Fernsprecher", 		Short
	.valueOf("10"));

	/**
	Frühere zusätzliche Namen 'S11a'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_11_FLUGHAFEN_RECHTS = new AttDaqSymbol("Flughafen rechts", 		Short
	.valueOf("11"));

	/**
	Frühere zusätzliche Namen 'S11b'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_12_FLUGHAFEN_GERADEAUS = new AttDaqSymbol("Flughafen geradeaus", 		Short
	.valueOf("12"));

	/**
	Frühere zusätzliche Namen 'S12'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_13_FREIZEITSPORTANLAGE = new AttDaqSymbol("Freizeitsportanlage", 		Short
	.valueOf("13"));

	/**
	Frühere zusätzliche Namen 'S13'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_14_GASTHAUS = new AttDaqSymbol("Gasthaus", 		Short
	.valueOf("14"));

	/**
	Frühere zusätzliche Namen 'S14'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_15_GUETERVERKEHRSZENTRUM = new AttDaqSymbol("Güterverkehrszentrum", 		Short
	.valueOf("15"));

	/**
	Frühere zusätzliche Namen 'S15'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_16_HAFEN_FAEHRE = new AttDaqSymbol("Hafen/Fähre", 		Short
	.valueOf("16"));

	/**
	Frühere zusätzliche Namen 'S16'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_17_INDUSTRIEGEBIET = new AttDaqSymbol("Industriegebiet", 		Short
	.valueOf("17"));

	/**
	Frühere zusätzliche Namen 'S17'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_18_INFORMATIONSSTELLE = new AttDaqSymbol("Informationsstelle", 		Short
	.valueOf("18"));

	/**
	Frühere zusätzliche Namen 'S18'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_19_KIRCHE = new AttDaqSymbol("Kirche", 		Short
	.valueOf("19"));

	/**
	Frühere zusätzliche Namen 'S19'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_20_KRANKENHAUS = new AttDaqSymbol("Krankenhaus", 		Short
	.valueOf("20"));

	/**
	Frühere zusätzliche Namen 'S20'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_21_LKW = new AttDaqSymbol("Lkw", 		Short
	.valueOf("21"));

	/**
	Frühere zusätzliche Namen 'S21'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_22_LKW_MIT_ANHAENGER = new AttDaqSymbol("Lkw mit Anhänger", 		Short
	.valueOf("22"));

	/**
	Frühere zusätzliche Namen 'S22'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_23_MOTEL_HOTEL = new AttDaqSymbol("Motel/Hotel", 		Short
	.valueOf("23"));

	/**
	Frühere zusätzliche Namen 'S23'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_24_NOTRUFSAEULE = new AttDaqSymbol("Notrufsäule", 		Short
	.valueOf("24"));

	/**
	Frühere zusätzliche Namen 'S24', 'P+R'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_25_PARK_UND_RIDE = new AttDaqSymbol("Park und Ride", 		Short
	.valueOf("25"));

	/**
	Frühere zusätzliche Namen 'S25'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_26_PARKHAUS = new AttDaqSymbol("Parkhaus", 		Short
	.valueOf("26"));

	/**
	Frühere zusätzliche Namen 'S26'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_27_PARKPLATZ = new AttDaqSymbol("Parkplatz", 		Short
	.valueOf("27"));

	/**
	Frühere zusätzliche Namen 'S27'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_28_PKW = new AttDaqSymbol("Pkw", 		Short
	.valueOf("28"));

	/**
	Frühere zusätzliche Namen 'S28'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_29_PKW_MIT_ANHAENGER = new AttDaqSymbol("Pkw mit Anhänger", 		Short
	.valueOf("29"));

	/**
	Frühere zusätzliche Namen 'S29'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_30_POLIZEI = new AttDaqSymbol("Polizei", 		Short
	.valueOf("30"));

	/**
	Frühere zusätzliche Namen 'S30'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_31_ROLLSTUHLFAHRER = new AttDaqSymbol("Rollstuhlfahrer", 		Short
	.valueOf("31"));

	/**
	Frühere zusätzliche Namen 'S31'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_32_STADION = new AttDaqSymbol("Stadion", 		Short
	.valueOf("32"));

	/**
	Frühere zusätzliche Namen 'S32'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_33_TANKSTELLE = new AttDaqSymbol("Tankstelle", 		Short
	.valueOf("33"));

	/**
	Frühere zusätzliche Namen 'S33'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_34_TOILETTEN = new AttDaqSymbol("Toiletten", 		Short
	.valueOf("34"));

	/**
	Frühere zusätzliche Namen 'S34'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_35_VERKAUFSKIOSK = new AttDaqSymbol("Verkaufskiosk", 		Short
	.valueOf("35"));

	/**
	Frühere zusätzliche Namen 'S35'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_36_WERKSTATT = new AttDaqSymbol("Werkstatt", 		Short
	.valueOf("36"));

	/**
	Frühere zusätzliche Namen 'S36'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_37_ZELT_WOHNWAGENPLATZ = new AttDaqSymbol("Zelt-/Wohnwagenplatz", 		Short
	.valueOf("37"));

	/**
	Frühere zusätzliche Namen 'S37'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_38_ZENTRUM = new AttDaqSymbol("Zentrum", 		Short
	.valueOf("38"));

	/**
	Frühere zusätzliche Namen 'S38'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_39_FUSSBALL = new AttDaqSymbol("Fußball", 		Short
	.valueOf("39"));

	/**
	Frühere zusätzliche Namen 'P1'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_40_GERADEAUSPFEIL_KURZ = new AttDaqSymbol("Geradeauspfeil, kurz", 		Short
	.valueOf("40"));

	/**
	Frühere zusätzliche Namen 'P2'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_41_SCHRAEGPFEIL_RECHTS_KURZ = new AttDaqSymbol("Schrägpfeil rechts, kurz", 		Short
	.valueOf("41"));

	/**
	Frühere zusätzliche Namen 'P3a'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_42_GERADEAUSPFEIL_LANG_KONISCH = new AttDaqSymbol("Geradeauspfeil lang, konisch", 		Short
	.valueOf("42"));

	/**
	Frühere zusätzliche Namen 'P3b'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_43_SCHRAEGPFEIL_RECHTS_LANG_KONISCH = new AttDaqSymbol("Schrägpfeil rechts, lang, konisch", 		Short
	.valueOf("43"));

	/**
	Frühere zusätzliche Namen 'P3c'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_44_QUERPFEIL_RECHTS_LANG_KONISCH = new AttDaqSymbol("Querpfeil rechts, lang, konisch", 		Short
	.valueOf("44"));

	/**
	Frühere zusätzliche Namen 'P3d'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_45_GERADEAUSPFEIL_LANG = new AttDaqSymbol("Geradeauspfeil, lang", 		Short
	.valueOf("45"));

	/**
	Frühere zusätzliche Namen 'P3e'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_46_GERADEAUS_SCHRAEGPFEIL_RECHTS_LANG = new AttDaqSymbol("Geradeaus+Schrägpfeil rechts, lang", 		Short
	.valueOf("46"));

	/**
	Frühere zusätzliche Namen 'P3f'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_47_GERADEAUS_SCHRAEGPFEIL_RECHTS_LANG_GEBOGEN = new AttDaqSymbol("Geradeaus+Schrägpfeil rechts, lang, gebogen", 		Short
	.valueOf("47"));

	/**
	Frühere zusätzliche Namen 'P3k'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_73_SCHRAEGPFEIL_LINKS_LANG_KONISCH = new AttDaqSymbol("Schrägpfeil links, lang, konisch", 		Short
	.valueOf("73"));

	/**
	Frühere zusätzliche Namen 'P4a'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_48_ISO_PFEIL_GERADEAUS = new AttDaqSymbol("ISO-Pfeil geradeaus", 		Short
	.valueOf("48"));

	/**
	Frühere zusätzliche Namen 'P4b'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_49_ISO_PFEIL_HALBRECHTS = new AttDaqSymbol("ISO-Pfeil halbrechts", 		Short
	.valueOf("49"));

	/**
	Frühere zusätzliche Namen 'P4c'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_50_ISO_PFEIL_RECHTS = new AttDaqSymbol("ISO-Pfeil rechts", 		Short
	.valueOf("50"));

	/**
	Frühere zusätzliche Namen 'P4d'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_51_ISO_PFEIL_HALBLINKS = new AttDaqSymbol("ISO-Pfeil halblinks", 		Short
	.valueOf("51"));

	/**
	Frühere zusätzliche Namen 'P4e'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_52_ISO_PFEIL_LINKS = new AttDaqSymbol("ISO-Pfeil links", 		Short
	.valueOf("52"));

	/**
	Frühere zusätzliche Namen 'B'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_53_BLINKER = new AttDaqSymbol("Blinker", 		Short
	.valueOf("53"));

	/**
	Frühere zusätzliche Namen 'N'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_54_NATIONALITAETENZEICHEN = new AttDaqSymbol("Nationalitätenzeichen", 		Short
	.valueOf("54"));

	/**
	Frühere zusätzliche Namen 'T'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_55_TRENNER = new AttDaqSymbol("Trenner", 		Short
	.valueOf("55"));

	/**
	Frühere zusätzliche Namen 'Z101'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_56_ACHTUNG = new AttDaqSymbol("Achtung", 		Short
	.valueOf("56"));

	/**
	Frühere zusätzliche Namen 'Z124'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_57_ACHTUNG_STAU = new AttDaqSymbol("Achtung Stau", 		Short
	.valueOf("57"));

	/**
	Frühere zusätzliche Namen 'Z131'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_58_ACHTUNG_LSA = new AttDaqSymbol("Achtung LSA", 		Short
	.valueOf("58"));

	/**
	Frühere zusätzliche Namen 'Z1006-38'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_59_STAU = new AttDaqSymbol("Stau", 		Short
	.valueOf("59"));

	/**
	Frühere zusätzliche Namen 'Z1703-01'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_60_AUSFAHRT_RECHTS = new AttDaqSymbol("Ausfahrt rechts", 		Short
	.valueOf("60"));

	/**
	Frühere zusätzliche Namen 'Z250'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_61_DURCHFAHRT_VERBOTEN = new AttDaqSymbol("Durchfahrt verboten", 		Short
	.valueOf("61"));

	/**
	Park und Ride.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_62_Z316 = new AttDaqSymbol("Z316", 		Short
	.valueOf("62"));

	/**
	Frühere zusätzliche Namen 'Z330'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_63_AUTOBAHN_BEGINN = new AttDaqSymbol("Autobahn Beginn", 		Short
	.valueOf("63"));

	/**
	Frühere zusätzliche Namen 'Z331'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_64_KRAFTFAHRSTRASSE_BEGINN = new AttDaqSymbol("Kraftfahrstraße Beginn", 		Short
	.valueOf("64"));

	/**
	Frühere zusätzliche Namen 'Z333-20'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_65_AUTOBAHN_AUSFAHRT = new AttDaqSymbol("Autobahn Ausfahrt", 		Short
	.valueOf("65"));

	/**
	Frühere zusätzliche Namen 'Z334'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_66_AUTOBAHN_ENDE = new AttDaqSymbol("Autobahn Ende", 		Short
	.valueOf("66"));

	/**
	Frühere zusätzliche Namen 'Z336'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_67_KRAFTFAHRSTRASSE_ENDE = new AttDaqSymbol("Kraftfahrstraße Ende", 		Short
	.valueOf("67"));

	/**
	Frühere zusätzliche Namen 'Z353'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_68_PFEIL_GERADEAUS = new AttDaqSymbol("Pfeil geradeaus", 		Short
	.valueOf("68"));

	/**
	Frühere zusätzliche Namen 'Z401'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_69_BUNDESSTRASSE_NUMMERNZEICHEN = new AttDaqSymbol("Bundesstraße Nummernzeichen", 		Short
	.valueOf("69"));

	/**
	Frühere zusätzliche Namen 'Z405'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_70_AUTOBAHN_NUMMERNZEICHEN = new AttDaqSymbol("Autobahn Nummernzeichen", 		Short
	.valueOf("70"));

	/**
	Frühere zusätzliche Namen 'Z406'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_71_ANSCHLUSSSTELLE_NUMMERNZEICHEN = new AttDaqSymbol("Anschlussstelle Nummernzeichen", 		Short
	.valueOf("71"));

	/**
	Frühere zusätzliche Namen 'Z410'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_72_EUROPASTRASSE_NUMMERNZEICHEN = new AttDaqSymbol("Europastraße Nummernzeichen", 		Short
	.valueOf("72"));

	/**
	Frühere zusätzliche Namen 'Z123'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_200_ACHTUNG_BAUARBEITEN = new AttDaqSymbol("Achtung Bauarbeiten", 		Short
	.valueOf("200"));

	/**
	Frühere zusätzliche Namen 'DZ124'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_201_DWISTA_STAU = new AttDaqSymbol("dWiSta Stau", 		Short
	.valueOf("201"));

	/**
	Frühere zusätzliche Namen 'S200'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_202_DWISTA_STADION = new AttDaqSymbol("dWiSta Stadion", 		Short
	.valueOf("202"));

	/**
	Frühere zusätzliche Namen 'CP1a'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_203_CENTRICO_PFEIL_GERADE = new AttDaqSymbol("Centrico-Pfeil gerade", 		Short
	.valueOf("203"));

	/**
	Frühere zusätzliche Namen 'CP1b'.
	<p>
	
	</p>
	*/
	public static final AttDaqSymbol ZUSTAND_204_CENTRICO_PFEIL_HALB_RECHTS = new AttDaqSymbol("Centrico-Pfeil halb-rechts", 		Short
	.valueOf("204"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDaqSymbol getZustand(final 		Short
	 value) {
		for (AttDaqSymbol e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDaqSymbol getZustand(final String value) {
		for (AttDaqSymbol e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDaqSymbol> getZustaende() {
		List<AttDaqSymbol> list = new ArrayList<AttDaqSymbol>();
		list.add(ZUSTAND_1_AUTOBAHN);
		list.add(ZUSTAND_2_AUTOHOF);
		list.add(ZUSTAND_3_AUTOZUG);
		list.add(ZUSTAND_4_BAB_AUSFAHRT);
		list.add(ZUSTAND_5_BAB_KREUZ_DREIECK);
		list.add(ZUSTAND_6_BAHNHOF);
		list.add(ZUSTAND_7_BEHINDERTEN_WC);
		list.add(ZUSTAND_8_BUS);
		list.add(ZUSTAND_9_ERSTE_HILFE);
		list.add(ZUSTAND_10_FERNSPRECHER);
		list.add(ZUSTAND_11_FLUGHAFEN_RECHTS);
		list.add(ZUSTAND_12_FLUGHAFEN_GERADEAUS);
		list.add(ZUSTAND_13_FREIZEITSPORTANLAGE);
		list.add(ZUSTAND_14_GASTHAUS);
		list.add(ZUSTAND_15_GUETERVERKEHRSZENTRUM);
		list.add(ZUSTAND_16_HAFEN_FAEHRE);
		list.add(ZUSTAND_17_INDUSTRIEGEBIET);
		list.add(ZUSTAND_18_INFORMATIONSSTELLE);
		list.add(ZUSTAND_19_KIRCHE);
		list.add(ZUSTAND_20_KRANKENHAUS);
		list.add(ZUSTAND_21_LKW);
		list.add(ZUSTAND_22_LKW_MIT_ANHAENGER);
		list.add(ZUSTAND_23_MOTEL_HOTEL);
		list.add(ZUSTAND_24_NOTRUFSAEULE);
		list.add(ZUSTAND_25_PARK_UND_RIDE);
		list.add(ZUSTAND_26_PARKHAUS);
		list.add(ZUSTAND_27_PARKPLATZ);
		list.add(ZUSTAND_28_PKW);
		list.add(ZUSTAND_29_PKW_MIT_ANHAENGER);
		list.add(ZUSTAND_30_POLIZEI);
		list.add(ZUSTAND_31_ROLLSTUHLFAHRER);
		list.add(ZUSTAND_32_STADION);
		list.add(ZUSTAND_33_TANKSTELLE);
		list.add(ZUSTAND_34_TOILETTEN);
		list.add(ZUSTAND_35_VERKAUFSKIOSK);
		list.add(ZUSTAND_36_WERKSTATT);
		list.add(ZUSTAND_37_ZELT_WOHNWAGENPLATZ);
		list.add(ZUSTAND_38_ZENTRUM);
		list.add(ZUSTAND_39_FUSSBALL);
		list.add(ZUSTAND_40_GERADEAUSPFEIL_KURZ);
		list.add(ZUSTAND_41_SCHRAEGPFEIL_RECHTS_KURZ);
		list.add(ZUSTAND_42_GERADEAUSPFEIL_LANG_KONISCH);
		list.add(ZUSTAND_43_SCHRAEGPFEIL_RECHTS_LANG_KONISCH);
		list.add(ZUSTAND_44_QUERPFEIL_RECHTS_LANG_KONISCH);
		list.add(ZUSTAND_45_GERADEAUSPFEIL_LANG);
		list.add(ZUSTAND_46_GERADEAUS_SCHRAEGPFEIL_RECHTS_LANG);
		list.add(ZUSTAND_47_GERADEAUS_SCHRAEGPFEIL_RECHTS_LANG_GEBOGEN);
		list.add(ZUSTAND_73_SCHRAEGPFEIL_LINKS_LANG_KONISCH);
		list.add(ZUSTAND_48_ISO_PFEIL_GERADEAUS);
		list.add(ZUSTAND_49_ISO_PFEIL_HALBRECHTS);
		list.add(ZUSTAND_50_ISO_PFEIL_RECHTS);
		list.add(ZUSTAND_51_ISO_PFEIL_HALBLINKS);
		list.add(ZUSTAND_52_ISO_PFEIL_LINKS);
		list.add(ZUSTAND_53_BLINKER);
		list.add(ZUSTAND_54_NATIONALITAETENZEICHEN);
		list.add(ZUSTAND_55_TRENNER);
		list.add(ZUSTAND_56_ACHTUNG);
		list.add(ZUSTAND_57_ACHTUNG_STAU);
		list.add(ZUSTAND_58_ACHTUNG_LSA);
		list.add(ZUSTAND_59_STAU);
		list.add(ZUSTAND_60_AUSFAHRT_RECHTS);
		list.add(ZUSTAND_61_DURCHFAHRT_VERBOTEN);
		list.add(ZUSTAND_62_Z316);
		list.add(ZUSTAND_63_AUTOBAHN_BEGINN);
		list.add(ZUSTAND_64_KRAFTFAHRSTRASSE_BEGINN);
		list.add(ZUSTAND_65_AUTOBAHN_AUSFAHRT);
		list.add(ZUSTAND_66_AUTOBAHN_ENDE);
		list.add(ZUSTAND_67_KRAFTFAHRSTRASSE_ENDE);
		list.add(ZUSTAND_68_PFEIL_GERADEAUS);
		list.add(ZUSTAND_69_BUNDESSTRASSE_NUMMERNZEICHEN);
		list.add(ZUSTAND_70_AUTOBAHN_NUMMERNZEICHEN);
		list.add(ZUSTAND_71_ANSCHLUSSSTELLE_NUMMERNZEICHEN);
		list.add(ZUSTAND_72_EUROPASTRASSE_NUMMERNZEICHEN);
		list.add(ZUSTAND_200_ACHTUNG_BAUARBEITEN);
		list.add(ZUSTAND_201_DWISTA_STAU);
		list.add(ZUSTAND_202_DWISTA_STADION);
		list.add(ZUSTAND_203_CENTRICO_PFEIL_GERADE);
		list.add(ZUSTAND_204_CENTRICO_PFEIL_HALB_RECHTS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Symbol.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDaqSymbol(final 		Short
	 value) {
		super(value);
	}
	
	private AttDaqSymbol(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
