/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribute zur Beschreibung der Begrenzung des Anzeigeobjektes (optional).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDaqAnzeigeBegrenzungOptional extends AbstractKonfigurationsDatensatz<KdDaqAnzeigeBegrenzungOptional.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _hoehe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _breite
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _abstandOben
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _abstandLinks
				;
		
			/**
			Höhe des Anzeigeobjektes.
			<p>
			
			</p>
			
			@return der Wert von Hoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getHoehe() {
				return _hoehe;
			}
		
			/**
			Höhe des Anzeigeobjektes.
			<p>
			
			</p>
			
			@param _hoehe der neue Wert von Hoehe.
			*/
			public void setHoehe(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _hoehe) {
				this._hoehe = _hoehe;
			}
		
			/**
			Breite des Anzeigeobjektes.
			<p>
			
			</p>
			
			@return der Wert von Breite.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getBreite() {
				return _breite;
			}
		
			/**
			Breite des Anzeigeobjektes.
			<p>
			
			</p>
			
			@param _breite der neue Wert von Breite.
			*/
			public void setBreite(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _breite) {
				this._breite = _breite;
			}
		
			/**
			Abstand des Anzeigeobjektes vom oberen Rand eines lokalen Rechts-Unten-Koordinatensystems.
			<p>
			
			</p>
			
			@return der Wert von AbstandOben.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAbstandOben() {
				return _abstandOben;
			}
		
			/**
			Abstand des Anzeigeobjektes vom oberen Rand eines lokalen Rechts-Unten-Koordinatensystems.
			<p>
			
			</p>
			
			@param _abstandOben der neue Wert von AbstandOben.
			*/
			public void setAbstandOben(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _abstandOben) {
				this._abstandOben = _abstandOben;
			}
		
			/**
			Abstand des Anzeigeobjektes vom linken Rand eines lokalen Rechts-Unten-Koordinatensystems.
			<p>
			
			</p>
			
			@return der Wert von AbstandLinks.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAbstandLinks() {
				return _abstandLinks;
			}
		
			/**
			Abstand des Anzeigeobjektes vom linken Rand eines lokalen Rechts-Unten-Koordinatensystems.
			<p>
			
			</p>
			
			@param _abstandLinks der neue Wert von AbstandLinks.
			*/
			public void setAbstandLinks(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _abstandLinks) {
				this._abstandLinks = _abstandLinks;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getHoehe() != null) {
		                if (getHoehe().isZustand()) {
		                    datum.getUnscaledValue("Höhe").setText(getHoehe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Höhe").set(getHoehe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBreite() != null) {
		                if (getBreite().isZustand()) {
		                    datum.getUnscaledValue("Breite").setText(getBreite().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Breite").set(getBreite().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbstandOben() != null) {
		                if (getAbstandOben().isZustand()) {
		                    datum.getUnscaledValue("AbstandOben").setText(getAbstandOben().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbstandOben").set(getAbstandOben().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbstandLinks() != null) {
		                if (getAbstandLinks().isZustand()) {
		                    datum.getUnscaledValue("AbstandLinks").setText(getAbstandLinks().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbstandLinks").set(getAbstandLinks().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Höhe").
									longValue
							()));
					// GanzzahlAttributTyp
							setBreite(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Breite").
									longValue
							()));
					// GanzzahlAttributTyp
							setAbstandOben(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AbstandOben").
									longValue
							()));
					// GanzzahlAttributTyp
							setAbstandLinks(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AbstandLinks").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHoehe(getHoehe());
							klon.setBreite(getBreite());
							klon.setAbstandOben(getAbstandOben());
							klon.setAbstandLinks(getAbstandLinks());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.daqAnzeigeBegrenzungOptional";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDaqAnzeigeBegrenzungOptional(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
