/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste mit den Farbdefinitionen für das Anzeigeobjekt (optional).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDaqAnzeigeFarbeOptional extends AbstractKonfigurationsDatensatz<KdDaqAnzeigeFarbeOptional.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
				 _vordergrund
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
				 _hintergrund
				;
		
			/**
			Vordergrundfarbe eines Anzeigeobjektes.
			<p>
			
			</p>
			
			@return der Wert von Vordergrund.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
				 getVordergrund() {
				return _vordergrund;
			}
		
			/**
			Vordergrundfarbe eines Anzeigeobjektes.
			<p>
			
			</p>
			
			@param _vordergrund der neue Wert von Vordergrund.
			*/
			public void setVordergrund(de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
			 _vordergrund) {
				this._vordergrund = _vordergrund;
			}
		
			/**
			Hintergrundfarbe eines Anzeigeobjektes.
			<p>
			
			</p>
			
			@return der Wert von Hintergrund.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
				 getHintergrund() {
				return _hintergrund;
			}
		
			/**
			Hintergrundfarbe eines Anzeigeobjektes.
			<p>
			
			</p>
			
			@param _hintergrund der neue Wert von Hintergrund.
			*/
			public void setHintergrund(de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
			 _hintergrund) {
				this._hintergrund = _hintergrund;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getVordergrund() != null) {
		                if (getVordergrund().isZustand()) {
		                    datum.getUnscaledValue("Vordergrund").setText(getVordergrund().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Vordergrund").set(getVordergrund().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHintergrund() != null) {
		                if (getHintergrund().isZustand()) {
		                    datum.getUnscaledValue("Hintergrund").setText(getHintergrund().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hintergrund").set(getHintergrund().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Vordergrund").isState()) {
								setVordergrund(de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
								.getZustand(daten.getScaledValue("Vordergrund").getText()));
							} else {
							setVordergrund(new de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
							(daten.
								getUnscaledValue
							("Vordergrund").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hintergrund").isState()) {
								setHintergrund(de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
								.getZustand(daten.getScaledValue("Hintergrund").getText()));
							} else {
							setHintergrund(new de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqAnzeigeFarbe
							(daten.
								getUnscaledValue
							("Hintergrund").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVordergrund(getVordergrund());
							klon.setHintergrund(getHintergrund());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.daqAnzeigeFarbeOptional";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDaqAnzeigeFarbeOptional(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
