/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribute zur Beschreibung des Schriftsatzes, der für einen grafischen Anzeigetext verwendet wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class KdDaqSchriftsatz extends AbstractKonfigurationsDatensatz<KdDaqSchriftsatz.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _hoehe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _ziffernHoehe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _engschrift
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _fett
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _kursiv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _durchgestrichen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqSchriftsatzAusrichtung
				 _ausrichtung
				;
		
			/**
			Höhe des Schriftsatzes.
			<p>
			
			</p>
			
			@return der Wert von Hoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getHoehe() {
				return _hoehe;
			}
		
			/**
			Höhe des Schriftsatzes.
			<p>
			
			</p>
			
			@param _hoehe der neue Wert von Hoehe.
			*/
			public void setHoehe(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _hoehe) {
				this._hoehe = _hoehe;
			}
		
			/**
			Höhe der Ziffernzeichen.
			<p>
			
			</p>
			
			@return der Wert von ZiffernHoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getZiffernHoehe() {
				return _ziffernHoehe;
			}
		
			/**
			Höhe der Ziffernzeichen.
			<p>
			
			</p>
			
			@param _ziffernHoehe der neue Wert von ZiffernHoehe.
			*/
			public void setZiffernHoehe(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _ziffernHoehe) {
				this._ziffernHoehe = _ziffernHoehe;
			}
		
			/**
			Angabe, ob der Schriftsatz in Engschrift verwendet wird.
			<p>
			
			</p>
			
			@return der Wert von Engschrift.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEngschrift() {
				return _engschrift;
			}
		
			/**
			Angabe, ob der Schriftsatz in Engschrift verwendet wird.
			<p>
			
			</p>
			
			@param _engschrift der neue Wert von Engschrift.
			*/
			public void setEngschrift(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _engschrift) {
				this._engschrift = _engschrift;
			}
		
			/**
			Angabe, ob der Schriftsatz fett verwendet wird.
			<p>
			
			</p>
			
			@return der Wert von Fett.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getFett() {
				return _fett;
			}
		
			/**
			Angabe, ob der Schriftsatz fett verwendet wird.
			<p>
			
			</p>
			
			@param _fett der neue Wert von Fett.
			*/
			public void setFett(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fett) {
				this._fett = _fett;
			}
		
			/**
			Angabe, ob der Schriftsatz kursiv verwendet wird.
			<p>
			
			</p>
			
			@return der Wert von Kursiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getKursiv() {
				return _kursiv;
			}
		
			/**
			Angabe, ob der Schriftsatz kursiv verwendet wird.
			<p>
			
			</p>
			
			@param _kursiv der neue Wert von Kursiv.
			*/
			public void setKursiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kursiv) {
				this._kursiv = _kursiv;
			}
		
			/**
			Angabe, ob der Schriftsatz durchgestrichen verwendet wird.
			<p>
			
			</p>
			
			@return der Wert von Durchgestrichen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getDurchgestrichen() {
				return _durchgestrichen;
			}
		
			/**
			Angabe, ob der Schriftsatz durchgestrichen verwendet wird.
			<p>
			
			</p>
			
			@param _durchgestrichen der neue Wert von Durchgestrichen.
			*/
			public void setDurchgestrichen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _durchgestrichen) {
				this._durchgestrichen = _durchgestrichen;
			}
		
			/**
			Ausrichtung des Schriftsatzes.
			<p>
			
			</p>
			
			@return der Wert von Ausrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqSchriftsatzAusrichtung
				 getAusrichtung() {
				return _ausrichtung;
			}
		
			/**
			Ausrichtung des Schriftsatzes.
			<p>
			
			</p>
			
			@param _ausrichtung der neue Wert von Ausrichtung.
			*/
			public void setAusrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqSchriftsatzAusrichtung
			 _ausrichtung) {
				this._ausrichtung = _ausrichtung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getHoehe() != null) {
		                if (getHoehe().isZustand()) {
		                    datum.getUnscaledValue("Höhe").setText(getHoehe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Höhe").set(getHoehe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZiffernHoehe() != null) {
		                if (getZiffernHoehe().isZustand()) {
		                    datum.getUnscaledValue("ZiffernHöhe").setText(getZiffernHoehe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZiffernHöhe").set(getZiffernHoehe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEngschrift() != null) {
		                if (getEngschrift().isZustand()) {
		                    datum.getUnscaledValue("Engschrift").setText(getEngschrift().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Engschrift").set(getEngschrift().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFett() != null) {
		                if (getFett().isZustand()) {
		                    datum.getUnscaledValue("Fett").setText(getFett().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fett").set(getFett().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKursiv() != null) {
		                if (getKursiv().isZustand()) {
		                    datum.getUnscaledValue("Kursiv").setText(getKursiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Kursiv").set(getKursiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDurchgestrichen() != null) {
		                if (getDurchgestrichen().isZustand()) {
		                    datum.getUnscaledValue("Durchgestrichen").setText(getDurchgestrichen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Durchgestrichen").set(getDurchgestrichen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAusrichtung() != null) {
		                if (getAusrichtung().isZustand()) {
		                    datum.getUnscaledValue("Ausrichtung").setText(getAusrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Ausrichtung").set(getAusrichtung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Höhe").
									longValue
							()));
					// GanzzahlAttributTyp
							setZiffernHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("ZiffernHöhe").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Engschrift").isState()) {
								setEngschrift(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Engschrift").getText()));
							} else {
							setEngschrift(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Engschrift").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fett").isState()) {
								setFett(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Fett").getText()));
							} else {
							setFett(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Fett").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Kursiv").isState()) {
								setKursiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Kursiv").getText()));
							} else {
							setKursiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Kursiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Durchgestrichen").isState()) {
								setDurchgestrichen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Durchgestrichen").getText()));
							} else {
							setDurchgestrichen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Durchgestrichen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Ausrichtung").isState()) {
								setAusrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqSchriftsatzAusrichtung
								.getZustand(daten.getScaledValue("Ausrichtung").getText()));
							} else {
							setAusrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.attribute.AttDaqSchriftsatzAusrichtung
							(daten.
								getUnscaledValue
							("Ausrichtung").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHoehe(getHoehe());
							klon.setZiffernHoehe(getZiffernHoehe());
							klon.setEngschrift(getEngschrift());
							klon.setFett(getFett());
							klon.setKursiv(getKursiv());
							klon.setDurchgestrichen(getDurchgestrichen());
							klon.setAusrichtung(getAusrichtung());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.daqSchriftsatz";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDaqSchriftsatz(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
