/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anzeigefläche auf einer Anzeigeseite mit grafischen Texten oder Symbolen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface DaqAnzeigeFlaeche extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.objekte.DaqAnzeigeObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.daqAnzeigeFläche"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Grafische Attribute zur Beschreibung eines Textes.
	<p>
	
	</p>
	@return der Datensatz DaqGrafikText.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqGrafikText getKdDaqGrafikText();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Attribute zur Beschreibung des zu verwendenden Symbols.
	<p>
	
	</p>
	@return der Datensatz DaqSymbol.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqSymbol getKdDaqSymbol();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Liste mit den Farbdefinitionen für das Anzeigeobjekt (optional).
	<p>
	
	</p>
	@return der Datensatz DaqAnzeigeFarbeOptional.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqAnzeigeFarbeOptional getKdDaqAnzeigeFarbeOptional();
	
	/**
	Attribute zur Beschreibung des Schriftsatzes, der für einen grafischen Anzeigetext verwendet wird.
	<p>
	
	</p>
	@return der Datensatz DaqSchriftsatz.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqSchriftsatz getKdDaqSchriftsatz();
	
	/**
	Allgemeine Attribute zur Beschreibung einer Anzeigeobjektes.
	<p>
	
	</p>
	@return der Datensatz DaqAnzeigeObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqAnzeigeObjekt getKdDaqAnzeigeObjekt();
	
	/**
	Attribute zur Beschreibung der Begrenzung des Anzeigeobjektes (optional).
	<p>
	
	</p>
	@return der Datensatz DaqAnzeigeBegrenzungOptional.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqAnzeigeBegrenzungOptional getKdDaqAnzeigeBegrenzungOptional();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
