/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Schilderanlage, der mehrere Anzeigequerschnitte zugeordnet sind.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface DaqSchilderAnlage extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.objekte.DaqAnzeigeObjekt,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.daqSchilderAnlage"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der Anzeigequerschnitte, die der Schilderanlage zugeordnet sind.
<p>

</p>

@return die Menge AnzeigeQuerschnitte oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.objekte.DaqAnzeigeQuerschnitt> getAnzeigeQuerschnitte();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attribute zur Verknüpfung von Schilderanlagen mit dem Verkehrsmodell.
	<p>
	
	</p>
	@return der Datensatz DaqSchilderAnlage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqSchilderAnlage getKdDaqSchilderAnlage();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Allgemeine Attribute zur Beschreibung einer Anzeigeobjektes.
	<p>
	
	</p>
	@return der Datensatz DaqAnzeigeObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellunganzeigequerschnitt.konfigurationsdaten.KdDaqAnzeigeObjekt getKdDaqAnzeigeObjekt();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
