/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der verkehrlichen Gültigkeit.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVerkehrlicheGueltigkeit implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0s")
			private 	RelativerZeitstempel
			 _zeitDauerAnfangIntervall
			;
			@Defaultwert(wert = "vorAnfang")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
			 _zeitBezugAnfangIntervall
			;
			@Defaultwert(wert = "0s")
			private 	RelativerZeitstempel
			 _zeitDauerEndeIntervall
			;
			@Defaultwert(wert = "nachEnde")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
			 _zeitBezugEndeIntervall
			;
	
		/**
		Zeitdauer.
		<p>
		
		</p>
		
		@return der Wert von ZeitDauerAnfangIntervall.
		*/
			public 	RelativerZeitstempel
			 getZeitDauerAnfangIntervall() {
			return _zeitDauerAnfangIntervall;
		}
	
		/**
		Zeitdauer.
		<p>
		
		</p>
		
		@param _zeitDauerAnfangIntervall der neue Wert von ZeitDauerAnfangIntervall.
		*/
		public void setZeitDauerAnfangIntervall(	RelativerZeitstempel
		 _zeitDauerAnfangIntervall) {
			this._zeitDauerAnfangIntervall = _zeitDauerAnfangIntervall;
		}
	
		/**
		Zeitbezug zum Anfang des Zeitintervalls.
		<p>
		
		</p>
		
		@return der Wert von ZeitBezugAnfangIntervall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
			 getZeitBezugAnfangIntervall() {
			return _zeitBezugAnfangIntervall;
		}
	
		/**
		Zeitbezug zum Anfang des Zeitintervalls.
		<p>
		
		</p>
		
		@param _zeitBezugAnfangIntervall der neue Wert von ZeitBezugAnfangIntervall.
		*/
		public void setZeitBezugAnfangIntervall(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
		 _zeitBezugAnfangIntervall) {
			this._zeitBezugAnfangIntervall = _zeitBezugAnfangIntervall;
		}
	
		/**
		Zeitdauer.
		<p>
		
		</p>
		
		@return der Wert von ZeitDauerEndeIntervall.
		*/
			public 	RelativerZeitstempel
			 getZeitDauerEndeIntervall() {
			return _zeitDauerEndeIntervall;
		}
	
		/**
		Zeitdauer.
		<p>
		
		</p>
		
		@param _zeitDauerEndeIntervall der neue Wert von ZeitDauerEndeIntervall.
		*/
		public void setZeitDauerEndeIntervall(	RelativerZeitstempel
		 _zeitDauerEndeIntervall) {
			this._zeitDauerEndeIntervall = _zeitDauerEndeIntervall;
		}
	
		/**
		Zeitbezug zum Ende des Zeitintervalls.
		<p>
		
		</p>
		
		@return der Wert von ZeitBezugEndeIntervall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
			 getZeitBezugEndeIntervall() {
			return _zeitBezugEndeIntervall;
		}
	
		/**
		Zeitbezug zum Ende des Zeitintervalls.
		<p>
		
		</p>
		
		@param _zeitBezugEndeIntervall der neue Wert von ZeitBezugEndeIntervall.
		*/
		public void setZeitBezugEndeIntervall(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
		 _zeitBezugEndeIntervall) {
			this._zeitBezugEndeIntervall = _zeitBezugEndeIntervall;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitDauerAnfangIntervall").setMillis(getZeitDauerAnfangIntervall().getTime());
				// GanzzahlAttributTyp
				if (getZeitBezugAnfangIntervall() != null) {
	                if (getZeitBezugAnfangIntervall().isZustand()) {
	                    datum.getUnscaledValue("ZeitBezugAnfangIntervall").setText(getZeitBezugAnfangIntervall().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ZeitBezugAnfangIntervall").set(getZeitBezugAnfangIntervall().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitDauerEndeIntervall").setMillis(getZeitDauerEndeIntervall().getTime());
				// GanzzahlAttributTyp
				if (getZeitBezugEndeIntervall() != null) {
	                if (getZeitBezugEndeIntervall().isZustand()) {
	                    datum.getUnscaledValue("ZeitBezugEndeIntervall").setText(getZeitBezugEndeIntervall().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ZeitBezugEndeIntervall").set(getZeitBezugEndeIntervall().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitDauerAnfangIntervall(new
						RelativerZeitstempel
						(daten.getTimeValue("ZeitDauerAnfangIntervall").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ZeitBezugAnfangIntervall").isState()) {
							setZeitBezugAnfangIntervall(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
							.getZustand(daten.getScaledValue("ZeitBezugAnfangIntervall").getText()));
						} else {
						setZeitBezugAnfangIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
						(daten.
							getUnscaledValue
						("ZeitBezugAnfangIntervall").
								byteValue
						()));
						}
				// ZeitstempelAttributTyp
					setZeitDauerEndeIntervall(new
						RelativerZeitstempel
						(daten.getTimeValue("ZeitDauerEndeIntervall").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ZeitBezugEndeIntervall").isState()) {
							setZeitBezugEndeIntervall(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
							.getZustand(daten.getScaledValue("ZeitBezugEndeIntervall").getText()));
						} else {
						setZeitBezugEndeIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttZeitBezug
						(daten.
							getUnscaledValue
						("ZeitBezugEndeIntervall").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVerkehrlicheGueltigkeit clone() {
		AtlVerkehrlicheGueltigkeit klon = new AtlVerkehrlicheGueltigkeit();
		
						klon.setZeitDauerAnfangIntervall(getZeitDauerAnfangIntervall());
						klon.setZeitBezugAnfangIntervall(getZeitBezugAnfangIntervall());
						klon.setZeitDauerEndeIntervall(getZeitDauerEndeIntervall());
						klon.setZeitBezugEndeIntervall(getZeitBezugEndeIntervall());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
