/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusätzliche Attribute von Ereignistypen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlZusaetzlicheAttribute implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _attributname
			= new String
			()
			;
			private String
			 _attributwert
			= new String
			()
			;
	
		/**
		Name des zusätzlichen Attributs.
		<p>
		
		</p>
		
		@return der Wert von Attributname.
		*/
			public String
			 getAttributname() {
			return _attributname;
		}
	
		/**
		Name des zusätzlichen Attributs.
		<p>
		
		</p>
		
		@param _attributname der neue Wert von Attributname.
		*/
		public void setAttributname(String
		 _attributname) {
			if (_attributname.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attributname = _attributname;
		}
	
		/**
		Beim Ereignistyp KOMMENTAR zur Bedeutung des zusätzlichen Attributwertes, beim Ereignis WERT des zusätzlichen Attributwertes.
		<p>
		
		</p>
		
		@return der Wert von Attributwert.
		*/
			public String
			 getAttributwert() {
			return _attributwert;
		}
	
		/**
		Beim Ereignistyp KOMMENTAR zur Bedeutung des zusätzlichen Attributwertes, beim Ereignis WERT des zusätzlichen Attributwertes.
		<p>
		
		</p>
		
		@param _attributwert der neue Wert von Attributwert.
		*/
		public void setAttributwert(String
		 _attributwert) {
			if (_attributwert.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attributwert = _attributwert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAttributname() != null) {
					datum.getTextValue("Attributname").setText(getAttributname());
				}
				// ZeichenkettenAttributTyp
				if (getAttributwert() != null) {
					datum.getTextValue("Attributwert").setText(getAttributwert());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAttributname(daten.getTextValue("Attributname").getText());
				// ZeichenkettenAttributTyp
					setAttributwert(daten.getTextValue("Attributwert").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlZusaetzlicheAttribute clone() {
		AtlZusaetzlicheAttribute klon = new AtlZusaetzlicheAttribute();
		
						klon.setAttributname(getAttributname());
						klon.setAttributwert(getAttributwert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
