/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften des Ereignisses.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class KdEreignisEigenschaften extends AbstractKonfigurationsDatensatz<KdEreignisEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _ereignisbeschreibung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				 _ereignisTypReferenz
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlZusaetzlicheAttribute
				> _zusaetzlicheAttribute = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlZusaetzlicheAttribute
				>(0, true);
		
			/**
			Beschreibung zum Ereignis.
			<p>
			
			</p>
			
			@return der Wert von Ereignisbeschreibung.
			*/
				public String
				 getEreignisbeschreibung() {
				return _ereignisbeschreibung;
			}
		
			/**
			Beschreibung zum Ereignis.
			<p>
			
			</p>
			
			@param _ereignisbeschreibung der neue Wert von Ereignisbeschreibung.
			*/
			public void setEreignisbeschreibung(String
			 _ereignisbeschreibung) {
				if (_ereignisbeschreibung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ereignisbeschreibung = _ereignisbeschreibung;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.ereignisTyp.
			<p>
			
			</p>
			
			@return der Wert von EreignisTypReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				 getEreignisTypReferenz() {
				return _ereignisTypReferenz;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.ereignisTyp.
			<p>
			
			</p>
			
			@param _ereignisTypReferenz der neue Wert von EreignisTypReferenz.
			*/
			public void setEreignisTypReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 _ereignisTypReferenz) {
				this._ereignisTypReferenz = _ereignisTypReferenz;
			}
		
			/**
			Zusätzliche Attribute von Ereignistypen.
			<p>
			
			</p>
			
			@return der Wert von ZusaetzlicheAttribute.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlZusaetzlicheAttribute
				> getZusaetzlicheAttribute() {
				return _zusaetzlicheAttribute;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getEreignisbeschreibung() != null) {
						datum.getTextValue("Ereignisbeschreibung").setText(getEreignisbeschreibung());
					}
					// ObjektReferenzAttributTyp
						final Object soEreignisTypReferenz = getEreignisTypReferenz();
						final SystemObject tmpEreignisTypReferenz;
							if (soEreignisTypReferenz instanceof SystemObject) {
								tmpEreignisTypReferenz = (SystemObject)soEreignisTypReferenz;
							} else if(soEreignisTypReferenz instanceof SystemObjekt){
								tmpEreignisTypReferenz = ((SystemObjekt)soEreignisTypReferenz).getSystemObject();
							} else{
								tmpEreignisTypReferenz = null;
							}
						datum.getReferenceValue("EreignisTypReferenz").setSystemObject(tmpEreignisTypReferenz);
					// AttributListenDefinition
						final Data.Array arrayZusaetzlicheAttribute = datum.getArray("ZusätzlicheAttribute");
						arrayZusaetzlicheAttribute.setLength(getZusaetzlicheAttribute().size());
						for (int i = 0; i < arrayZusaetzlicheAttribute.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlZusaetzlicheAttribute
							 atl = getZusaetzlicheAttribute().get(i);
							atl.bean2Atl(arrayZusaetzlicheAttribute.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setEreignisbeschreibung(daten.getTextValue("Ereignisbeschreibung").getText());
					// ObjektReferenzAttributTyp
						final long idEreignisTypReferenz = daten.getReferenceValue("EreignisTypReferenz").getId();
						final SystemObjekt tmpEreignisTypReferenz;
						if (idEreignisTypReferenz == 0) {
							tmpEreignisTypReferenz = null;
						} else {
							final SystemObject soEreignisTypReferenz = factory.getDav().getDataModel().getObject(idEreignisTypReferenz);
							if (soEreignisTypReferenz == null) {
									tmpEreignisTypReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTypReferenz);
							} else {
								tmpEreignisTypReferenz = factory.getModellobjekt(soEreignisTypReferenz);
							}
						}
						setEreignisTypReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
						) tmpEreignisTypReferenz);
					// AttributListenDefinition
						final Data.Array arrayZusaetzlicheAttribute = daten.getArray("ZusätzlicheAttribute");
						for (int i = 0; i < arrayZusaetzlicheAttribute.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlZusaetzlicheAttribute
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlZusaetzlicheAttribute
							 ();
							atl.atl2Bean(arrayZusaetzlicheAttribute.getItem(i), factory);
							getZusaetzlicheAttribute().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setEreignisbeschreibung(getEreignisbeschreibung());
							klon.setEreignisTypReferenz(getEreignisTypReferenz());
						klon._zusaetzlicheAttribute = getZusaetzlicheAttribute().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ereignisEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdEreignisEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
