/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zur Übermittlung von Ereignisanfragen an den Ereigniskalender.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class OdEreignisKalenderAnfrage extends AbstractOnlineDatensatz<OdEreignisKalenderAnfrage.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 _absenderId
				;
				private String
				 _absenderZeichen
				= new String
				()
				;
				private 	Zeitstempel
				 _anfangszeitpunkt
				;
				private 	Zeitstempel
				 _endzeitpunkt
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
				> _raeumlicheGueltigkeit = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttEreignisTypenOption
				 _ereignisTypenOption
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				> _ereignisTypReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				>(0, true);
		
			/**
			Objekt-ID der anfragenden Applikation.
			<p>
			&lt;absatz&gt;Die Antworten des Ereigniskalenders werden mit dieser Objekt-ID über den Datenverteiler versendet.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von AbsenderId.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 getAbsenderId() {
				return _absenderId;
			}
		
			/**
			Objekt-ID der anfragenden Applikation.
			<p>
			&lt;absatz&gt;Die Antworten des Ereigniskalenders werden mit dieser Objekt-ID über den Datenverteiler versendet.&lt;&#47;absatz&gt;
			</p>
			
			@param _absenderId der neue Wert von AbsenderId.
			*/
			public void setAbsenderId(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _absenderId) {
				this._absenderId = _absenderId;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			&lt;absatz&gt;
										Der angegebene Wert wird von der Datenhaltung in die Antwort zu dieser Anfrage kopiert.
										Die Bedeutung des Attributs wird von der anfragenden Applikation beliebig festgelegt
										und kann zum Beispiel dazu benutzt werden, um eine empfangene Antwort der ursprünglichen
										Anfrage zuzuordnen.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			&lt;absatz&gt;
										Der angegebene Wert wird von der Datenhaltung in die Antwort zu dieser Anfrage kopiert.
										Die Bedeutung des Attributs wird von der anfragenden Applikation beliebig festgelegt
										und kann zum Beispiel dazu benutzt werden, um eine empfangene Antwort der ursprünglichen
										Anfrage zuzuordnen.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Anfangszeitpunkt der Anfrage.
			<p>
			
			</p>
			
			@return der Wert von Anfangszeitpunkt.
			*/
				public 	Zeitstempel
				 getAnfangszeitpunkt() {
				return _anfangszeitpunkt;
			}
		
			/**
			Anfangszeitpunkt der Anfrage.
			<p>
			
			</p>
			
			@param _anfangszeitpunkt der neue Wert von Anfangszeitpunkt.
			*/
			public void setAnfangszeitpunkt(	Zeitstempel
			 _anfangszeitpunkt) {
				this._anfangszeitpunkt = _anfangszeitpunkt;
			}
		
			/**
			Endzeitpunkt der Anfrage.
			<p>
			&lt;absatz&gt;
										Liegt die der Anfangszeitpunkt hinter dem Endzweitpunkt, wird der Endzeitpunkt auf den Anfangzeitpunkt gesetzt.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Endzeitpunkt.
			*/
				public 	Zeitstempel
				 getEndzeitpunkt() {
				return _endzeitpunkt;
			}
		
			/**
			Endzeitpunkt der Anfrage.
			<p>
			&lt;absatz&gt;
										Liegt die der Anfangszeitpunkt hinter dem Endzweitpunkt, wird der Endzeitpunkt auf den Anfangzeitpunkt gesetzt.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _endzeitpunkt der neue Wert von Endzeitpunkt.
			*/
			public void setEndzeitpunkt(	Zeitstempel
			 _endzeitpunkt) {
				this._endzeitpunkt = _endzeitpunkt;
			}
		
			/**
			Räumliche Gültigkeit des Ereignisses.
			<p>
			&lt;absatz&gt;
										Hier können beliebig viele Referenzen auf Infrastrukturobjekte angegeben werden.
										Wenn keine Referenz angegeben wird sollen systemweit alle Ereignisse betrachtet werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von RaeumlicheGueltigkeit.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
				> getRaeumlicheGueltigkeit() {
				return _raeumlicheGueltigkeit;
			}
		
		
			/**
			Gibt an, welche Ereignistypen betrachtet werden sollen.
			<p>
			
			</p>
			
			@return der Wert von EreignisTypenOption.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttEreignisTypenOption
				 getEreignisTypenOption() {
				return _ereignisTypenOption;
			}
		
			/**
			Gibt an, welche Ereignistypen betrachtet werden sollen.
			<p>
			
			</p>
			
			@param _ereignisTypenOption der neue Wert von EreignisTypenOption.
			*/
			public void setEreignisTypenOption(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttEreignisTypenOption
			 _ereignisTypenOption) {
				this._ereignisTypenOption = _ereignisTypenOption;
			}
		
			/**
			In dieser Liste können Ereignistypen referenziert werden, die je nach Ereignistypenoption
									explizit zu berücksichtigen oder explizit nicht zu berücksichtigen sind.
			<p>
			
			</p>
			
			@return der Wert von EreignisTypReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				> getEreignisTypReferenz() {
				return _ereignisTypReferenz;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsenderId = getAbsenderId();
						final SystemObject tmpAbsenderId;
							if (soAbsenderId instanceof SystemObject) {
								tmpAbsenderId = (SystemObject)soAbsenderId;
							} else if(soAbsenderId instanceof SystemObjekt){
								tmpAbsenderId = ((SystemObjekt)soAbsenderId).getSystemObject();
							} else{
								tmpAbsenderId = null;
							}
						datum.getReferenceValue("absenderId").setSystemObject(tmpAbsenderId);
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("absenderZeichen").setText(getAbsenderZeichen());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Anfangszeitpunkt").setMillis(getAnfangszeitpunkt().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("Endzeitpunkt").setMillis(getEndzeitpunkt().getTime());
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRaeumlicheGueltigkeit = datum.getReferenceArray("RäumlicheGültigkeit");
						arrayRaeumlicheGueltigkeit.setLength(getRaeumlicheGueltigkeit().size());
						for (int i = 0; i < arrayRaeumlicheGueltigkeit.getLength(); ++i) {
							final Object soRaeumlicheGueltigkeit = getRaeumlicheGueltigkeit().get(i);
							final SystemObject tmpRaeumlicheGueltigkeit;
							if (soRaeumlicheGueltigkeit instanceof SystemObject) {
								tmpRaeumlicheGueltigkeit = (SystemObject)soRaeumlicheGueltigkeit;
							} else if(soRaeumlicheGueltigkeit instanceof SystemObjekt){
								tmpRaeumlicheGueltigkeit = ((SystemObjekt)soRaeumlicheGueltigkeit).getSystemObject();
							} else{
								tmpRaeumlicheGueltigkeit = null;
							}
							arrayRaeumlicheGueltigkeit.getReferenceValue(i).setSystemObject(tmpRaeumlicheGueltigkeit);
						}
					// GanzzahlAttributTyp
					if (getEreignisTypenOption() != null) {
		                if (getEreignisTypenOption().isZustand()) {
		                    datum.getUnscaledValue("EreignisTypenOption").setText(getEreignisTypenOption().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisTypenOption").set(getEreignisTypenOption().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayEreignisTypReferenz = datum.getReferenceArray("EreignisTypReferenz");
						arrayEreignisTypReferenz.setLength(getEreignisTypReferenz().size());
						for (int i = 0; i < arrayEreignisTypReferenz.getLength(); ++i) {
							final Object soEreignisTypReferenz = getEreignisTypReferenz().get(i);
							final SystemObject tmpEreignisTypReferenz;
							if (soEreignisTypReferenz instanceof SystemObject) {
								tmpEreignisTypReferenz = (SystemObject)soEreignisTypReferenz;
							} else if(soEreignisTypReferenz instanceof SystemObjekt){
								tmpEreignisTypReferenz = ((SystemObjekt)soEreignisTypReferenz).getSystemObject();
							} else{
								tmpEreignisTypReferenz = null;
							}
							arrayEreignisTypReferenz.getReferenceValue(i).setSystemObject(tmpEreignisTypReferenz);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsenderId = daten.getReferenceValue("absenderId").getId();
						final SystemObjekt tmpAbsenderId;
						if (idAbsenderId == 0) {
							tmpAbsenderId = null;
						} else {
							final SystemObject soAbsenderId = factory.getDav().getDataModel().getObject(idAbsenderId);
							if (soAbsenderId == null) {
									tmpAbsenderId = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idAbsenderId);
							} else {
								tmpAbsenderId = factory.getModellobjekt(soAbsenderId);
							}
						}
						setAbsenderId((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
						) tmpAbsenderId);
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("absenderZeichen").getText());
					// ZeitstempelAttributTyp
						setAnfangszeitpunkt(new
							Zeitstempel
							(daten.getTimeValue("Anfangszeitpunkt").getMillis()));
					// ZeitstempelAttributTyp
						setEndzeitpunkt(new
							Zeitstempel
							(daten.getTimeValue("Endzeitpunkt").getMillis()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRaeumlicheGueltigkeit = daten.getReferenceArray("RäumlicheGültigkeit");
						for (int i = 0; i < arrayRaeumlicheGueltigkeit.getLength(); ++i) {
							final long idRaeumlicheGueltigkeit = daten.getReferenceArray("RäumlicheGültigkeit").getReferenceValue(i).getId();
							final SystemObjekt tmpRaeumlicheGueltigkeit;
							if (idRaeumlicheGueltigkeit == 0) {
								tmpRaeumlicheGueltigkeit = null;
							} else {
								final SystemObject soRaeumlicheGueltigkeit = factory.getDav().getDataModel().getObject(idRaeumlicheGueltigkeit);
								if (soRaeumlicheGueltigkeit == null) {
										tmpRaeumlicheGueltigkeit = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.NetzBestandTeilUngueltig(idRaeumlicheGueltigkeit);
								} else {
									tmpRaeumlicheGueltigkeit = factory.getModellobjekt(soRaeumlicheGueltigkeit);
								}
							}
								getRaeumlicheGueltigkeit().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
								) tmpRaeumlicheGueltigkeit);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisTypenOption").isState()) {
								setEreignisTypenOption(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttEreignisTypenOption
								.getZustand(daten.getScaledValue("EreignisTypenOption").getText()));
							} else {
							setEreignisTypenOption(new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AttEreignisTypenOption
							(daten.
								getUnscaledValue
							("EreignisTypenOption").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayEreignisTypReferenz = daten.getReferenceArray("EreignisTypReferenz");
						for (int i = 0; i < arrayEreignisTypReferenz.getLength(); ++i) {
							final long idEreignisTypReferenz = daten.getReferenceArray("EreignisTypReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpEreignisTypReferenz;
							if (idEreignisTypReferenz == 0) {
								tmpEreignisTypReferenz = null;
							} else {
								final SystemObject soEreignisTypReferenz = factory.getDav().getDataModel().getObject(idEreignisTypReferenz);
								if (soEreignisTypReferenz == null) {
										tmpEreignisTypReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTypReferenz);
								} else {
									tmpEreignisTypReferenz = factory.getModellobjekt(soEreignisTypReferenz);
								}
							}
								getEreignisTypReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
								) tmpEreignisTypReferenz);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderId(getAbsenderId());
							klon.setAbsenderZeichen(getAbsenderZeichen());
							klon.setAnfangszeitpunkt(getAnfangszeitpunkt());
							klon.setEndzeitpunkt(getEndzeitpunkt());
						klon._raeumlicheGueltigkeit = getRaeumlicheGueltigkeit().clone();
							klon.setEreignisTypenOption(getEreignisTypenOption());
						klon._ereignisTypReferenz = getEreignisTypReferenz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ereignisKalenderAnfrage";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdEreignisKalenderAnfrage(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
