/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zur Übermittlung von Ereignisantworten an die anfragende Applikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class OdEreignisKalenderAntwort extends AbstractOnlineDatensatz<OdEreignisKalenderAntwort.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _absenderZeichen
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _aenderung
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation
				> _ereignis = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation
				>(0, true);
		
			/**
			Kennzeichnung, die von der anfragenden Applikation vergeben wurde.
			<p>
			
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation vergeben wurde.
			<p>
			
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Gibt an, ob der initiale Anfangszustand oder ein Änderung übertragen wurde.
			<p>
			
			</p>
			
			@return der Wert von Aenderung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAenderung() {
				return _aenderung;
			}
		
			/**
			Gibt an, ob der initiale Anfangszustand oder ein Änderung übertragen wurde.
			<p>
			
			</p>
			
			@param _aenderung der neue Wert von Aenderung.
			*/
			public void setAenderung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aenderung) {
				this._aenderung = _aenderung;
			}
		
			/**
			Informationen zu Ereignissen.
			<p>
			
			</p>
			
			@return der Wert von Ereignis.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation
				> getEreignis() {
				return _ereignis;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("absenderZeichen").setText(getAbsenderZeichen());
					}
					// GanzzahlAttributTyp
					if (getAenderung() != null) {
		                if (getAenderung().isZustand()) {
		                    datum.getUnscaledValue("änderung").setText(getAenderung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("änderung").set(getAenderung().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayEreignis = datum.getArray("Ereignis");
						arrayEreignis.setLength(getEreignis().size());
						for (int i = 0; i < arrayEreignis.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation
							 atl = getEreignis().get(i);
							atl.bean2Atl(arrayEreignis.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("absenderZeichen").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("änderung").isState()) {
								setAenderung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("änderung").getText()));
							} else {
							setAenderung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("änderung").
									byteValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayEreignis = daten.getArray("Ereignis");
						for (int i = 0; i < arrayEreignis.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlEreignisInformation
							 ();
							atl.atl2Bean(arrayEreignis.getItem(i), factory);
							getEreignis().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderZeichen(getAbsenderZeichen());
							klon.setAenderung(getAenderung());
						klon._ereignis = getEreignis().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ereignisKalenderAntwort";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdEreignisKalenderAntwort(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
