/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametrierbare Eigenschaften des Ereignisses.
<p>
&lt;absatz&gt;
						Die zeitliche Gültigkeit eines Ereignisses wird entweder durch ein explizite Zeitangabe
						gesetzt oder durch eine Referenz auf einen Eintrag im Systemkalender.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Wenn eine gültige Referenz auf einen Eintrag im Systemkalender angegeben wurde, werden
						die Attribute "BeginnZeitlicheGültigkeit" und "EndeZeitlicheGültigkeit" ignoriert.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class PdEreignisParameter extends AbstractParameterDatensatz<PdEreignisParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
				> _raeumlicheGueltigkeit = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
				>(0, true);
				private 	Zeitstempel
				 _beginnZeitlicheGueltigkeit
				;
				private 	Zeitstempel
				 _endeZeitlicheGueltigkeit
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag
				 _systemKalenderEintragReferenz
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlVerkehrlicheGueltigkeit
				> _verkehrlicheGueltigkeit = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlVerkehrlicheGueltigkeit
				>(0, true);
				private String
				 _quelle
				= new String
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Räumliche Gültigkeit des Ereignisses.
			<p>
			&lt;absatz&gt;
										Hier können beliebig viele Referenzen auf Infrastrukturobjekte angegeben werden.
										Wenn keine Referenz angegeben wird hat das Ereignis systemweite räumliche Relevanz.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von RaeumlicheGueltigkeit.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
				> getRaeumlicheGueltigkeit() {
				return _raeumlicheGueltigkeit;
			}
		
		
			/**
			Expliziter Zeitpunkt, zu dem die zeitliche Gültigkeit des Ereignisses beginnt.
			<p>
			
			</p>
			
			@return der Wert von BeginnZeitlicheGueltigkeit.
			*/
				public 	Zeitstempel
				 getBeginnZeitlicheGueltigkeit() {
				return _beginnZeitlicheGueltigkeit;
			}
		
			/**
			Expliziter Zeitpunkt, zu dem die zeitliche Gültigkeit des Ereignisses beginnt.
			<p>
			
			</p>
			
			@param _beginnZeitlicheGueltigkeit der neue Wert von BeginnZeitlicheGueltigkeit.
			*/
			public void setBeginnZeitlicheGueltigkeit(	Zeitstempel
			 _beginnZeitlicheGueltigkeit) {
				this._beginnZeitlicheGueltigkeit = _beginnZeitlicheGueltigkeit;
			}
		
			/**
			Expliziter Zeitpunkt, zu dem die zeitliche Gültigkeit des Ereignisses endet.
			<p>
			
			</p>
			
			@return der Wert von EndeZeitlicheGueltigkeit.
			*/
				public 	Zeitstempel
				 getEndeZeitlicheGueltigkeit() {
				return _endeZeitlicheGueltigkeit;
			}
		
			/**
			Expliziter Zeitpunkt, zu dem die zeitliche Gültigkeit des Ereignisses endet.
			<p>
			
			</p>
			
			@param _endeZeitlicheGueltigkeit der neue Wert von EndeZeitlicheGueltigkeit.
			*/
			public void setEndeZeitlicheGueltigkeit(	Zeitstempel
			 _endeZeitlicheGueltigkeit) {
				this._endeZeitlicheGueltigkeit = _endeZeitlicheGueltigkeit;
			}
		
			/**
			Referenz auf einen Eintrag im Systemkalender.
			<p>
			&lt;absatz&gt;
										In diesem Fall wird die konkrete zeitliche Gültigkeit des Ereignisses
										durch die Auswertung des Systemkalendereintrages bestimmt.
										Sei beispielsweise als Referenz der Systemkalendereintrag "Ostermontag"
										angegeben, so ist das hiermit definierte Ereignis am Ostermontag gültig.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von SystemKalenderEintragReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag
				 getSystemKalenderEintragReferenz() {
				return _systemKalenderEintragReferenz;
			}
		
			/**
			Referenz auf einen Eintrag im Systemkalender.
			<p>
			&lt;absatz&gt;
										In diesem Fall wird die konkrete zeitliche Gültigkeit des Ereignisses
										durch die Auswertung des Systemkalendereintrages bestimmt.
										Sei beispielsweise als Referenz der Systemkalendereintrag "Ostermontag"
										angegeben, so ist das hiermit definierte Ereignis am Ostermontag gültig.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _systemKalenderEintragReferenz der neue Wert von SystemKalenderEintragReferenz.
			*/
			public void setSystemKalenderEintragReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag
			 _systemKalenderEintragReferenz) {
				this._systemKalenderEintragReferenz = _systemKalenderEintragReferenz;
			}
		
			/**
			Verkehrliche Gültigkeit des Ereignisses.
			<p>
			&lt;absatz&gt;
										Die verkehrliche Gültigkeit kann durch ein oder mehrere relativ zur zeitlichen
										Gültigkeit definierte Bezüge spezifiziert werden. Dabei bezieht sich ein
										verkehrlicher Gültigkeitsbereich z.B. von 3 Stunden vor Anfang bis 15 Minuten
										vor Anfang der zeitlichen Gültigkeit.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										Wenn kein Eintrag angegeben wird, stimmt die verkehrtliche Gültigkeit mit der
										zeitlichen Gültigkeit überein.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von VerkehrlicheGueltigkeit.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlVerkehrlicheGueltigkeit
				> getVerkehrlicheGueltigkeit() {
				return _verkehrlicheGueltigkeit;
			}
		
		
			/**
			Quelle des Ereignisses.
			<p>
			&lt;absatz&gt;
										Referenz auf die Quelle des Ereignisses (z.B. auf den Benutzer, der das Ereignis eingegeben hat)
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Quelle.
			*/
				public String
				 getQuelle() {
				return _quelle;
			}
		
			/**
			Quelle des Ereignisses.
			<p>
			&lt;absatz&gt;
										Referenz auf die Quelle des Ereignisses (z.B. auf den Benutzer, der das Ereignis eingegeben hat)
									&lt;&#47;absatz&gt;
			</p>
			
			@param _quelle der neue Wert von Quelle.
			*/
			public void setQuelle(String
			 _quelle) {
				if (_quelle.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._quelle = _quelle;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRaeumlicheGueltigkeit = datum.getReferenceArray("RäumlicheGültigkeit");
						arrayRaeumlicheGueltigkeit.setLength(getRaeumlicheGueltigkeit().size());
						for (int i = 0; i < arrayRaeumlicheGueltigkeit.getLength(); ++i) {
							final Object soRaeumlicheGueltigkeit = getRaeumlicheGueltigkeit().get(i);
							final SystemObject tmpRaeumlicheGueltigkeit;
							if (soRaeumlicheGueltigkeit instanceof SystemObject) {
								tmpRaeumlicheGueltigkeit = (SystemObject)soRaeumlicheGueltigkeit;
							} else if(soRaeumlicheGueltigkeit instanceof SystemObjekt){
								tmpRaeumlicheGueltigkeit = ((SystemObjekt)soRaeumlicheGueltigkeit).getSystemObject();
							} else{
								tmpRaeumlicheGueltigkeit = null;
							}
							arrayRaeumlicheGueltigkeit.getReferenceValue(i).setSystemObject(tmpRaeumlicheGueltigkeit);
						}
					// ZeitstempelAttributTyp
						datum.getTimeValue("BeginnZeitlicheGültigkeit").setMillis(getBeginnZeitlicheGueltigkeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("EndeZeitlicheGültigkeit").setMillis(getEndeZeitlicheGueltigkeit().getTime());
					// ObjektReferenzAttributTyp
						final Object soSystemKalenderEintragReferenz = getSystemKalenderEintragReferenz();
						final SystemObject tmpSystemKalenderEintragReferenz;
							if (soSystemKalenderEintragReferenz instanceof SystemObject) {
								tmpSystemKalenderEintragReferenz = (SystemObject)soSystemKalenderEintragReferenz;
							} else if(soSystemKalenderEintragReferenz instanceof SystemObjekt){
								tmpSystemKalenderEintragReferenz = ((SystemObjekt)soSystemKalenderEintragReferenz).getSystemObject();
							} else{
								tmpSystemKalenderEintragReferenz = null;
							}
						datum.getReferenceValue("SystemKalenderEintragReferenz").setSystemObject(tmpSystemKalenderEintragReferenz);
					// AttributListenDefinition
						final Data.Array arrayVerkehrlicheGueltigkeit = datum.getArray("VerkehrlicheGültigkeit");
						arrayVerkehrlicheGueltigkeit.setLength(getVerkehrlicheGueltigkeit().size());
						for (int i = 0; i < arrayVerkehrlicheGueltigkeit.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlVerkehrlicheGueltigkeit
							 atl = getVerkehrlicheGueltigkeit().get(i);
							atl.bean2Atl(arrayVerkehrlicheGueltigkeit.getItem(i), factory);
		
						}
					// ZeichenkettenAttributTyp
					if (getQuelle() != null) {
						datum.getTextValue("Quelle").setText(getQuelle());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRaeumlicheGueltigkeit = daten.getReferenceArray("RäumlicheGültigkeit");
						for (int i = 0; i < arrayRaeumlicheGueltigkeit.getLength(); ++i) {
							final long idRaeumlicheGueltigkeit = daten.getReferenceArray("RäumlicheGültigkeit").getReferenceValue(i).getId();
							final SystemObjekt tmpRaeumlicheGueltigkeit;
							if (idRaeumlicheGueltigkeit == 0) {
								tmpRaeumlicheGueltigkeit = null;
							} else {
								final SystemObject soRaeumlicheGueltigkeit = factory.getDav().getDataModel().getObject(idRaeumlicheGueltigkeit);
								if (soRaeumlicheGueltigkeit == null) {
										tmpRaeumlicheGueltigkeit = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.NetzBestandTeilUngueltig(idRaeumlicheGueltigkeit);
								} else {
									tmpRaeumlicheGueltigkeit = factory.getModellobjekt(soRaeumlicheGueltigkeit);
								}
							}
								getRaeumlicheGueltigkeit().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil
								) tmpRaeumlicheGueltigkeit);
						}
					// ZeitstempelAttributTyp
						setBeginnZeitlicheGueltigkeit(new
							Zeitstempel
							(daten.getTimeValue("BeginnZeitlicheGültigkeit").getMillis()));
					// ZeitstempelAttributTyp
						setEndeZeitlicheGueltigkeit(new
							Zeitstempel
							(daten.getTimeValue("EndeZeitlicheGültigkeit").getMillis()));
					// ObjektReferenzAttributTyp
						final long idSystemKalenderEintragReferenz = daten.getReferenceValue("SystemKalenderEintragReferenz").getId();
						final SystemObjekt tmpSystemKalenderEintragReferenz;
						if (idSystemKalenderEintragReferenz == 0) {
							tmpSystemKalenderEintragReferenz = null;
						} else {
							final SystemObject soSystemKalenderEintragReferenz = factory.getDav().getDataModel().getObject(idSystemKalenderEintragReferenz);
							if (soSystemKalenderEintragReferenz == null) {
									tmpSystemKalenderEintragReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.impl.SystemKalenderEintragUngueltig(idSystemKalenderEintragReferenz);
							} else {
								tmpSystemKalenderEintragReferenz = factory.getModellobjekt(soSystemKalenderEintragReferenz);
							}
						}
						setSystemKalenderEintragReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag
						) tmpSystemKalenderEintragReferenz);
					// AttributListenDefinition
						final Data.Array arrayVerkehrlicheGueltigkeit = daten.getArray("VerkehrlicheGültigkeit");
						for (int i = 0; i < arrayVerkehrlicheGueltigkeit.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlVerkehrlicheGueltigkeit
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute.AtlVerkehrlicheGueltigkeit
							 ();
							atl.atl2Bean(arrayVerkehrlicheGueltigkeit.getItem(i), factory);
							getVerkehrlicheGueltigkeit().add(atl);
						}
					// ZeichenkettenAttributTyp
						setQuelle(daten.getTextValue("Quelle").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._raeumlicheGueltigkeit = getRaeumlicheGueltigkeit().clone();
							klon.setBeginnZeitlicheGueltigkeit(getBeginnZeitlicheGueltigkeit());
							klon.setEndeZeitlicheGueltigkeit(getEndeZeitlicheGueltigkeit());
							klon.setSystemKalenderEintragReferenz(getSystemKalenderEintragReferenz());
						klon._verkehrlicheGueltigkeit = getVerkehrlicheGueltigkeit().clone();
							klon.setQuelle(getQuelle());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ereignisParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdEreignisParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
