/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition einer Ganglinie.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlGanglinie implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _ganglinieId
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 _ereignisTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _referenzganglinie
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _anzahlVerschmelzungen
			;
			private 	Zeitstempel
			 _letzteVerschmelzung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
			 _ganglinienTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
			 _ganglinienVerfahren
			;
			@Defaultwert(wert = "5")
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _ordnung
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
			> _stuetzstelle = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
			>(0, true);
	
		/**
		ID der Ganglinie in der Gangliniendatenbank (0, wenn die Ganglinien nicht in der Datenbank gespeichert wurde).
		<p>
		
		</p>
		
		@return der Wert von GanglinieId.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getGanglinieId() {
			return _ganglinieId;
		}
	
		/**
		ID der Ganglinie in der Gangliniendatenbank (0, wenn die Ganglinien nicht in der Datenbank gespeichert wurde).
		<p>
		
		</p>
		
		@param _ganglinieId der neue Wert von GanglinieId.
		*/
		public void setGanglinieId(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _ganglinieId) {
			this._ganglinieId = _ganglinieId;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.ereignisTyp.
		<p>
		
		</p>
		
		@return der Wert von EreignisTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 getEreignisTyp() {
			return _ereignisTyp;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.ereignisTyp.
		<p>
		
		</p>
		
		@param _ereignisTyp der neue Wert von EreignisTyp.
		*/
		public void setEreignisTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
		 _ereignisTyp) {
			this._ereignisTyp = _ereignisTyp;
		}
	
		/**
		Die Ganglinie ist für das entsprechende Ereignis als Referenzganglinie ausgezeichnet.
		<p>
		
		</p>
		
		@return der Wert von Referenzganglinie.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getReferenzganglinie() {
			return _referenzganglinie;
		}
	
		/**
		Die Ganglinie ist für das entsprechende Ereignis als Referenzganglinie ausgezeichnet.
		<p>
		
		</p>
		
		@param _referenzganglinie der neue Wert von Referenzganglinie.
		*/
		public void setReferenzganglinie(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _referenzganglinie) {
			this._referenzganglinie = _referenzganglinie;
		}
	
		/**
		Anzahl der Verschmelzungen, aus denen die Ganglinie hervorgeht.
		<p>
		
		</p>
		
		@return der Wert von AnzahlVerschmelzungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getAnzahlVerschmelzungen() {
			return _anzahlVerschmelzungen;
		}
	
		/**
		Anzahl der Verschmelzungen, aus denen die Ganglinie hervorgeht.
		<p>
		
		</p>
		
		@param _anzahlVerschmelzungen der neue Wert von AnzahlVerschmelzungen.
		*/
		public void setAnzahlVerschmelzungen(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _anzahlVerschmelzungen) {
			this._anzahlVerschmelzungen = _anzahlVerschmelzungen;
		}
	
		/**
		Zeitpunkt der letzten Verschmelzung.
		<p>
		
		</p>
		
		@return der Wert von LetzteVerschmelzung.
		*/
			public 	Zeitstempel
			 getLetzteVerschmelzung() {
			return _letzteVerschmelzung;
		}
	
		/**
		Zeitpunkt der letzten Verschmelzung.
		<p>
		
		</p>
		
		@param _letzteVerschmelzung der neue Wert von LetzteVerschmelzung.
		*/
		public void setLetzteVerschmelzung(	Zeitstempel
		 _letzteVerschmelzung) {
			this._letzteVerschmelzung = _letzteVerschmelzung;
		}
	
		/**
		Typ der Ganglinie (absolut oder relativ).
		<p>
		
		</p>
		
		@return der Wert von GanglinienTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
			 getGanglinienTyp() {
			return _ganglinienTyp;
		}
	
		/**
		Typ der Ganglinie (absolut oder relativ).
		<p>
		
		</p>
		
		@param _ganglinienTyp der neue Wert von GanglinienTyp.
		*/
		public void setGanglinienTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
		 _ganglinienTyp) {
			this._ganglinienTyp = _ganglinienTyp;
		}
	
		/**
		Mathematisches Verfahren zur Approximation bzw. Interpolation.
		<p>
		&lt;absatz&gt;
								Bei absoluten Ganglinien wird mit diesem Attribut das mathematische Verfahren
								festgelegt, mit dem der Funktionswert einer Ganglinie an einem beliebigen
								Zwischenpunkt berechnet werden kann.
							&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von GanglinienVerfahren.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
			 getGanglinienVerfahren() {
			return _ganglinienVerfahren;
		}
	
		/**
		Mathematisches Verfahren zur Approximation bzw. Interpolation.
		<p>
		&lt;absatz&gt;
								Bei absoluten Ganglinien wird mit diesem Attribut das mathematische Verfahren
								festgelegt, mit dem der Funktionswert einer Ganglinie an einem beliebigen
								Zwischenpunkt berechnet werden kann.
							&lt;&#47;absatz&gt;
		</p>
		
		@param _ganglinienVerfahren der neue Wert von GanglinienVerfahren.
		*/
		public void setGanglinienVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
		 _ganglinienVerfahren) {
			this._ganglinienVerfahren = _ganglinienVerfahren;
		}
	
		/**
		Ordnung der b-spline Approximation (nur in Verbindung mit der b-spline Approximation).
		<p>
		
		</p>
		
		@return der Wert von Ordnung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getOrdnung() {
			return _ordnung;
		}
	
		/**
		Ordnung der b-spline Approximation (nur in Verbindung mit der b-spline Approximation).
		<p>
		
		</p>
		
		@param _ordnung der neue Wert von Ordnung.
		*/
		public void setOrdnung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _ordnung) {
			this._ordnung = _ordnung;
		}
	
		/**
		Definition einer Stützstelle.
		<p>
		
		</p>
		
		@return der Wert von Stuetzstelle.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
			> getStuetzstelle() {
			return _stuetzstelle;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getGanglinieId() != null) {
	                if (getGanglinieId().isZustand()) {
	                    datum.getUnscaledValue("GanglinieId").setText(getGanglinieId().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GanglinieId").set(getGanglinieId().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soEreignisTyp = getEreignisTyp();
					final SystemObject tmpEreignisTyp;
						if (soEreignisTyp instanceof SystemObject) {
							tmpEreignisTyp = (SystemObject)soEreignisTyp;
						} else if(soEreignisTyp instanceof SystemObjekt){
							tmpEreignisTyp = ((SystemObjekt)soEreignisTyp).getSystemObject();
						} else{
							tmpEreignisTyp = null;
						}
					datum.getReferenceValue("EreignisTyp").setSystemObject(tmpEreignisTyp);
				// GanzzahlAttributTyp
				if (getReferenzganglinie() != null) {
	                if (getReferenzganglinie().isZustand()) {
	                    datum.getUnscaledValue("Referenzganglinie").setText(getReferenzganglinie().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Referenzganglinie").set(getReferenzganglinie().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnzahlVerschmelzungen() != null) {
	                if (getAnzahlVerschmelzungen().isZustand()) {
	                    datum.getUnscaledValue("AnzahlVerschmelzungen").setText(getAnzahlVerschmelzungen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzahlVerschmelzungen").set(getAnzahlVerschmelzungen().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("LetzteVerschmelzung").setMillis(getLetzteVerschmelzung().getTime());
				// GanzzahlAttributTyp
				if (getGanglinienTyp() != null) {
	                if (getGanglinienTyp().isZustand()) {
	                    datum.getUnscaledValue("GanglinienTyp").setText(getGanglinienTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GanglinienTyp").set(getGanglinienTyp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGanglinienVerfahren() != null) {
	                if (getGanglinienVerfahren().isZustand()) {
	                    datum.getUnscaledValue("GanglinienVerfahren").setText(getGanglinienVerfahren().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GanglinienVerfahren").set(getGanglinienVerfahren().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOrdnung() != null) {
	                if (getOrdnung().isZustand()) {
	                    datum.getUnscaledValue("Ordnung").setText(getOrdnung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Ordnung").set(getOrdnung().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayStuetzstelle = datum.getArray("Stützstelle");
					arrayStuetzstelle.setLength(getStuetzstelle().size());
					for (int i = 0; i < arrayStuetzstelle.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
						 atl = getStuetzstelle().get(i);
						atl.bean2Atl(arrayStuetzstelle.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setGanglinieId(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("GanglinieId").
								longValue
						()));
				// ObjektReferenzAttributTyp
					final long idEreignisTyp = daten.getReferenceValue("EreignisTyp").getId();
					final SystemObjekt tmpEreignisTyp;
					if (idEreignisTyp == 0) {
						tmpEreignisTyp = null;
					} else {
						final SystemObject soEreignisTyp = factory.getDav().getDataModel().getObject(idEreignisTyp);
						if (soEreignisTyp == null) {
								tmpEreignisTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTyp);
						} else {
							tmpEreignisTyp = factory.getModellobjekt(soEreignisTyp);
						}
					}
					setEreignisTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
					) tmpEreignisTyp);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Referenzganglinie").isState()) {
							setReferenzganglinie(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Referenzganglinie").getText()));
						} else {
						setReferenzganglinie(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Referenzganglinie").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setAnzahlVerschmelzungen(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("AnzahlVerschmelzungen").
								longValue
						()));
				// ZeitstempelAttributTyp
					setLetzteVerschmelzung(new
						Zeitstempel
						(daten.getTimeValue("LetzteVerschmelzung").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GanglinienTyp").isState()) {
							setGanglinienTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
							.getZustand(daten.getScaledValue("GanglinienTyp").getText()));
						} else {
						setGanglinienTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
						(daten.
							getUnscaledValue
						("GanglinienTyp").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GanglinienVerfahren").isState()) {
							setGanglinienVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
							.getZustand(daten.getScaledValue("GanglinienVerfahren").getText()));
						} else {
						setGanglinienVerfahren(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
						(daten.
							getUnscaledValue
						("GanglinienVerfahren").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setOrdnung(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("Ordnung").
								longValue
						()));
				// AttributListenDefinition
					final Data.Array arrayStuetzstelle = daten.getArray("Stützstelle");
					for (int i = 0; i < arrayStuetzstelle.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
						 ();
						atl.atl2Bean(arrayStuetzstelle.getItem(i), factory);
						getStuetzstelle().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGanglinie clone() {
		AtlGanglinie klon = new AtlGanglinie();
		
						klon.setGanglinieId(getGanglinieId());
						klon.setEreignisTyp(getEreignisTyp());
						klon.setReferenzganglinie(getReferenzganglinie());
						klon.setAnzahlVerschmelzungen(getAnzahlVerschmelzungen());
						klon.setLetzteVerschmelzung(getLetzteVerschmelzung());
						klon.setGanglinienTyp(getGanglinienTyp());
						klon.setGanglinienVerfahren(getGanglinienVerfahren());
						klon.setOrdnung(getOrdnung());
					klon._stuetzstelle = getStuetzstelle().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
