/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anfrage nach Ganglinien.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlGanglinienSpeicherAnfrage implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messquerschnitt
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			> _ereignisTyp = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			> _ganglinienId = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienSpeicherKommandoAnfrage
			 _kommandoAnfrage
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
			> _zuSpeicherndeGanglinien = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
			>(0, true);
	
		/**
		Assoziierter Messquerschnitt für die Anfrage.
		<p>
		
		</p>
		
		@return der Wert von Messquerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessquerschnitt() {
			return _messquerschnitt;
		}
	
		/**
		Assoziierter Messquerschnitt für die Anfrage.
		<p>
		
		</p>
		
		@param _messquerschnitt der neue Wert von Messquerschnitt.
		*/
		public void setMessquerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messquerschnitt) {
			this._messquerschnitt = _messquerschnitt;
		}
	
		/**
		Ereignistyp, der bei der berücksichtigt werden soll. Wenn hier eine leere Liste uebergeben wird, so sind alle Ereignistypen gemeint.
		<p>
		
		</p>
		
		@return der Wert von EreignisTyp.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			> getEreignisTyp() {
			return _ereignisTyp;
		}
	
	
		/**
		Eine Liste von ID von Ganglinien, die bei der Anfrage berücksichtigt werden sollen (z.B. zum Löschen konkreter Ganglinien).
		<p>
		
		</p>
		
		@return der Wert von GanglinienId.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			> getGanglinienId() {
			return _ganglinienId;
		}
	
	
		/**
		Kommando (Typ) der Anfrage: Lesen, Schreiben oder Löschen.
		<p>
		
		</p>
		
		@return der Wert von KommandoAnfrage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienSpeicherKommandoAnfrage
			 getKommandoAnfrage() {
			return _kommandoAnfrage;
		}
	
		/**
		Kommando (Typ) der Anfrage: Lesen, Schreiben oder Löschen.
		<p>
		
		</p>
		
		@param _kommandoAnfrage der neue Wert von KommandoAnfrage.
		*/
		public void setKommandoAnfrage(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienSpeicherKommandoAnfrage
		 _kommandoAnfrage) {
			this._kommandoAnfrage = _kommandoAnfrage;
		}
	
		/**
		Wenn diese Liste leer ist, gilt das Kommando als Anfrage (Lesen) nach den Ganglinien des uebergebenen MQ bzw. Ereignistypen. Enthält die Liste Elemente, so werden die enthaltenen Ganglinien komplett am uebergebenen MQ gespeichert (Kommondo Schreiben). Der uebergebene Ereignistyp spielt dann keine Rolle. In beiden Fällen ist das Attribut KommandoAnfrage auf LesenSchreiben zu setzen.
		<p>
		
		</p>
		
		@return der Wert von ZuSpeicherndeGanglinien.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
			> getZuSpeicherndeGanglinien() {
			return _zuSpeicherndeGanglinien;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessquerschnitt = getMessquerschnitt();
					final SystemObject tmpMessquerschnitt;
						if (soMessquerschnitt instanceof SystemObject) {
							tmpMessquerschnitt = (SystemObject)soMessquerschnitt;
						} else if(soMessquerschnitt instanceof SystemObjekt){
							tmpMessquerschnitt = ((SystemObjekt)soMessquerschnitt).getSystemObject();
						} else{
							tmpMessquerschnitt = null;
						}
					datum.getReferenceValue("Messquerschnitt").setSystemObject(tmpMessquerschnitt);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEreignisTyp = datum.getReferenceArray("EreignisTyp");
					arrayEreignisTyp.setLength(getEreignisTyp().size());
					for (int i = 0; i < arrayEreignisTyp.getLength(); ++i) {
						final Object soEreignisTyp = getEreignisTyp().get(i);
						final SystemObject tmpEreignisTyp;
						if (soEreignisTyp instanceof SystemObject) {
							tmpEreignisTyp = (SystemObject)soEreignisTyp;
						} else if(soEreignisTyp instanceof SystemObjekt){
							tmpEreignisTyp = ((SystemObjekt)soEreignisTyp).getSystemObject();
						} else{
							tmpEreignisTyp = null;
						}
						arrayEreignisTyp.getReferenceValue(i).setSystemObject(tmpEreignisTyp);
					}
				// GanzzahlAttributTyp
				if (getGanglinienId() != null) {
					final Data.NumberArray arrayGanglinienId = datum.
						getUnscaledArray
						("GanglinienId");
					arrayGanglinienId.setLength(getGanglinienId().size());
					for (int i = 0; i < arrayGanglinienId.getLength(); ++i) {
						arrayGanglinienId.getValue(i).set(getGanglinienId().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getKommandoAnfrage() != null) {
	                if (getKommandoAnfrage().isZustand()) {
	                    datum.getUnscaledValue("KommandoAnfrage").setText(getKommandoAnfrage().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KommandoAnfrage").set(getKommandoAnfrage().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayZuSpeicherndeGanglinien = datum.getArray("ZuSpeicherndeGanglinien");
					arrayZuSpeicherndeGanglinien.setLength(getZuSpeicherndeGanglinien().size());
					for (int i = 0; i < arrayZuSpeicherndeGanglinien.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
						 atl = getZuSpeicherndeGanglinien().get(i);
						atl.bean2Atl(arrayZuSpeicherndeGanglinien.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessquerschnitt = daten.getReferenceValue("Messquerschnitt").getId();
					final SystemObjekt tmpMessquerschnitt;
					if (idMessquerschnitt == 0) {
						tmpMessquerschnitt = null;
					} else {
						final SystemObject soMessquerschnitt = factory.getDav().getDataModel().getObject(idMessquerschnitt);
						if (soMessquerschnitt == null) {
								tmpMessquerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessquerschnitt);
						} else {
							tmpMessquerschnitt = factory.getModellobjekt(soMessquerschnitt);
						}
					}
					setMessquerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessquerschnitt);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEreignisTyp = daten.getReferenceArray("EreignisTyp");
					for (int i = 0; i < arrayEreignisTyp.getLength(); ++i) {
						final long idEreignisTyp = daten.getReferenceArray("EreignisTyp").getReferenceValue(i).getId();
						final SystemObjekt tmpEreignisTyp;
						if (idEreignisTyp == 0) {
							tmpEreignisTyp = null;
						} else {
							final SystemObject soEreignisTyp = factory.getDav().getDataModel().getObject(idEreignisTyp);
							if (soEreignisTyp == null) {
									tmpEreignisTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTyp);
							} else {
								tmpEreignisTyp = factory.getModellobjekt(soEreignisTyp);
							}
						}
							getEreignisTyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
							) tmpEreignisTyp);
					}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayGanglinienId = daten.
						getUnscaledArray
					("GanglinienId");
	
					for (int i = 0; i < arrayGanglinienId.getLength(); ++i) {
	                    getGanglinienId().add(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
	                    (arrayGanglinienId.
	                    		longValue
	                    (i)));
	                }
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("KommandoAnfrage").isState()) {
							setKommandoAnfrage(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienSpeicherKommandoAnfrage
							.getZustand(daten.getScaledValue("KommandoAnfrage").getText()));
						} else {
						setKommandoAnfrage(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienSpeicherKommandoAnfrage
						(daten.
							getUnscaledValue
						("KommandoAnfrage").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayZuSpeicherndeGanglinien = daten.getArray("ZuSpeicherndeGanglinien");
					for (int i = 0; i < arrayZuSpeicherndeGanglinien.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
						 ();
						atl.atl2Bean(arrayZuSpeicherndeGanglinien.getItem(i), factory);
						getZuSpeicherndeGanglinien().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGanglinienSpeicherAnfrage clone() {
		AtlGanglinienSpeicherAnfrage klon = new AtlGanglinienSpeicherAnfrage();
		
						klon.setMessquerschnitt(getMessquerschnitt());
					klon._ereignisTyp = getEreignisTyp().clone();
					klon._ganglinienId = getGanglinienId().clone();
						klon.setKommandoAnfrage(getKommandoAnfrage());
					klon._zuSpeicherndeGanglinien = getZuSpeicherndeGanglinien().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
