/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anfrageergebnis nach Ganglinie.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlGanglinienSpeicherAntwort implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messquerschnitt
			;
			private Feld<String
			> _fehlermeldung = new Feld<String
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
			> _gespeicherteGanglinien = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
			>(0, true);
	
		/**
		Assoziierter Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Messquerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessquerschnitt() {
			return _messquerschnitt;
		}
	
		/**
		Assoziierter Messquerschnitt.
		<p>
		
		</p>
		
		@param _messquerschnitt der neue Wert von Messquerschnitt.
		*/
		public void setMessquerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messquerschnitt) {
			this._messquerschnitt = _messquerschnitt;
		}
	
		/**
		Eine Fehlermeldung. Wenn alles ok ist, bleibt die Liste leer.
		<p>
		
		</p>
		
		@return der Wert von Fehlermeldung.
		*/
			public Feld<String
			> getFehlermeldung() {
			return _fehlermeldung;
		}
	
	
		/**
		Ergebnisganglinien (nur fuer Leseanfragen).
		<p>
		
		</p>
		
		@return der Wert von GespeicherteGanglinien.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
			> getGespeicherteGanglinien() {
			return _gespeicherteGanglinien;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessquerschnitt = getMessquerschnitt();
					final SystemObject tmpMessquerschnitt;
						if (soMessquerschnitt instanceof SystemObject) {
							tmpMessquerschnitt = (SystemObject)soMessquerschnitt;
						} else if(soMessquerschnitt instanceof SystemObjekt){
							tmpMessquerschnitt = ((SystemObjekt)soMessquerschnitt).getSystemObject();
						} else{
							tmpMessquerschnitt = null;
						}
					datum.getReferenceValue("Messquerschnitt").setSystemObject(tmpMessquerschnitt);
				// ZeichenkettenAttributTyp
				if (getFehlermeldung() != null) {
					final Data.TextArray arrayFehlermeldung = datum.getTextArray("Fehlermeldung");
					arrayFehlermeldung.setLength(getFehlermeldung().size());
					for (int i = 0; i < arrayFehlermeldung.getLength(); ++i) {
						arrayFehlermeldung.getTextValue(i).setText(getFehlermeldung().get(i));
					}
				}
				// AttributListenDefinition
					final Data.Array arrayGespeicherteGanglinien = datum.getArray("GespeicherteGanglinien");
					arrayGespeicherteGanglinien.setLength(getGespeicherteGanglinien().size());
					for (int i = 0; i < arrayGespeicherteGanglinien.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
						 atl = getGespeicherteGanglinien().get(i);
						atl.bean2Atl(arrayGespeicherteGanglinien.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessquerschnitt = daten.getReferenceValue("Messquerschnitt").getId();
					final SystemObjekt tmpMessquerschnitt;
					if (idMessquerschnitt == 0) {
						tmpMessquerschnitt = null;
					} else {
						final SystemObject soMessquerschnitt = factory.getDav().getDataModel().getObject(idMessquerschnitt);
						if (soMessquerschnitt == null) {
								tmpMessquerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessquerschnitt);
						} else {
							tmpMessquerschnitt = factory.getModellobjekt(soMessquerschnitt);
						}
					}
					setMessquerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessquerschnitt);
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayFehlermeldung = daten.getTextArray("Fehlermeldung");
					for (int i = 0; i < arrayFehlermeldung.getLength(); ++i) {
						getFehlermeldung().add(arrayFehlermeldung.getText(i));
					}
				// AttributListenDefinition
					final Data.Array arrayGespeicherteGanglinien = daten.getArray("GespeicherteGanglinien");
					for (int i = 0; i < arrayGespeicherteGanglinien.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlGanglinie
						 ();
						atl.atl2Bean(arrayGespeicherteGanglinien.getItem(i), factory);
						getGespeicherteGanglinien().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGanglinienSpeicherAntwort clone() {
		AtlGanglinienSpeicherAntwort klon = new AtlGanglinienSpeicherAntwort();
		
						klon.setMessquerschnitt(getMessquerschnitt());
					klon._fehlermeldung = getFehlermeldung().clone();
					klon._gespeicherteGanglinien = getGespeicherteGanglinien().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
