/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung der Prognoseganglinie.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AtlPrognoseGanglinie implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messquerschnitt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
			 _ganglinienVerfahren
			;
			@Defaultwert(wert = "5")
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _ordnung
			;
			private 	Zeitstempel
			 _zeitpunktPrognoseBeginn
			;
			private 	Zeitstempel
			 _zeitpunktPrognoseEnde
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
			> _stuetzstelle = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
			>(0, true);
	
		/**
		Messquerschnitt, zu dem die Prognoseganglinie erstellt wurde.
		<p>
		
		</p>
		
		@return der Wert von Messquerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessquerschnitt() {
			return _messquerschnitt;
		}
	
		/**
		Messquerschnitt, zu dem die Prognoseganglinie erstellt wurde.
		<p>
		
		</p>
		
		@param _messquerschnitt der neue Wert von Messquerschnitt.
		*/
		public void setMessquerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messquerschnitt) {
			this._messquerschnitt = _messquerschnitt;
		}
	
		/**
		An dieser Stelle sind nur die Zustände "unbestimmt", "b-spline Approximation beliebiger Ordnung",
								"cubic-spline Interpolation" und "Polyline-Verfahren (lineare Interpolation)" sinnvoll.
		<p>
		
		</p>
		
		@return der Wert von GanglinienVerfahren.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
			 getGanglinienVerfahren() {
			return _ganglinienVerfahren;
		}
	
		/**
		An dieser Stelle sind nur die Zustände "unbestimmt", "b-spline Approximation beliebiger Ordnung",
								"cubic-spline Interpolation" und "Polyline-Verfahren (lineare Interpolation)" sinnvoll.
		<p>
		
		</p>
		
		@param _ganglinienVerfahren der neue Wert von GanglinienVerfahren.
		*/
		public void setGanglinienVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
		 _ganglinienVerfahren) {
			this._ganglinienVerfahren = _ganglinienVerfahren;
		}
	
		/**
		Ordnung der b-spline Approximation (nur in Verbindung mit der b-spline Approximation).
		<p>
		
		</p>
		
		@return der Wert von Ordnung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getOrdnung() {
			return _ordnung;
		}
	
		/**
		Ordnung der b-spline Approximation (nur in Verbindung mit der b-spline Approximation).
		<p>
		
		</p>
		
		@param _ordnung der neue Wert von Ordnung.
		*/
		public void setOrdnung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _ordnung) {
			this._ordnung = _ordnung;
		}
	
		/**
		Startzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@return der Wert von ZeitpunktPrognoseBeginn.
		*/
			public 	Zeitstempel
			 getZeitpunktPrognoseBeginn() {
			return _zeitpunktPrognoseBeginn;
		}
	
		/**
		Startzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@param _zeitpunktPrognoseBeginn der neue Wert von ZeitpunktPrognoseBeginn.
		*/
		public void setZeitpunktPrognoseBeginn(	Zeitstempel
		 _zeitpunktPrognoseBeginn) {
			this._zeitpunktPrognoseBeginn = _zeitpunktPrognoseBeginn;
		}
	
		/**
		Endzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@return der Wert von ZeitpunktPrognoseEnde.
		*/
			public 	Zeitstempel
			 getZeitpunktPrognoseEnde() {
			return _zeitpunktPrognoseEnde;
		}
	
		/**
		Endzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@param _zeitpunktPrognoseEnde der neue Wert von ZeitpunktPrognoseEnde.
		*/
		public void setZeitpunktPrognoseEnde(	Zeitstempel
		 _zeitpunktPrognoseEnde) {
			this._zeitpunktPrognoseEnde = _zeitpunktPrognoseEnde;
		}
	
		/**
		Definition einer Stützstelle.
		<p>
		
		</p>
		
		@return der Wert von Stuetzstelle.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
			> getStuetzstelle() {
			return _stuetzstelle;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessquerschnitt = getMessquerschnitt();
					final SystemObject tmpMessquerschnitt;
						if (soMessquerschnitt instanceof SystemObject) {
							tmpMessquerschnitt = (SystemObject)soMessquerschnitt;
						} else if(soMessquerschnitt instanceof SystemObjekt){
							tmpMessquerschnitt = ((SystemObjekt)soMessquerschnitt).getSystemObject();
						} else{
							tmpMessquerschnitt = null;
						}
					datum.getReferenceValue("Messquerschnitt").setSystemObject(tmpMessquerschnitt);
				// GanzzahlAttributTyp
				if (getGanglinienVerfahren() != null) {
	                if (getGanglinienVerfahren().isZustand()) {
	                    datum.getUnscaledValue("GanglinienVerfahren").setText(getGanglinienVerfahren().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GanglinienVerfahren").set(getGanglinienVerfahren().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOrdnung() != null) {
	                if (getOrdnung().isZustand()) {
	                    datum.getUnscaledValue("Ordnung").setText(getOrdnung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Ordnung").set(getOrdnung().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitpunktPrognoseBeginn").setMillis(getZeitpunktPrognoseBeginn().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitpunktPrognoseEnde").setMillis(getZeitpunktPrognoseEnde().getTime());
				// AttributListenDefinition
					final Data.Array arrayStuetzstelle = datum.getArray("Stützstelle");
					arrayStuetzstelle.setLength(getStuetzstelle().size());
					for (int i = 0; i < arrayStuetzstelle.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
						 atl = getStuetzstelle().get(i);
						atl.bean2Atl(arrayStuetzstelle.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessquerschnitt = daten.getReferenceValue("Messquerschnitt").getId();
					final SystemObjekt tmpMessquerschnitt;
					if (idMessquerschnitt == 0) {
						tmpMessquerschnitt = null;
					} else {
						final SystemObject soMessquerschnitt = factory.getDav().getDataModel().getObject(idMessquerschnitt);
						if (soMessquerschnitt == null) {
								tmpMessquerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessquerschnitt);
						} else {
							tmpMessquerschnitt = factory.getModellobjekt(soMessquerschnitt);
						}
					}
					setMessquerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessquerschnitt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GanglinienVerfahren").isState()) {
							setGanglinienVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
							.getZustand(daten.getScaledValue("GanglinienVerfahren").getText()));
						} else {
						setGanglinienVerfahren(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
						(daten.
							getUnscaledValue
						("GanglinienVerfahren").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setOrdnung(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("Ordnung").
								longValue
						()));
				// ZeitstempelAttributTyp
					setZeitpunktPrognoseBeginn(new
						Zeitstempel
						(daten.getTimeValue("ZeitpunktPrognoseBeginn").getMillis()));
				// ZeitstempelAttributTyp
					setZeitpunktPrognoseEnde(new
						Zeitstempel
						(daten.getTimeValue("ZeitpunktPrognoseEnde").getMillis()));
				// AttributListenDefinition
					final Data.Array arrayStuetzstelle = daten.getArray("Stützstelle");
					for (int i = 0; i < arrayStuetzstelle.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AtlStuetzstelle
						 ();
						atl.atl2Bean(arrayStuetzstelle.getItem(i), factory);
						getStuetzstelle().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPrognoseGanglinie clone() {
		AtlPrognoseGanglinie klon = new AtlPrognoseGanglinie();
		
						klon.setMessquerschnitt(getMessquerschnitt());
						klon.setGanglinienVerfahren(getGanglinienVerfahren());
						klon.setOrdnung(getOrdnung());
						klon.setZeitpunktPrognoseBeginn(getZeitpunktPrognoseBeginn());
						klon.setZeitpunktPrognoseEnde(getZeitpunktPrognoseEnde());
					klon._stuetzstelle = getStuetzstelle().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
