/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Spezifikation einer angefragten Prognoseganglinie.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AtlPrognoseGanglinienAnfrage implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messquerschnitt
			;
			private 	Zeitstempel
			 _zeitpunktPrognoseBeginn
			;
			private 	Zeitstempel
			 _zeitpunktPrognoseEnde
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _nurLangfristigeAuswahl
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			> _ereignisTyp = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			>(1, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _zyklischePrognose
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _ueberpruefungsintervall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _aktualisierungsschwelle
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _aktualisierungsintervall
			;
	
		/**
		Messquerschnitt, zu dem die Prognoseganglinie erstellt werden soll.
		<p>
		
		</p>
		
		@return der Wert von Messquerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessquerschnitt() {
			return _messquerschnitt;
		}
	
		/**
		Messquerschnitt, zu dem die Prognoseganglinie erstellt werden soll.
		<p>
		
		</p>
		
		@param _messquerschnitt der neue Wert von Messquerschnitt.
		*/
		public void setMessquerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messquerschnitt) {
			this._messquerschnitt = _messquerschnitt;
		}
	
		/**
		Startzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@return der Wert von ZeitpunktPrognoseBeginn.
		*/
			public 	Zeitstempel
			 getZeitpunktPrognoseBeginn() {
			return _zeitpunktPrognoseBeginn;
		}
	
		/**
		Startzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@param _zeitpunktPrognoseBeginn der neue Wert von ZeitpunktPrognoseBeginn.
		*/
		public void setZeitpunktPrognoseBeginn(	Zeitstempel
		 _zeitpunktPrognoseBeginn) {
			this._zeitpunktPrognoseBeginn = _zeitpunktPrognoseBeginn;
		}
	
		/**
		Endzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@return der Wert von ZeitpunktPrognoseEnde.
		*/
			public 	Zeitstempel
			 getZeitpunktPrognoseEnde() {
			return _zeitpunktPrognoseEnde;
		}
	
		/**
		Endzeitpunkt der gewüschten Ganglinienprognose.
		<p>
		
		</p>
		
		@param _zeitpunktPrognoseEnde der neue Wert von ZeitpunktPrognoseEnde.
		*/
		public void setZeitpunktPrognoseEnde(	Zeitstempel
		 _zeitpunktPrognoseEnde) {
			this._zeitpunktPrognoseEnde = _zeitpunktPrognoseEnde;
		}
	
		/**
		Nur Auswahlverfahren der langfristigen Prognose benutzen.
		<p>
		
		</p>
		
		@return der Wert von NurLangfristigeAuswahl.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNurLangfristigeAuswahl() {
			return _nurLangfristigeAuswahl;
		}
	
		/**
		Nur Auswahlverfahren der langfristigen Prognose benutzen.
		<p>
		
		</p>
		
		@param _nurLangfristigeAuswahl der neue Wert von NurLangfristigeAuswahl.
		*/
		public void setNurLangfristigeAuswahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _nurLangfristigeAuswahl) {
			this._nurLangfristigeAuswahl = _nurLangfristigeAuswahl;
		}
	
		/**
		Diese Ereignistypen werden bei der Auswahl in der Ganglinienprognose ignoriert.
		<p>
		
		</p>
		
		@return der Wert von EreignisTyp.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			> getEreignisTyp() {
			return _ereignisTyp;
		}
	
	
		/**
		Ja: zyklische Prognose, Nein: einmalige Prognose.
		<p>
		
		</p>
		
		@return der Wert von ZyklischePrognose.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getZyklischePrognose() {
			return _zyklischePrognose;
		}
	
		/**
		Ja: zyklische Prognose, Nein: einmalige Prognose.
		<p>
		
		</p>
		
		@param _zyklischePrognose der neue Wert von ZyklischePrognose.
		*/
		public void setZyklischePrognose(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _zyklischePrognose) {
			this._zyklischePrognose = _zyklischePrognose;
		}
	
		/**
		Spätestens nach Ablauf dieses Intervalls wird eine zyklische Prognose neu überprüft.
		<p>
		
		</p>
		
		@return der Wert von Ueberpruefungsintervall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 getUeberpruefungsintervall() {
			return _ueberpruefungsintervall;
		}
	
		/**
		Spätestens nach Ablauf dieses Intervalls wird eine zyklische Prognose neu überprüft.
		<p>
		
		</p>
		
		@param _ueberpruefungsintervall der neue Wert von Ueberpruefungsintervall.
		*/
		public void setUeberpruefungsintervall(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
		 _ueberpruefungsintervall) {
			this._ueberpruefungsintervall = _ueberpruefungsintervall;
		}
	
		/**
		Nur wenn der Abstand einer berechneten zur alten prognostizierten Ganglinie diese Schwelle überschreitet, wird die neue Prognoseganglinie publiziert.
		<p>
		
		</p>
		
		@return der Wert von Aktualisierungsschwelle.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getAktualisierungsschwelle() {
			return _aktualisierungsschwelle;
		}
	
		/**
		Nur wenn der Abstand einer berechneten zur alten prognostizierten Ganglinie diese Schwelle überschreitet, wird die neue Prognoseganglinie publiziert.
		<p>
		
		</p>
		
		@param _aktualisierungsschwelle der neue Wert von Aktualisierungsschwelle.
		*/
		public void setAktualisierungsschwelle(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _aktualisierungsschwelle) {
			this._aktualisierungsschwelle = _aktualisierungsschwelle;
		}
	
		/**
		Auch ohne Überschreiten der Aktuallisierungschwelle wird nach diesem Intervall eine neue Prognoseganglinie publiziert.
		<p>
		
		</p>
		
		@return der Wert von Aktualisierungsintervall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 getAktualisierungsintervall() {
			return _aktualisierungsintervall;
		}
	
		/**
		Auch ohne Überschreiten der Aktuallisierungschwelle wird nach diesem Intervall eine neue Prognoseganglinie publiziert.
		<p>
		
		</p>
		
		@param _aktualisierungsintervall der neue Wert von Aktualisierungsintervall.
		*/
		public void setAktualisierungsintervall(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
		 _aktualisierungsintervall) {
			this._aktualisierungsintervall = _aktualisierungsintervall;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessquerschnitt = getMessquerschnitt();
					final SystemObject tmpMessquerschnitt;
						if (soMessquerschnitt instanceof SystemObject) {
							tmpMessquerschnitt = (SystemObject)soMessquerschnitt;
						} else if(soMessquerschnitt instanceof SystemObjekt){
							tmpMessquerschnitt = ((SystemObjekt)soMessquerschnitt).getSystemObject();
						} else{
							tmpMessquerschnitt = null;
						}
					datum.getReferenceValue("Messquerschnitt").setSystemObject(tmpMessquerschnitt);
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitpunktPrognoseBeginn").setMillis(getZeitpunktPrognoseBeginn().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZeitpunktPrognoseEnde").setMillis(getZeitpunktPrognoseEnde().getTime());
				// GanzzahlAttributTyp
				if (getNurLangfristigeAuswahl() != null) {
	                if (getNurLangfristigeAuswahl().isZustand()) {
	                    datum.getUnscaledValue("NurLangfristigeAuswahl").setText(getNurLangfristigeAuswahl().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NurLangfristigeAuswahl").set(getNurLangfristigeAuswahl().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEreignisTyp = datum.getReferenceArray("EreignisTyp");
					arrayEreignisTyp.setLength(getEreignisTyp().size());
					for (int i = 0; i < arrayEreignisTyp.getLength(); ++i) {
						final Object soEreignisTyp = getEreignisTyp().get(i);
						final SystemObject tmpEreignisTyp;
						if (soEreignisTyp instanceof SystemObject) {
							tmpEreignisTyp = (SystemObject)soEreignisTyp;
						} else if(soEreignisTyp instanceof SystemObjekt){
							tmpEreignisTyp = ((SystemObjekt)soEreignisTyp).getSystemObject();
						} else{
							tmpEreignisTyp = null;
						}
						arrayEreignisTyp.getReferenceValue(i).setSystemObject(tmpEreignisTyp);
					}
				// GanzzahlAttributTyp
				if (getZyklischePrognose() != null) {
	                if (getZyklischePrognose().isZustand()) {
	                    datum.getUnscaledValue("ZyklischePrognose").setText(getZyklischePrognose().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ZyklischePrognose").set(getZyklischePrognose().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUeberpruefungsintervall() != null) {
	                if (getUeberpruefungsintervall().isZustand()) {
	                    datum.getUnscaledValue("Überprüfungsintervall").setText(getUeberpruefungsintervall().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Überprüfungsintervall").set(getUeberpruefungsintervall().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAktualisierungsschwelle() != null) {
	                if (getAktualisierungsschwelle().isZustand()) {
	                    datum.getUnscaledValue("Aktualisierungsschwelle").setText(getAktualisierungsschwelle().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktualisierungsschwelle").set(getAktualisierungsschwelle().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAktualisierungsintervall() != null) {
	                if (getAktualisierungsintervall().isZustand()) {
	                    datum.getUnscaledValue("Aktualisierungsintervall").setText(getAktualisierungsintervall().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktualisierungsintervall").set(getAktualisierungsintervall().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessquerschnitt = daten.getReferenceValue("Messquerschnitt").getId();
					final SystemObjekt tmpMessquerschnitt;
					if (idMessquerschnitt == 0) {
						tmpMessquerschnitt = null;
					} else {
						final SystemObject soMessquerschnitt = factory.getDav().getDataModel().getObject(idMessquerschnitt);
						if (soMessquerschnitt == null) {
								tmpMessquerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessquerschnitt);
						} else {
							tmpMessquerschnitt = factory.getModellobjekt(soMessquerschnitt);
						}
					}
					setMessquerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessquerschnitt);
				// ZeitstempelAttributTyp
					setZeitpunktPrognoseBeginn(new
						Zeitstempel
						(daten.getTimeValue("ZeitpunktPrognoseBeginn").getMillis()));
				// ZeitstempelAttributTyp
					setZeitpunktPrognoseEnde(new
						Zeitstempel
						(daten.getTimeValue("ZeitpunktPrognoseEnde").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NurLangfristigeAuswahl").isState()) {
							setNurLangfristigeAuswahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NurLangfristigeAuswahl").getText()));
						} else {
						setNurLangfristigeAuswahl(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NurLangfristigeAuswahl").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEreignisTyp = daten.getReferenceArray("EreignisTyp");
					for (int i = 0; i < arrayEreignisTyp.getLength(); ++i) {
						final long idEreignisTyp = daten.getReferenceArray("EreignisTyp").getReferenceValue(i).getId();
						final SystemObjekt tmpEreignisTyp;
						if (idEreignisTyp == 0) {
							tmpEreignisTyp = null;
						} else {
							final SystemObject soEreignisTyp = factory.getDav().getDataModel().getObject(idEreignisTyp);
							if (soEreignisTyp == null) {
									tmpEreignisTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTyp);
							} else {
								tmpEreignisTyp = factory.getModellobjekt(soEreignisTyp);
							}
						}
							getEreignisTyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
							) tmpEreignisTyp);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ZyklischePrognose").isState()) {
							setZyklischePrognose(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("ZyklischePrognose").getText()));
						} else {
						setZyklischePrognose(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("ZyklischePrognose").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setUeberpruefungsintervall(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
						(daten.
							getUnscaledValue
						("Überprüfungsintervall").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktualisierungsschwelle").isState()) {
							setAktualisierungsschwelle(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Aktualisierungsschwelle").getText()));
						} else {
						setAktualisierungsschwelle(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Aktualisierungsschwelle").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setAktualisierungsintervall(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
						(daten.
							getUnscaledValue
						("Aktualisierungsintervall").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPrognoseGanglinienAnfrage clone() {
		AtlPrognoseGanglinienAnfrage klon = new AtlPrognoseGanglinienAnfrage();
		
						klon.setMessquerschnitt(getMessquerschnitt());
						klon.setZeitpunktPrognoseBeginn(getZeitpunktPrognoseBeginn());
						klon.setZeitpunktPrognoseEnde(getZeitpunktPrognoseEnde());
						klon.setNurLangfristigeAuswahl(getNurLangfristigeAuswahl());
					klon._ereignisTyp = getEreignisTyp().clone();
						klon.setZyklischePrognose(getZyklischePrognose());
						klon.setUeberpruefungsintervall(getUeberpruefungsintervall());
						klon.setAktualisierungsschwelle(getAktualisierungsschwelle());
						klon.setAktualisierungsintervall(getAktualisierungsintervall());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
