/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommando (Typ) der Anfrage: Lesen, Schreiben oder Löschen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AttGanglinienSpeicherKommandoAnfrage extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kommando zum Lesen und Schreiben nichtleerer Ganglinien. (Deprecated).
	<p>
	
	</p>
	*/
	public static final AttGanglinienSpeicherKommandoAnfrage ZUSTAND_0_LESENSCHREIBEN = new AttGanglinienSpeicherKommandoAnfrage("LesenSchreiben", 		Byte
	.valueOf("0"));

	/**
	Kommando zum Löschen von Ganglinien eines MQ.
	<p>
	
	</p>
	*/
	public static final AttGanglinienSpeicherKommandoAnfrage ZUSTAND_1_LOESCHEN = new AttGanglinienSpeicherKommandoAnfrage("Loeschen", 		Byte
	.valueOf("1"));

	/**
	Kommando zum Lesen von Ganglinien eines MQ.
	<p>
	
	</p>
	*/
	public static final AttGanglinienSpeicherKommandoAnfrage ZUSTAND_2_LESEN = new AttGanglinienSpeicherKommandoAnfrage("Lesen", 		Byte
	.valueOf("2"));

	/**
	Kommando zum Anlegen neuer Ganglinien für einen MQ.
	<p>
	
	</p>
	*/
	public static final AttGanglinienSpeicherKommandoAnfrage ZUSTAND_3_ANLEGEN = new AttGanglinienSpeicherKommandoAnfrage("Anlegen", 		Byte
	.valueOf("3"));

	/**
	Kommando zum Aktualisieren von Ganglinien eine MQ.
	<p>
	
	</p>
	*/
	public static final AttGanglinienSpeicherKommandoAnfrage ZUSTAND_4_AKTUALISIEREN = new AttGanglinienSpeicherKommandoAnfrage("Aktualisieren", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttGanglinienSpeicherKommandoAnfrage getZustand(final 		Byte
	 value) {
		for (AttGanglinienSpeicherKommandoAnfrage e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttGanglinienSpeicherKommandoAnfrage getZustand(final String value) {
		for (AttGanglinienSpeicherKommandoAnfrage e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttGanglinienSpeicherKommandoAnfrage> getZustaende() {
		List<AttGanglinienSpeicherKommandoAnfrage> list = new ArrayList<AttGanglinienSpeicherKommandoAnfrage>();
		list.add(ZUSTAND_0_LESENSCHREIBEN);
		list.add(ZUSTAND_1_LOESCHEN);
		list.add(ZUSTAND_2_LESEN);
		list.add(ZUSTAND_3_ANLEGEN);
		list.add(ZUSTAND_4_AKTUALISIEREN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KommandoAnfrage.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttGanglinienSpeicherKommandoAnfrage(final 		Byte
	 value) {
		super(value);
	}
	
	private AttGanglinienSpeicherKommandoAnfrage(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
