/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mathematisches Verfahren zur Approximation bzw. Interpolation.
<p>
&lt;absatz&gt;
						Bei absoluten Ganglinien wird mit diesem Attribut das mathematische Verfahren
						festgelegt, mit dem der Funktionswert einer Ganglinie an einem beliebigen
						Zwischenpunkt berechnet werden kann.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AttGanglinienVerfahren extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttGanglinienVerfahren ZUSTAND_0_UNBESTIMMT = new AttGanglinienVerfahren("unbestimmt", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttGanglinienVerfahren ZUSTAND_1_B_SPLINE_APPROXIMATION_BELIEBIGER_ORDNUNG = new AttGanglinienVerfahren("b-spline Approximation beliebiger Ordnung", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttGanglinienVerfahren ZUSTAND_2_CUBIC_SPLINE_INTERPOLATION = new AttGanglinienVerfahren("cubic-spline Interpolation", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttGanglinienVerfahren ZUSTAND_3_POLYLINE_VERFAHREN_LINEARE_INTERPOLATION_ = new AttGanglinienVerfahren("Polyline-Verfahren (lineare Interpolation)", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttGanglinienVerfahren getZustand(final 		Byte
	 value) {
		for (AttGanglinienVerfahren e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttGanglinienVerfahren getZustand(final String value) {
		for (AttGanglinienVerfahren e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttGanglinienVerfahren> getZustaende() {
		List<AttGanglinienVerfahren> list = new ArrayList<AttGanglinienVerfahren>();
		list.add(ZUSTAND_0_UNBESTIMMT);
		list.add(ZUSTAND_1_B_SPLINE_APPROXIMATION_BELIEBIGER_ORDNUNG);
		list.add(ZUSTAND_2_CUBIC_SPLINE_INTERPOLATION);
		list.add(ZUSTAND_3_POLYLINE_VERFAHREN_LINEARE_INTERPOLATION_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut GanglinienVerfahren.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttGanglinienVerfahren(final 		Byte
	 value) {
		super(value);
	}
	
	private AttGanglinienVerfahren(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
