/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Breitenangabe gemäß WGS84.
<p>
Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = -90000000L,
	maximum = 90000000L,
	skalierung = 1.0E-6,
	einheit = "Grad"
)
public class AttWgs84Breite extends Zahl<		Double
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MIN_VALUE =
					Double
			.valueOf("-90000000") * 		Double
			.valueOf("1.0E-6");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MAX_VALUE =
					Double
			.valueOf("90000000") * 		Double
			.valueOf("1.0E-6");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "Grad";
	
	/**
	Es sind keine Koordinaten definiert.
	<p>
	
	</p>
	*/
	public static final AttWgs84Breite ZUSTAND_200000000N_UNDEFINIERT = new AttWgs84Breite("undefiniert", 		Double
	.valueOf("-200000000"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttWgs84Breite getZustand(final 		Double
	 value) {
		for (AttWgs84Breite e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttWgs84Breite getZustand(final String value) {
		for (AttWgs84Breite e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttWgs84Breite> getZustaende() {
		List<AttWgs84Breite> list = new ArrayList<AttWgs84Breite>();
		list.add(ZUSTAND_200000000N_UNDEFINIERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Wgs84Breite.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttWgs84Breite(final 		Double
	 value) {
		super(value);
	}
	
	private AttWgs84Breite(final String zustand, final 		Double
	 value) {
		super(zustand, value);
	}
	
}
