/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Koordinaten einer Linie in Grad entsprechend WGS84.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdLinienKoordinaten extends AbstractKonfigurationsDatensatz<KdLinienKoordinaten.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				> _x = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				> _y = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				>(0, true);
		
			/**
			Längenangabe gemäß WGS84.
			<p>
			Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
			</p>
			
			@return der Wert von X.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				> getX() {
				return _x;
			}
		
		
			/**
			Breitenangabe gemäß WGS84.
			<p>
			Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
			</p>
			
			@return der Wert von Y.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				> getY() {
				return _y;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getX() != null) {
						final Data.NumberArray arrayX = datum.
							getScaledArray
							("x");
						arrayX.setLength(getX().size());
						for (int i = 0; i < arrayX.getLength(); ++i) {
							arrayX.getValue(i).set(getX().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getY() != null) {
						final Data.NumberArray arrayY = datum.
							getScaledArray
							("y");
						arrayY.setLength(getY().size());
						for (int i = 0; i < arrayY.getLength(); ++i) {
							arrayY.getValue(i).set(getY().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
						final Data.NumberArray arrayX = daten.
							getScaledArray
						("x");
		
						for (int i = 0; i < arrayX.getLength(); ++i) {
		                    if (arrayX.getValue(i).isState()) {
		                        getX().add(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
		                        .getZustand(arrayX.getValue(i).getState().getName()));
		                    } else {
		                    getX().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
		                    (arrayX.
		                    	doubleValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayY = daten.
							getScaledArray
						("y");
		
						for (int i = 0; i < arrayY.getLength(); ++i) {
		                    if (arrayY.getValue(i).isState()) {
		                        getY().add(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
		                        .getZustand(arrayY.getValue(i).getState().getName()));
		                    } else {
		                    getY().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
		                    (arrayY.
		                    	doubleValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._x = getX().clone();
						klon._y = getY().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.linienKoordinaten";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdLinienKoordinaten(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
