/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
IP: Kennbuchstaben: Schutz gegen Berühren und gegen Eindringen von Fremdkörpern und von Wasser.
<p>
Code Buchstabe (International Protection) (IP)

					Beispiel: IP 65:
					Erste Kennziffer (Schutz gegen feste Fremdkörper) 6
					Zweite Kennziffer (Schutz gegen Wasser) 5
					Definitionen:
					Erste Kennziffer
					Schutzumfang
					0: Kein Berührungsschutz, kein Schutz gegen feste Fremdkörper
					1 Schutz gegen großflächige Berührung mit der Hand Schutz gegen Fremdkörper Ø &gt;50 mm
					2 Schutz gegen Berührungen mit den Fingern Schutz gegen Fremdkörper Ø &gt;12 mm
					3 Schutz gegen Berührungen mit Werkzeug, Drähten o.ä. mit Ø &gt;2,5 mm Schutz gegen Fremdkörper Ø &gt;2,5 mm
					4 Schutz gegen Berührungen mit Werkzeug, Drähten o.ä. mit Ø &gt;1 mm Schutz gegen Fremdkörper Ø &gt;1 mm
					5 Schutz gegen Berührung Schutz gegen Staubablagerungen im Inneren
					6 Vollständiger Schutz gegen Berührung Schutz gegen Eindringen von Staub
					Erste Kennziffer
					Schutzumfang
					0: Kein Wasserschutz
					1 Schutz gegen senkrecht fallende Wassertropfen
					2 Schutz gegen schräg fallende Wassertropfen (beliebiger Winkel bis zu 15° zur Senkrechten)
					3 Schutz gegen Wasser aus beliebigem Winkel bis zu 60° aus der Senkrechten
					4 Schutz gegen Spritzwasser aus allen Richtungen
					5 Schutz gegen Wasserstrahl (Düse) aus beliebigem Winkel
					6 Schutz gegen vorübergehende Überflutung
					7 Schutz gegen Wassereindringung bei zeitweisem Eintauchen
					8 Schutz gegen Druckwasser bei dauerndem Untertauchen

					Darstellung in Anlehnung an DIN VDE 0470, DIN EN 60 529, IEC 60529
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttGeraetGehaeuseDichtigkeit extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttGeraetGehaeuseDichtigkeit ZUSTAND_1N_UNBESTIMMT = new AttGeraetGehaeuseDichtigkeit("Unbestimmt", 		Byte
	.valueOf("-1"));

	/**
	6: Erste Kennziffer: Schutz gegen Staubeintritt.
	
								Vollständiger Schutz gegen Berührung, Schutz gegen Eindringen von Staub.
	
								5: Zweite Kennziffer: Schutz gegen Strahlwasser.
	
								Schutz gegen Wasserstrahl (Düse) aus beliebigem Winkel.
	<p>
	
	</p>
	*/
	public static final AttGeraetGehaeuseDichtigkeit ZUSTAND_65__65 = new AttGeraetGehaeuseDichtigkeit("65", 		Byte
	.valueOf("65"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttGeraetGehaeuseDichtigkeit getZustand(final 		Byte
	 value) {
		for (AttGeraetGehaeuseDichtigkeit e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttGeraetGehaeuseDichtigkeit getZustand(final String value) {
		for (AttGeraetGehaeuseDichtigkeit e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttGeraetGehaeuseDichtigkeit> getZustaende() {
		List<AttGeraetGehaeuseDichtigkeit> list = new ArrayList<AttGeraetGehaeuseDichtigkeit>();
		list.add(ZUSTAND_1N_UNBESTIMMT);
		list.add(ZUSTAND_65__65);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Dichtigkeit.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttGeraetGehaeuseDichtigkeit(final 		Byte
	 value) {
		super(value);
	}
	
	private AttGeraetGehaeuseDichtigkeit(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
