/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine gültige Adresse zu dem Hersteller &#47; Lieferant &#47; Instandhalter; Problem: es kann mehrere geben.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAdressDatum extends AbstractKonfigurationsDatensatz<KdAdressDatum.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private String
				 _ort
				= new String
				()
				;
				private String
				 _strasse
				= new String
				()
				;
				private String
				 _hausnummer
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				> _postleitzahl = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				> _postfach = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				>(0, true);
				private Feld<String
				> _telefonnummern = new Feld<String
				>(0, true);
				private Feld<String
				> _email = new Feld<String
				>(0, true);
				private Feld<String
				> _telefax = new Feld<String
				>(0, true);
		
			/**
			Der Name des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Der Name des Standorts.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Der Ort des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Ort.
			*/
				public String
				 getOrt() {
				return _ort;
			}
		
			/**
			Der Ort des Standorts.
			<p>
			
			</p>
			
			@param _ort der neue Wert von Ort.
			*/
			public void setOrt(String
			 _ort) {
				if (_ort.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ort = _ort;
			}
		
			/**
			Die Strasse des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Strasse.
			*/
				public String
				 getStrasse() {
				return _strasse;
			}
		
			/**
			Die Strasse des Standorts.
			<p>
			
			</p>
			
			@param _strasse der neue Wert von Strasse.
			*/
			public void setStrasse(String
			 _strasse) {
				if (_strasse.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._strasse = _strasse;
			}
		
			/**
			Die Hausnummer des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Hausnummer.
			*/
				public String
				 getHausnummer() {
				return _hausnummer;
			}
		
			/**
			Die Hausnummer des Standorts.
			<p>
			
			</p>
			
			@param _hausnummer der neue Wert von Hausnummer.
			*/
			public void setHausnummer(String
			 _hausnummer) {
				if (_hausnummer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._hausnummer = _hausnummer;
			}
		
			/**
			Die Postleitzahl des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Postleitzahl.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				> getPostleitzahl() {
				return _postleitzahl;
			}
		
		
			/**
			Postfach des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Postfach.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				> getPostfach() {
				return _postfach;
			}
		
		
			/**
			Telefonnummer des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Telefonnummern.
			*/
				public Feld<String
				> getTelefonnummern() {
				return _telefonnummern;
			}
		
		
			/**
			Email des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Email.
			*/
				public Feld<String
				> getEmail() {
				return _email;
			}
		
		
			/**
			Telefax des Standorts.
			<p>
			
			</p>
			
			@return der Wert von Telefax.
			*/
				public Feld<String
				> getTelefax() {
				return _telefax;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getOrt() != null) {
						datum.getTextValue("Ort").setText(getOrt());
					}
					// ZeichenkettenAttributTyp
					if (getStrasse() != null) {
						datum.getTextValue("Strasse").setText(getStrasse());
					}
					// ZeichenkettenAttributTyp
					if (getHausnummer() != null) {
						datum.getTextValue("Hausnummer").setText(getHausnummer());
					}
					// GanzzahlAttributTyp
					if (getPostleitzahl() != null) {
						final Data.NumberArray arrayPostleitzahl = datum.
							getUnscaledArray
							("Postleitzahl");
						arrayPostleitzahl.setLength(getPostleitzahl().size());
						for (int i = 0; i < arrayPostleitzahl.getLength(); ++i) {
							arrayPostleitzahl.getValue(i).set(getPostleitzahl().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getPostfach() != null) {
						final Data.NumberArray arrayPostfach = datum.
							getUnscaledArray
							("Postfach");
						arrayPostfach.setLength(getPostfach().size());
						for (int i = 0; i < arrayPostfach.getLength(); ++i) {
							arrayPostfach.getValue(i).set(getPostfach().get(i).getValue());
						}
					}
					// ZeichenkettenAttributTyp
					if (getTelefonnummern() != null) {
						final Data.TextArray arrayTelefonnummern = datum.getTextArray("Telefonnummern");
						arrayTelefonnummern.setLength(getTelefonnummern().size());
						for (int i = 0; i < arrayTelefonnummern.getLength(); ++i) {
							arrayTelefonnummern.getTextValue(i).setText(getTelefonnummern().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getEmail() != null) {
						final Data.TextArray arrayEmail = datum.getTextArray("Email");
						arrayEmail.setLength(getEmail().size());
						for (int i = 0; i < arrayEmail.getLength(); ++i) {
							arrayEmail.getTextValue(i).setText(getEmail().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getTelefax() != null) {
						final Data.TextArray arrayTelefax = datum.getTextArray("Telefax");
						arrayTelefax.setLength(getTelefax().size());
						for (int i = 0; i < arrayTelefax.getLength(); ++i) {
							arrayTelefax.getTextValue(i).setText(getTelefax().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setOrt(daten.getTextValue("Ort").getText());
					// ZeichenkettenAttributTyp
						setStrasse(daten.getTextValue("Strasse").getText());
					// ZeichenkettenAttributTyp
						setHausnummer(daten.getTextValue("Hausnummer").getText());
					// GanzzahlAttributTyp
						final Data.NumberArray arrayPostleitzahl = daten.
							getUnscaledArray
						("Postleitzahl");
		
						for (int i = 0; i < arrayPostleitzahl.getLength(); ++i) {
		                    getPostleitzahl().add(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		                    (arrayPostleitzahl.
		                    		longValue
		                    (i)));
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayPostfach = daten.
							getUnscaledArray
						("Postfach");
		
						for (int i = 0; i < arrayPostfach.getLength(); ++i) {
		                    getPostfach().add(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		                    (arrayPostfach.
		                    		longValue
		                    (i)));
		                }
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayTelefonnummern = daten.getTextArray("Telefonnummern");
						for (int i = 0; i < arrayTelefonnummern.getLength(); ++i) {
							getTelefonnummern().add(arrayTelefonnummern.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayEmail = daten.getTextArray("Email");
						for (int i = 0; i < arrayEmail.getLength(); ++i) {
							getEmail().add(arrayEmail.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayTelefax = daten.getTextArray("Telefax");
						for (int i = 0; i < arrayTelefax.getLength(); ++i) {
							getTelefax().add(arrayTelefax.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
							klon.setOrt(getOrt());
							klon.setStrasse(getStrasse());
							klon.setHausnummer(getHausnummer());
						klon._postleitzahl = getPostleitzahl().clone();
						klon._postfach = getPostfach().clone();
						klon._telefonnummern = getTelefonnummern().clone();
						klon._email = getEmail().clone();
						klon._telefax = getTelefax().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.adressDatum";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAdressDatum(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
