/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines konkreten Einbauorts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdEinbauOrt extends AbstractKonfigurationsDatensatz<KdEinbauOrt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<String
				> _dokumentation = new Feld<String
				>(0, true);
				private Feld<String
				> _bilder = new Feld<String
				>(0, true);
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				 _einbauOrtTyp
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
				 _hochbauSchrankSchacht
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
				> _enthalteneEinbauOrte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
				>(0, true);
		
			/**
			Dokumentation zum konkreten Einbauort, z.B. spezielle Schaltpläne, Zeichnungen.
			<p>
			
			</p>
			
			@return der Wert von Dokumentation.
			*/
				public Feld<String
				> getDokumentation() {
				return _dokumentation;
			}
		
		
			/**
			Bilder zum konkreten Einbauort.
			<p>
			
			</p>
			
			@return der Wert von Bilder.
			*/
				public Feld<String
				> getBilder() {
				return _bilder;
			}
		
		
			/**
			Referenz auf den Typ, von dem dieser konkrete Einbauort ist.
			<p>
			
			</p>
			
			@return der Wert von EinbauOrtTyp.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				 getEinbauOrtTyp() {
				return _einbauOrtTyp;
			}
		
			/**
			Referenz auf den Typ, von dem dieser konkrete Einbauort ist.
			<p>
			
			</p>
			
			@param _einbauOrtTyp der neue Wert von EinbauOrtTyp.
			*/
			public void setEinbauOrtTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
			 _einbauOrtTyp) {
				this._einbauOrtTyp = _einbauOrtTyp;
			}
		
			/**
			Referenz auf den Ort (Hochbau,Schrank,Schacht, in dem sich der Einbauort befindet.
			<p>
			
			</p>
			
			@return der Wert von HochbauSchrankSchacht.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
				 getHochbauSchrankSchacht() {
				return _hochbauSchrankSchacht;
			}
		
			/**
			Referenz auf den Ort (Hochbau,Schrank,Schacht, in dem sich der Einbauort befindet.
			<p>
			
			</p>
			
			@param _hochbauSchrankSchacht der neue Wert von HochbauSchrankSchacht.
			*/
			public void setHochbauSchrankSchacht(	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
			 _hochbauSchrankSchacht) {
				this._hochbauSchrankSchacht = _hochbauSchrankSchacht;
			}
		
			/**
			Referenz auf weitere Einbauorte, die(direkt in diesem Einbauort enthalten sind (und die wiederum andere Einbauorte beinhalten können. Beispiel: Ein 19''-Rahmen beinhaltet mehrere Racks, die wiederum Einbauplätze für Rechner enthalten. Also 1. HierarchieebeneEinbauort 19''-Rahmen, 2. Hierarchieebene Einbauort Rack, 3.Hierarchieebene Einbauort Einschubplatz für Rechner.
			<p>
			
			</p>
			
			@return der Wert von EnthalteneEinbauOrte.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
				> getEnthalteneEinbauOrte() {
				return _enthalteneEinbauOrte;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getDokumentation() != null) {
						final Data.TextArray arrayDokumentation = datum.getTextArray("Dokumentation");
						arrayDokumentation.setLength(getDokumentation().size());
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							arrayDokumentation.getTextValue(i).setText(getDokumentation().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBilder() != null) {
						final Data.TextArray arrayBilder = datum.getTextArray("Bilder");
						arrayBilder.setLength(getBilder().size());
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							arrayBilder.getTextValue(i).setText(getBilder().get(i));
						}
					}
					// ObjektReferenzAttributTyp
						final Object soEinbauOrtTyp = getEinbauOrtTyp();
						final SystemObject tmpEinbauOrtTyp;
							if (soEinbauOrtTyp instanceof SystemObject) {
								tmpEinbauOrtTyp = (SystemObject)soEinbauOrtTyp;
							} else if(soEinbauOrtTyp instanceof SystemObjekt){
								tmpEinbauOrtTyp = ((SystemObjekt)soEinbauOrtTyp).getSystemObject();
							} else{
								tmpEinbauOrtTyp = null;
							}
						datum.getReferenceValue("EinbauOrtTyp").setSystemObject(tmpEinbauOrtTyp);
					// ObjektReferenzAttributTyp
						final Object soHochbauSchrankSchacht = getHochbauSchrankSchacht();
						final SystemObject tmpHochbauSchrankSchacht;
							if (soHochbauSchrankSchacht instanceof SystemObject) {
								tmpHochbauSchrankSchacht = (SystemObject)soHochbauSchrankSchacht;
							} else if(soHochbauSchrankSchacht instanceof SystemObjekt){
								tmpHochbauSchrankSchacht = ((SystemObjekt)soHochbauSchrankSchacht).getSystemObject();
							} else{
								tmpHochbauSchrankSchacht = null;
							}
						datum.getReferenceValue("HochbauSchrankSchacht").setSystemObject(tmpHochbauSchrankSchacht);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayEnthalteneEinbauOrte = datum.getReferenceArray("EnthalteneEinbauOrte");
						arrayEnthalteneEinbauOrte.setLength(getEnthalteneEinbauOrte().size());
						for (int i = 0; i < arrayEnthalteneEinbauOrte.getLength(); ++i) {
							final Object soEnthalteneEinbauOrte = getEnthalteneEinbauOrte().get(i);
							final SystemObject tmpEnthalteneEinbauOrte;
							if (soEnthalteneEinbauOrte instanceof SystemObject) {
								tmpEnthalteneEinbauOrte = (SystemObject)soEnthalteneEinbauOrte;
							} else if(soEnthalteneEinbauOrte instanceof SystemObjekt){
								tmpEnthalteneEinbauOrte = ((SystemObjekt)soEnthalteneEinbauOrte).getSystemObject();
							} else{
								tmpEnthalteneEinbauOrte = null;
							}
							arrayEnthalteneEinbauOrte.getReferenceValue(i).setSystemObject(tmpEnthalteneEinbauOrte);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDokumentation = daten.getTextArray("Dokumentation");
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							getDokumentation().add(arrayDokumentation.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayBilder = daten.getTextArray("Bilder");
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							getBilder().add(arrayBilder.getText(i));
						}
					// ObjektReferenzAttributTyp
						final long idEinbauOrtTyp = daten.getReferenceValue("EinbauOrtTyp").getId();
						final SystemObjekt tmpEinbauOrtTyp;
						if (idEinbauOrtTyp == 0) {
							tmpEinbauOrtTyp = null;
						} else {
							final SystemObject soEinbauOrtTyp = factory.getDav().getDataModel().getObject(idEinbauOrtTyp);
							if (soEinbauOrtTyp == null) {
									tmpEinbauOrtTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtTypUngueltig(idEinbauOrtTyp);
							} else {
								tmpEinbauOrtTyp = factory.getModellobjekt(soEinbauOrtTyp);
							}
						}
						setEinbauOrtTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
						) tmpEinbauOrtTyp);
					// ObjektReferenzAttributTyp
						final long idHochbauSchrankSchacht = daten.getReferenceValue("HochbauSchrankSchacht").getId();
						final SystemObjekt tmpHochbauSchrankSchacht;
						if (idHochbauSchrankSchacht == 0) {
							tmpHochbauSchrankSchacht = null;
						} else {
							final SystemObject soHochbauSchrankSchacht = factory.getDav().getDataModel().getObject(idHochbauSchrankSchacht);
							if (soHochbauSchrankSchacht == null) {
									tmpHochbauSchrankSchacht = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.HochbauSchrankSchachtUngueltig(idHochbauSchrankSchacht);
							} else {
								tmpHochbauSchrankSchacht = factory.getModellobjekt(soHochbauSchrankSchacht);
							}
						}
						setHochbauSchrankSchacht((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
						) tmpHochbauSchrankSchacht);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayEnthalteneEinbauOrte = daten.getReferenceArray("EnthalteneEinbauOrte");
						for (int i = 0; i < arrayEnthalteneEinbauOrte.getLength(); ++i) {
							final long idEnthalteneEinbauOrte = daten.getReferenceArray("EnthalteneEinbauOrte").getReferenceValue(i).getId();
							final SystemObjekt tmpEnthalteneEinbauOrte;
							if (idEnthalteneEinbauOrte == 0) {
								tmpEnthalteneEinbauOrte = null;
							} else {
								final SystemObject soEnthalteneEinbauOrte = factory.getDav().getDataModel().getObject(idEnthalteneEinbauOrte);
								if (soEnthalteneEinbauOrte == null) {
										tmpEnthalteneEinbauOrte = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtUngueltig(idEnthalteneEinbauOrte);
								} else {
									tmpEnthalteneEinbauOrte = factory.getModellobjekt(soEnthalteneEinbauOrte);
								}
							}
								getEnthalteneEinbauOrte().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
								) tmpEnthalteneEinbauOrte);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._dokumentation = getDokumentation().clone();
						klon._bilder = getBilder().clone();
							klon.setEinbauOrtTyp(getEinbauOrtTyp());
							klon.setHochbauSchrankSchacht(getHochbauSchrankSchacht());
						klon._enthalteneEinbauOrte = getEnthalteneEinbauOrte().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.einbauOrt";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdEinbauOrt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
