/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines konkreten Hochbaus &#47; Schranks &#47; Schachts ...
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdHochbauSchrankSchacht extends AbstractKonfigurationsDatensatz<KdHochbauSchrankSchacht.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchachtTyp
				 _hochbauSchrankSchachtTyp
				;
				private Feld<String
				> _dokumentation = new Feld<String
				>(0, true);
				private Feld<String
				> _bilder = new Feld<String
				>(0, true);
				private Feld<String
				> _lageplan = new Feld<String
				>(0, true);
				private String
				 _bezeichnung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
				 _standort
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
				> _einbauOrte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _hoeheUeberNN
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _abstandStrasse
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
				 _referenzZuPunktLiegtAufLinienObjekt
				;
		
			/**
			Referenz auf dcen Typ, von dem dieser konkrete Hochbau &#47; Schrank &#47; Schacht&#47;...ist.
			<p>
			
			</p>
			
			@return der Wert von HochbauSchrankSchachtTyp.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchachtTyp
				 getHochbauSchrankSchachtTyp() {
				return _hochbauSchrankSchachtTyp;
			}
		
			/**
			Referenz auf dcen Typ, von dem dieser konkrete Hochbau &#47; Schrank &#47; Schacht&#47;...ist.
			<p>
			
			</p>
			
			@param _hochbauSchrankSchachtTyp der neue Wert von HochbauSchrankSchachtTyp.
			*/
			public void setHochbauSchrankSchachtTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchachtTyp
			 _hochbauSchrankSchachtTyp) {
				this._hochbauSchrankSchachtTyp = _hochbauSchrankSchachtTyp;
			}
		
			/**
			Dokumentation zum konkreten Hochbau &#47; Schrank &#47; Schacht, z.B. spezielle Schaltpläne, Zeichnungen.
			<p>
			
			</p>
			
			@return der Wert von Dokumentation.
			*/
				public Feld<String
				> getDokumentation() {
				return _dokumentation;
			}
		
		
			/**
			Bilder zum konkreten Hochbau &#47; Schrank &#47; Schacht.
			<p>
			
			</p>
			
			@return der Wert von Bilder.
			*/
				public Feld<String
				> getBilder() {
				return _bilder;
			}
		
		
			/**
			Link auf einen Lageplan zu dem konkreten Hochbau &#47; Schrank &#47; Schacht.
			<p>
			
			</p>
			
			@return der Wert von Lageplan.
			*/
				public Feld<String
				> getLageplan() {
				return _lageplan;
			}
		
		
			/**
			Bezeichnung des Hochbau &#47; Schrank &#47; Schacht.
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Bezeichnung des Hochbau &#47; Schrank &#47; Schacht.
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
			/**
			Referenz auf den Punkt, an dem sich der Hochbau &#47; Schrank &#47; Schacht befindet. Wenn das Objekt sich an einer Strasse befindet, kann der Wert identisch mit ReferenzZuPunktLiegtAuf LinienObjekt sein.
			<p>
			
			</p>
			
			@return der Wert von Standort.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
				 getStandort() {
				return _standort;
			}
		
			/**
			Referenz auf den Punkt, an dem sich der Hochbau &#47; Schrank &#47; Schacht befindet. Wenn das Objekt sich an einer Strasse befindet, kann der Wert identisch mit ReferenzZuPunktLiegtAuf LinienObjekt sein.
			<p>
			
			</p>
			
			@param _standort der neue Wert von Standort.
			*/
			public void setStandort(	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
			 _standort) {
				this._standort = _standort;
			}
		
			/**
			Referenz auf die konkreten Einbauorte, .
			<p>
			Referenz auf die konkreten Einbauorte, die sich gemäss Typ des Hochbaus &#47;Schranks&#47; Schachts in der ersten Hierarchieebene zwingend in diesem Hochbau &#47; Schrank &#47; Schacht befinden (z.B: Lagerraum, wenn ein Kabelhaus prizipiell Platz zum Lagern bietet, 19''-Rahmen im Fall eines Streckenstationsschranks...
			</p>
			
			@return der Wert von EinbauOrte.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
				> getEinbauOrte() {
				return _einbauOrte;
			}
		
		
			/**
			Hoehe dieses Standorts ueber NN, kann herangezogen werden, um die Zulässigkeit höhenempfindlicher Geraete zu prüfen.
			<p>
			
			</p>
			
			@return der Wert von HoeheUeberNN.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getHoeheUeberNN() {
				return _hoeheUeberNN;
			}
		
			/**
			Hoehe dieses Standorts ueber NN, kann herangezogen werden, um die Zulässigkeit höhenempfindlicher Geraete zu prüfen.
			<p>
			
			</p>
			
			@param _hoeheUeberNN der neue Wert von HoeheUeberNN.
			*/
			public void setHoeheUeberNN(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _hoeheUeberNN) {
				this._hoeheUeberNN = _hoeheUeberNN;
			}
		
			/**
			Abstand der Standorts von der Strasse, rechtwinklig vom rechten Fahrbahnrand gemessen, negative WErte sagen also aus, dass sich der Standort links von der referenzierten Fahrbahn (PunktLiegtAufLinienObjekt) befindet, also z.B. im Mittelstreifen.
			<p>
			
			</p>
			
			@return der Wert von AbstandStrasse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getAbstandStrasse() {
				return _abstandStrasse;
			}
		
			/**
			Abstand der Standorts von der Strasse, rechtwinklig vom rechten Fahrbahnrand gemessen, negative WErte sagen also aus, dass sich der Standort links von der referenzierten Fahrbahn (PunktLiegtAufLinienObjekt) befindet, also z.B. im Mittelstreifen.
			<p>
			
			</p>
			
			@param _abstandStrasse der neue Wert von AbstandStrasse.
			*/
			public void setAbstandStrasse(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _abstandStrasse) {
				this._abstandStrasse = _abstandStrasse;
			}
		
			/**
			Referenz zum Punkt an der Strasse, an dem das Objekt liegt. Im Unterschied zum Standort ggf. auch nur der Punkt an der Strasse, von dem das Objekt sinnvoll erreichbar ist.
			<p>
			
			</p>
			
			@return der Wert von ReferenzZuPunktLiegtAufLinienObjekt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
				 getReferenzZuPunktLiegtAufLinienObjekt() {
				return _referenzZuPunktLiegtAufLinienObjekt;
			}
		
			/**
			Referenz zum Punkt an der Strasse, an dem das Objekt liegt. Im Unterschied zum Standort ggf. auch nur der Punkt an der Strasse, von dem das Objekt sinnvoll erreichbar ist.
			<p>
			
			</p>
			
			@param _referenzZuPunktLiegtAufLinienObjekt der neue Wert von ReferenzZuPunktLiegtAufLinienObjekt.
			*/
			public void setReferenzZuPunktLiegtAufLinienObjekt(	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
			 _referenzZuPunktLiegtAufLinienObjekt) {
				this._referenzZuPunktLiegtAufLinienObjekt = _referenzZuPunktLiegtAufLinienObjekt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soHochbauSchrankSchachtTyp = getHochbauSchrankSchachtTyp();
						final SystemObject tmpHochbauSchrankSchachtTyp;
							if (soHochbauSchrankSchachtTyp instanceof SystemObject) {
								tmpHochbauSchrankSchachtTyp = (SystemObject)soHochbauSchrankSchachtTyp;
							} else if(soHochbauSchrankSchachtTyp instanceof SystemObjekt){
								tmpHochbauSchrankSchachtTyp = ((SystemObjekt)soHochbauSchrankSchachtTyp).getSystemObject();
							} else{
								tmpHochbauSchrankSchachtTyp = null;
							}
						datum.getReferenceValue("HochbauSchrankSchachtTyp").setSystemObject(tmpHochbauSchrankSchachtTyp);
					// ZeichenkettenAttributTyp
					if (getDokumentation() != null) {
						final Data.TextArray arrayDokumentation = datum.getTextArray("Dokumentation");
						arrayDokumentation.setLength(getDokumentation().size());
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							arrayDokumentation.getTextValue(i).setText(getDokumentation().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBilder() != null) {
						final Data.TextArray arrayBilder = datum.getTextArray("Bilder");
						arrayBilder.setLength(getBilder().size());
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							arrayBilder.getTextValue(i).setText(getBilder().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getLageplan() != null) {
						final Data.TextArray arrayLageplan = datum.getTextArray("Lageplan");
						arrayLageplan.setLength(getLageplan().size());
						for (int i = 0; i < arrayLageplan.getLength(); ++i) {
							arrayLageplan.getTextValue(i).setText(getLageplan().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
					// ObjektReferenzAttributTyp
						final Object soStandort = getStandort();
						final SystemObject tmpStandort;
							if (soStandort instanceof SystemObject) {
								tmpStandort = (SystemObject)soStandort;
							} else if(soStandort instanceof SystemObjekt){
								tmpStandort = ((SystemObjekt)soStandort).getSystemObject();
							} else{
								tmpStandort = null;
							}
						datum.getReferenceValue("Standort").setSystemObject(tmpStandort);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayEinbauOrte = datum.getReferenceArray("EinbauOrte");
						arrayEinbauOrte.setLength(getEinbauOrte().size());
						for (int i = 0; i < arrayEinbauOrte.getLength(); ++i) {
							final Object soEinbauOrte = getEinbauOrte().get(i);
							final SystemObject tmpEinbauOrte;
							if (soEinbauOrte instanceof SystemObject) {
								tmpEinbauOrte = (SystemObject)soEinbauOrte;
							} else if(soEinbauOrte instanceof SystemObjekt){
								tmpEinbauOrte = ((SystemObjekt)soEinbauOrte).getSystemObject();
							} else{
								tmpEinbauOrte = null;
							}
							arrayEinbauOrte.getReferenceValue(i).setSystemObject(tmpEinbauOrte);
						}
					// GanzzahlAttributTyp
					if (getHoeheUeberNN() != null) {
		                if (getHoeheUeberNN().isZustand()) {
		                    datum.getUnscaledValue("HoeheUeberNN").setText(getHoeheUeberNN().toString());
		                } else {
							datum.
							getScaledValue
		                	("HoeheUeberNN").set(getHoeheUeberNN().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbstandStrasse() != null) {
		                if (getAbstandStrasse().isZustand()) {
		                    datum.getUnscaledValue("AbstandStrasse").setText(getAbstandStrasse().toString());
		                } else {
							datum.
							getScaledValue
		                	("AbstandStrasse").set(getAbstandStrasse().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soReferenzZuPunktLiegtAufLinienObjekt = getReferenzZuPunktLiegtAufLinienObjekt();
						final SystemObject tmpReferenzZuPunktLiegtAufLinienObjekt;
							if (soReferenzZuPunktLiegtAufLinienObjekt instanceof SystemObject) {
								tmpReferenzZuPunktLiegtAufLinienObjekt = (SystemObject)soReferenzZuPunktLiegtAufLinienObjekt;
							} else if(soReferenzZuPunktLiegtAufLinienObjekt instanceof SystemObjekt){
								tmpReferenzZuPunktLiegtAufLinienObjekt = ((SystemObjekt)soReferenzZuPunktLiegtAufLinienObjekt).getSystemObject();
							} else{
								tmpReferenzZuPunktLiegtAufLinienObjekt = null;
							}
						datum.getReferenceValue("ReferenzZuPunktLiegtAufLinienObjekt").setSystemObject(tmpReferenzZuPunktLiegtAufLinienObjekt);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idHochbauSchrankSchachtTyp = daten.getReferenceValue("HochbauSchrankSchachtTyp").getId();
						final SystemObjekt tmpHochbauSchrankSchachtTyp;
						if (idHochbauSchrankSchachtTyp == 0) {
							tmpHochbauSchrankSchachtTyp = null;
						} else {
							final SystemObject soHochbauSchrankSchachtTyp = factory.getDav().getDataModel().getObject(idHochbauSchrankSchachtTyp);
							if (soHochbauSchrankSchachtTyp == null) {
									tmpHochbauSchrankSchachtTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.HochbauSchrankSchachtTypUngueltig(idHochbauSchrankSchachtTyp);
							} else {
								tmpHochbauSchrankSchachtTyp = factory.getModellobjekt(soHochbauSchrankSchachtTyp);
							}
						}
						setHochbauSchrankSchachtTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchachtTyp
						) tmpHochbauSchrankSchachtTyp);
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDokumentation = daten.getTextArray("Dokumentation");
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							getDokumentation().add(arrayDokumentation.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayBilder = daten.getTextArray("Bilder");
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							getBilder().add(arrayBilder.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayLageplan = daten.getTextArray("Lageplan");
						for (int i = 0; i < arrayLageplan.getLength(); ++i) {
							getLageplan().add(arrayLageplan.getText(i));
						}
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
					// ObjektReferenzAttributTyp
						final long idStandort = daten.getReferenceValue("Standort").getId();
						final SystemObjekt tmpStandort;
						if (idStandort == 0) {
							tmpStandort = null;
						} else {
							final SystemObject soStandort = factory.getDav().getDataModel().getObject(idStandort);
							if (soStandort == null) {
									tmpStandort = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.impl.PunktUngueltig(idStandort);
							} else {
								tmpStandort = factory.getModellobjekt(soStandort);
							}
						}
						setStandort((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
						) tmpStandort);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayEinbauOrte = daten.getReferenceArray("EinbauOrte");
						for (int i = 0; i < arrayEinbauOrte.getLength(); ++i) {
							final long idEinbauOrte = daten.getReferenceArray("EinbauOrte").getReferenceValue(i).getId();
							final SystemObjekt tmpEinbauOrte;
							if (idEinbauOrte == 0) {
								tmpEinbauOrte = null;
							} else {
								final SystemObject soEinbauOrte = factory.getDav().getDataModel().getObject(idEinbauOrte);
								if (soEinbauOrte == null) {
										tmpEinbauOrte = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtUngueltig(idEinbauOrte);
								} else {
									tmpEinbauOrte = factory.getModellobjekt(soEinbauOrte);
								}
							}
								getEinbauOrte().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrt
								) tmpEinbauOrte);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("HoeheUeberNN").isState()) {
								setHoeheUeberNN(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("HoeheUeberNN").getText()));
							} else {
							setHoeheUeberNN(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("HoeheUeberNN").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AbstandStrasse").isState()) {
								setAbstandStrasse(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("AbstandStrasse").getText()));
							} else {
							setAbstandStrasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("AbstandStrasse").
								doubleValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idReferenzZuPunktLiegtAufLinienObjekt = daten.getReferenceValue("ReferenzZuPunktLiegtAufLinienObjekt").getId();
						final SystemObjekt tmpReferenzZuPunktLiegtAufLinienObjekt;
						if (idReferenzZuPunktLiegtAufLinienObjekt == 0) {
							tmpReferenzZuPunktLiegtAufLinienObjekt = null;
						} else {
							final SystemObject soReferenzZuPunktLiegtAufLinienObjekt = factory.getDav().getDataModel().getObject(idReferenzZuPunktLiegtAufLinienObjekt);
							if (soReferenzZuPunktLiegtAufLinienObjekt == null) {
									tmpReferenzZuPunktLiegtAufLinienObjekt = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.impl.PunktLiegtAufLinienObjektUngueltig(idReferenzZuPunktLiegtAufLinienObjekt);
							} else {
								tmpReferenzZuPunktLiegtAufLinienObjekt = factory.getModellobjekt(soReferenzZuPunktLiegtAufLinienObjekt);
							}
						}
						setReferenzZuPunktLiegtAufLinienObjekt((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
						) tmpReferenzZuPunktLiegtAufLinienObjekt);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHochbauSchrankSchachtTyp(getHochbauSchrankSchachtTyp());
						klon._dokumentation = getDokumentation().clone();
						klon._bilder = getBilder().clone();
						klon._lageplan = getLageplan().clone();
							klon.setBezeichnung(getBezeichnung());
							klon.setStandort(getStandort());
						klon._einbauOrte = getEinbauOrte().clone();
							klon.setHoeheUeberNN(getHoeheUeberNN());
							klon.setAbstandStrasse(getAbstandStrasse());
							klon.setReferenzZuPunktLiegtAufLinienObjekt(getReferenzZuPunktLiegtAufLinienObjekt());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.hochbauSchrankSchacht";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdHochbauSchrankSchacht(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
