/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines abstrakten Typs von Hochbau, Schrank, Schacht ....
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdHochbauSchrankSchachtTyp extends AbstractKonfigurationsDatensatz<KdHochbauSchrankSchachtTyp.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				> _hersteller = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				>(0, true);
				private Feld<String
				> _dokumentation = new Feld<String
				>(0, true);
				private Feld<String
				> _bilder = new Feld<String
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
				 _dichtigkeit
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> _hatEinbauOrtTypen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				>(0, true);
				private String
				 _bezeichnung
				= new String
				()
				;
		
			/**
			Referenz auf den &#47; die Herstellers dieses Hochbaus &#47; Schranks Schachttyps; leer wenn nicht sinnvoll angebbar.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				> getHersteller() {
				return _hersteller;
			}
		
		
			/**
			Dokumentation zum abstrakten Hochbau &#47; Schrank &#47; Schachttyp, z.B. Handbücher...
			<p>
			
			</p>
			
			@return der Wert von Dokumentation.
			*/
				public Feld<String
				> getDokumentation() {
				return _dokumentation;
			}
		
		
			/**
			Bilder zum abstrakten Hochbau &#47; Schrank &#47; Schachttyp.
			<p>
			
			</p>
			
			@return der Wert von Bilder.
			*/
				public Feld<String
				> getBilder() {
				return _bilder;
			}
		
		
			/**
			Dichtigkeit des Hochbaus &#47; Schranks &#47; Schachttyps.
			<p>
			
			</p>
			
			@return der Wert von Dichtigkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
				 getDichtigkeit() {
				return _dichtigkeit;
			}
		
			/**
			Dichtigkeit des Hochbaus &#47; Schranks &#47; Schachttyps.
			<p>
			
			</p>
			
			@param _dichtigkeit der neue Wert von Dichtigkeit.
			*/
			public void setDichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
			 _dichtigkeit) {
				this._dichtigkeit = _dichtigkeit;
			}
		
			/**
			Auflistung aller Einbauorttypen, welches dieser Hochbau &#47; Schrank &#47; Schachttyp bereitstellt. Werden mehrere gleiche bereitgestellt, so sind mehrfach die gleichen Referenzen einzutragen.
			<p>
			
			</p>
			
			@return der Wert von HatEinbauOrtTypen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> getHatEinbauOrtTypen() {
				return _hatEinbauOrtTypen;
			}
		
		
			/**
			Bezeichnung dieses Hochbau &#47;Schrank &#47; Schachttyps.
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Bezeichnung dieses Hochbau &#47;Schrank &#47; Schachttyps.
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHersteller = datum.getReferenceArray("Hersteller");
						arrayHersteller.setLength(getHersteller().size());
						for (int i = 0; i < arrayHersteller.getLength(); ++i) {
							final Object soHersteller = getHersteller().get(i);
							final SystemObject tmpHersteller;
							if (soHersteller instanceof SystemObject) {
								tmpHersteller = (SystemObject)soHersteller;
							} else if(soHersteller instanceof SystemObjekt){
								tmpHersteller = ((SystemObjekt)soHersteller).getSystemObject();
							} else{
								tmpHersteller = null;
							}
							arrayHersteller.getReferenceValue(i).setSystemObject(tmpHersteller);
						}
					// ZeichenkettenAttributTyp
					if (getDokumentation() != null) {
						final Data.TextArray arrayDokumentation = datum.getTextArray("Dokumentation");
						arrayDokumentation.setLength(getDokumentation().size());
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							arrayDokumentation.getTextValue(i).setText(getDokumentation().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBilder() != null) {
						final Data.TextArray arrayBilder = datum.getTextArray("Bilder");
						arrayBilder.setLength(getBilder().size());
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							arrayBilder.getTextValue(i).setText(getBilder().get(i));
						}
					}
					// GanzzahlAttributTyp
					if (getDichtigkeit() != null) {
		                if (getDichtigkeit().isZustand()) {
		                    datum.getUnscaledValue("Dichtigkeit").setText(getDichtigkeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Dichtigkeit").set(getDichtigkeit().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHatEinbauOrtTypen = datum.getReferenceArray("HatEinbauOrtTypen");
						arrayHatEinbauOrtTypen.setLength(getHatEinbauOrtTypen().size());
						for (int i = 0; i < arrayHatEinbauOrtTypen.getLength(); ++i) {
							final Object soHatEinbauOrtTypen = getHatEinbauOrtTypen().get(i);
							final SystemObject tmpHatEinbauOrtTypen;
							if (soHatEinbauOrtTypen instanceof SystemObject) {
								tmpHatEinbauOrtTypen = (SystemObject)soHatEinbauOrtTypen;
							} else if(soHatEinbauOrtTypen instanceof SystemObjekt){
								tmpHatEinbauOrtTypen = ((SystemObjekt)soHatEinbauOrtTypen).getSystemObject();
							} else{
								tmpHatEinbauOrtTypen = null;
							}
							arrayHatEinbauOrtTypen.getReferenceValue(i).setSystemObject(tmpHatEinbauOrtTypen);
						}
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHersteller = daten.getReferenceArray("Hersteller");
						for (int i = 0; i < arrayHersteller.getLength(); ++i) {
							final long idHersteller = daten.getReferenceArray("Hersteller").getReferenceValue(i).getId();
							final SystemObjekt tmpHersteller;
							if (idHersteller == 0) {
								tmpHersteller = null;
							} else {
								final SystemObject soHersteller = factory.getDav().getDataModel().getObject(idHersteller);
								if (soHersteller == null) {
										tmpHersteller = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.HerstellerUngueltig(idHersteller);
								} else {
									tmpHersteller = factory.getModellobjekt(soHersteller);
								}
							}
								getHersteller().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
								) tmpHersteller);
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDokumentation = daten.getTextArray("Dokumentation");
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							getDokumentation().add(arrayDokumentation.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayBilder = daten.getTextArray("Bilder");
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							getBilder().add(arrayBilder.getText(i));
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Dichtigkeit").isState()) {
								setDichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
								.getZustand(daten.getScaledValue("Dichtigkeit").getText()));
							} else {
							setDichtigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
							(daten.
								getUnscaledValue
							("Dichtigkeit").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHatEinbauOrtTypen = daten.getReferenceArray("HatEinbauOrtTypen");
						for (int i = 0; i < arrayHatEinbauOrtTypen.getLength(); ++i) {
							final long idHatEinbauOrtTypen = daten.getReferenceArray("HatEinbauOrtTypen").getReferenceValue(i).getId();
							final SystemObjekt tmpHatEinbauOrtTypen;
							if (idHatEinbauOrtTypen == 0) {
								tmpHatEinbauOrtTypen = null;
							} else {
								final SystemObject soHatEinbauOrtTypen = factory.getDav().getDataModel().getObject(idHatEinbauOrtTypen);
								if (soHatEinbauOrtTypen == null) {
										tmpHatEinbauOrtTypen = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtTypUngueltig(idHatEinbauOrtTypen);
								} else {
									tmpHatEinbauOrtTypen = factory.getModellobjekt(soHatEinbauOrtTypen);
								}
							}
								getHatEinbauOrtTypen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
								) tmpHatEinbauOrtTypen);
						}
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._hersteller = getHersteller().clone();
						klon._dokumentation = getDokumentation().clone();
						klon._bilder = getBilder().clone();
							klon.setDichtigkeit(getDichtigkeit());
						klon._hatEinbauOrtTypen = getHatEinbauOrtTypen().clone();
							klon.setBezeichnung(getBezeichnung());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.hochbauSchrankSchachtTyp";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdHochbauSchrankSchachtTyp(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
