/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines Lieferanten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdLieferant extends AbstractKonfigurationsDatensatz<KdLieferant.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.AdressDatum
				> _adresse = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.AdressDatum
				>(1, true);
		
			/**
			Der Name des Lieferanten (ggf. mit Abteilungsbezeichnung etc...).
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Der Name des Lieferanten (ggf. mit Abteilungsbezeichnung etc...).
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Die Adresse(n) des Lieferanten.
			<p>
			
			</p>
			
			@return der Wert von Adresse.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.AdressDatum
				> getAdresse() {
				return _adresse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAdresse = datum.getReferenceArray("Adresse");
						arrayAdresse.setLength(getAdresse().size());
						for (int i = 0; i < arrayAdresse.getLength(); ++i) {
							final Object soAdresse = getAdresse().get(i);
							final SystemObject tmpAdresse;
							if (soAdresse instanceof SystemObject) {
								tmpAdresse = (SystemObject)soAdresse;
							} else if(soAdresse instanceof SystemObjekt){
								tmpAdresse = ((SystemObjekt)soAdresse).getSystemObject();
							} else{
								tmpAdresse = null;
							}
							arrayAdresse.getReferenceValue(i).setSystemObject(tmpAdresse);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAdresse = daten.getReferenceArray("Adresse");
						for (int i = 0; i < arrayAdresse.getLength(); ++i) {
							final long idAdresse = daten.getReferenceArray("Adresse").getReferenceValue(i).getId();
							final SystemObjekt tmpAdresse;
							if (idAdresse == 0) {
								tmpAdresse = null;
							} else {
								final SystemObject soAdresse = factory.getDav().getDataModel().getObject(idAdresse);
								if (soAdresse == null) {
										tmpAdresse = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.AdressDatumUngueltig(idAdresse);
								} else {
									tmpAdresse = factory.getModellobjekt(soAdresse);
								}
							}
								getAdresse().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.AdressDatum
								) tmpAdresse);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
						klon._adresse = getAdresse().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.lieferant";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdLieferant(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
