/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Übertragungsgeschwindigkeit eines Datenkanals in bit pro Sekunde.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 50L,
	maximum = 2147483647L,
	einheit = "bps"
)
public class AttUebertragungsgeschwindigkeit extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("50");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("2147483647");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "bps";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_1200__1200 = new AttUebertragungsgeschwindigkeit("1200", 		Integer
	.valueOf("1200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_2400__2400 = new AttUebertragungsgeschwindigkeit("2400", 		Integer
	.valueOf("2400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_4800__4800 = new AttUebertragungsgeschwindigkeit("4800", 		Integer
	.valueOf("4800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_7200__7200 = new AttUebertragungsgeschwindigkeit("7200", 		Integer
	.valueOf("7200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_9600__9600 = new AttUebertragungsgeschwindigkeit("9600", 		Integer
	.valueOf("9600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_12000__12000 = new AttUebertragungsgeschwindigkeit("12000", 		Integer
	.valueOf("12000"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_14400__14400 = new AttUebertragungsgeschwindigkeit("14400", 		Integer
	.valueOf("14400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_16800__16800 = new AttUebertragungsgeschwindigkeit("16800", 		Integer
	.valueOf("16800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_19200__19200 = new AttUebertragungsgeschwindigkeit("19200", 		Integer
	.valueOf("19200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_21600__21600 = new AttUebertragungsgeschwindigkeit("21600", 		Integer
	.valueOf("21600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_24000__24000 = new AttUebertragungsgeschwindigkeit("24000", 		Integer
	.valueOf("24000"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_26400__26400 = new AttUebertragungsgeschwindigkeit("26400", 		Integer
	.valueOf("26400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUebertragungsgeschwindigkeit ZUSTAND_28800__28800 = new AttUebertragungsgeschwindigkeit("28800", 		Integer
	.valueOf("28800"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUebertragungsgeschwindigkeit getZustand(final 		Integer
	 value) {
		for (AttUebertragungsgeschwindigkeit e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUebertragungsgeschwindigkeit getZustand(final String value) {
		for (AttUebertragungsgeschwindigkeit e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUebertragungsgeschwindigkeit> getZustaende() {
		List<AttUebertragungsgeschwindigkeit> list = new ArrayList<AttUebertragungsgeschwindigkeit>();
		list.add(ZUSTAND_1200__1200);
		list.add(ZUSTAND_2400__2400);
		list.add(ZUSTAND_4800__4800);
		list.add(ZUSTAND_7200__7200);
		list.add(ZUSTAND_9600__9600);
		list.add(ZUSTAND_12000__12000);
		list.add(ZUSTAND_14400__14400);
		list.add(ZUSTAND_16800__16800);
		list.add(ZUSTAND_19200__19200);
		list.add(ZUSTAND_21600__21600);
		list.add(ZUSTAND_24000__24000);
		list.add(ZUSTAND_26400__26400);
		list.add(ZUSTAND_28800__28800);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Übertragungsgeschwindigkeit.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUebertragungsgeschwindigkeit(final 		Integer
	 value) {
		super(value);
	}
	
	private AttUebertragungsgeschwindigkeit(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
