/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zum Mitschneiden von OSI 2 Protokollen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdOsi2Mitschnitt extends AbstractOnlineDatensatz<OdOsi2Mitschnitt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.IlseTelegrammEmpfangen,
				};
			}
	
			/**
			 * Telegramm wurde empfangen.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt IlseTelegrammEmpfangen = new Aspekte("Empfangen", "asp.ilse.telegramm.empfangen");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
				 _richtung
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _oSI2Telegramm = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Attribut welches die Kommunikationsrichtung angibt.
			<p>
			
			</p>
			
			@return der Wert von Richtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
				 getRichtung() {
				return _richtung;
			}
		
			/**
			Attribut welches die Kommunikationsrichtung angibt.
			<p>
			
			</p>
			
			@param _richtung der neue Wert von Richtung.
			*/
			public void setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
			 _richtung) {
				this._richtung = _richtung;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -128 bis 127.
			<p>
			
			</p>
			
			@return der Wert von OSI2Telegramm.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getOSI2Telegramm() {
				return _oSI2Telegramm;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getRichtung() != null) {
		                if (getRichtung().isZustand()) {
		                    datum.getUnscaledValue("Richtung").setText(getRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Richtung").set(getRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOSI2Telegramm() != null) {
						final Data.NumberArray arrayOSI2Telegramm = datum.
							getUnscaledArray
							("OSI2Telegramm");
						arrayOSI2Telegramm.setLength(getOSI2Telegramm().size());
						for (int i = 0; i < arrayOSI2Telegramm.getLength(); ++i) {
							arrayOSI2Telegramm.getValue(i).set(getOSI2Telegramm().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Richtung").isState()) {
								setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
								.getZustand(daten.getScaledValue("Richtung").getText()));
							} else {
							setRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
							(daten.
								getUnscaledValue
							("Richtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayOSI2Telegramm = daten.
							getUnscaledArray
						("OSI2Telegramm");
		
						for (int i = 0; i < arrayOSI2Telegramm.getLength(); ++i) {
		                    getOSI2Telegramm().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayOSI2Telegramm.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setRichtung(getRichtung());
						klon._oSI2Telegramm = getOSI2Telegramm().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.osi2Mitschnitt";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdOsi2Mitschnitt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
