/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zum Mitschneiden von OSI 3 und 7 Protokollen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdOsi37Mitschnitt extends AbstractOnlineDatensatz<OdOsi37Mitschnitt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.IlseTelegrammEmpfangen,
				};
			}
	
			/**
			 * Telegramm wurde empfangen.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt IlseTelegrammEmpfangen = new Aspekte("Empfangen", "asp.ilse.telegramm.empfangen");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
				 _richtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _oSI2Adresse
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
				 _absender
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
				 _empfaenger
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _oSI3Header = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _oSI7Telegramm = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Attribut welches die Kommunikationsrichtung angibt.
			<p>
			
			</p>
			
			@return der Wert von Richtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
				 getRichtung() {
				return _richtung;
			}
		
			/**
			Attribut welches die Kommunikationsrichtung angibt.
			<p>
			
			</p>
			
			@param _richtung der neue Wert von Richtung.
			*/
			public void setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
			 _richtung) {
				this._richtung = _richtung;
			}
		
			/**
			TLS-Byte (0-255).
			<p>
			
			</p>
			
			@return der Wert von OSI2Adresse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getOSI2Adresse() {
				return _oSI2Adresse;
			}
		
			/**
			TLS-Byte (0-255).
			<p>
			
			</p>
			
			@param _oSI2Adresse der neue Wert von OSI2Adresse.
			*/
			public void setOSI2Adresse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _oSI2Adresse) {
				this._oSI2Adresse = _oSI2Adresse;
			}
		
			/**
			Komunikationsstatus zwischen SM und UZ.
			<p>
			
			</p>
			
			@return der Wert von Absender.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
				 getAbsender() {
				return _absender;
			}
		
			/**
			Komunikationsstatus zwischen SM und UZ.
			<p>
			
			</p>
			
			@param _absender der neue Wert von Absender.
			*/
			public void setAbsender(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
			 _absender) {
				this._absender = _absender;
			}
		
			/**
			Komunikationsstatus zwischen SM und UZ.
			<p>
			
			</p>
			
			@return der Wert von Empfaenger.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
				 getEmpfaenger() {
				return _empfaenger;
			}
		
			/**
			Komunikationsstatus zwischen SM und UZ.
			<p>
			
			</p>
			
			@param _empfaenger der neue Wert von Empfaenger.
			*/
			public void setEmpfaenger(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
			 _empfaenger) {
				this._empfaenger = _empfaenger;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -128 bis 127.
			<p>
			
			</p>
			
			@return der Wert von OSI3Header.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getOSI3Header() {
				return _oSI3Header;
			}
		
		
			/**
			Beliebige ganze Zahl im Bereich -128 bis 127.
			<p>
			
			</p>
			
			@return der Wert von OSI7Telegramm.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getOSI7Telegramm() {
				return _oSI7Telegramm;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getRichtung() != null) {
		                if (getRichtung().isZustand()) {
		                    datum.getUnscaledValue("Richtung").setText(getRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Richtung").set(getRichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOSI2Adresse() != null) {
		                if (getOSI2Adresse().isZustand()) {
		                    datum.getUnscaledValue("OSI2Adresse").setText(getOSI2Adresse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("OSI2Adresse").set(getOSI2Adresse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbsender() != null) {
		                if (getAbsender().isZustand()) {
		                    datum.getUnscaledValue("Absender").setText(getAbsender().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Absender").set(getAbsender().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEmpfaenger() != null) {
		                if (getEmpfaenger().isZustand()) {
		                    datum.getUnscaledValue("Empfänger").setText(getEmpfaenger().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Empfänger").set(getEmpfaenger().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOSI3Header() != null) {
						final Data.NumberArray arrayOSI3Header = datum.
							getUnscaledArray
							("OSI3Header");
						arrayOSI3Header.setLength(getOSI3Header().size());
						for (int i = 0; i < arrayOSI3Header.getLength(); ++i) {
							arrayOSI3Header.getValue(i).set(getOSI3Header().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getOSI7Telegramm() != null) {
						final Data.NumberArray arrayOSI7Telegramm = datum.
							getUnscaledArray
							("OSI7Telegramm");
						arrayOSI7Telegramm.setLength(getOSI7Telegramm().size());
						for (int i = 0; i < arrayOSI7Telegramm.getLength(); ++i) {
							arrayOSI7Telegramm.getValue(i).set(getOSI7Telegramm().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Richtung").isState()) {
								setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
								.getZustand(daten.getScaledValue("Richtung").getText()));
							} else {
							setRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.attribute.AttKommunikationsRichtung
							(daten.
								getUnscaledValue
							("Richtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setOSI2Adresse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("OSI2Adresse").
									shortValue
							()));
					// GanzzahlAttributTyp
							setAbsender(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
							(daten.
								getUnscaledValue
							("Absender").
									intValue
							()));
					// GanzzahlAttributTyp
							setEmpfaenger(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
							(daten.
								getUnscaledValue
							("Empfänger").
									intValue
							()));
					// GanzzahlAttributTyp
						final Data.NumberArray arrayOSI3Header = daten.
							getUnscaledArray
						("OSI3Header");
		
						for (int i = 0; i < arrayOSI3Header.getLength(); ++i) {
		                    getOSI3Header().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayOSI3Header.
		                    		byteValue
		                    (i)));
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayOSI7Telegramm = daten.
							getUnscaledArray
						("OSI7Telegramm");
		
						for (int i = 0; i < arrayOSI7Telegramm.getLength(); ++i) {
		                    getOSI7Telegramm().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayOSI7Telegramm.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setRichtung(getRichtung());
							klon.setOSI2Adresse(getOSI2Adresse());
							klon.setAbsender(getAbsender());
							klon.setEmpfaenger(getEmpfaenger());
						klon._oSI3Header = getOSI3Header().clone();
						klon._oSI7Telegramm = getOSI7Telegramm().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.osi37Mitschnitt";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdOsi37Mitschnitt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
