/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmisis.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz für die Funktionsbibliothek ISIS.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class PdParameterIsis extends AbstractParameterDatensatz<PdParameterIsis.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ereignisBeiEntworfen
				;
				@Defaultwert(wert = "Ja")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ereignisBeiGeplant
				;
				@Defaultwert(wert = "Ja")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ereignisBeiGueltig
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ereignisBeiStorniert
				;
				@Defaultwert(wert = "3 Tage")
				private 	RelativerZeitstempel
				 _warnZeitraum
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'entworfen' hat (BIS-ISIS: Grobplanung).
			<p>
			
			</p>
			
			@return der Wert von EreignisBeiEntworfen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEreignisBeiEntworfen() {
				return _ereignisBeiEntworfen;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'entworfen' hat (BIS-ISIS: Grobplanung).
			<p>
			
			</p>
			
			@param _ereignisBeiEntworfen der neue Wert von EreignisBeiEntworfen.
			*/
			public void setEreignisBeiEntworfen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisBeiEntworfen) {
				this._ereignisBeiEntworfen = _ereignisBeiEntworfen;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'geplant' hat (BIS-ISIS: Feinplanung).
			<p>
			
			</p>
			
			@return der Wert von EreignisBeiGeplant.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEreignisBeiGeplant() {
				return _ereignisBeiGeplant;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'geplant' hat (BIS-ISIS: Feinplanung).
			<p>
			
			</p>
			
			@param _ereignisBeiGeplant der neue Wert von EreignisBeiGeplant.
			*/
			public void setEreignisBeiGeplant(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisBeiGeplant) {
				this._ereignisBeiGeplant = _ereignisBeiGeplant;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'gültig' hat (BIS-ISIS: Umsetzung).
			<p>
			
			</p>
			
			@return der Wert von EreignisBeiGueltig.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEreignisBeiGueltig() {
				return _ereignisBeiGueltig;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'gültig' hat (BIS-ISIS: Umsetzung).
			<p>
			
			</p>
			
			@param _ereignisBeiGueltig der neue Wert von EreignisBeiGueltig.
			*/
			public void setEreignisBeiGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisBeiGueltig) {
				this._ereignisBeiGueltig = _ereignisBeiGueltig;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'storniert' hat (BIS-ISIS: Gelöscht).
			<p>
			
			</p>
			
			@return der Wert von EreignisBeiStorniert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEreignisBeiStorniert() {
				return _ereignisBeiStorniert;
			}
		
			/**
			Erzeugt ein Ereignis für die Baustelle, wenn diese den Status 'storniert' hat (BIS-ISIS: Gelöscht).
			<p>
			
			</p>
			
			@param _ereignisBeiStorniert der neue Wert von EreignisBeiStorniert.
			*/
			public void setEreignisBeiStorniert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisBeiStorniert) {
				this._ereignisBeiStorniert = _ereignisBeiStorniert;
			}
		
			/**
			Zeitdauer in Tagen, bei dem Änderungen des Baustellenzustandes auf dem VRZ-System durch Zustandsänderungen beim BIS-ISIS System quittiert werden müssen, wenn die Baustelle aus Sicht des VRZ-Systems in nächsten n-Arbeitstagen (WarnZeitraum) gültig ist, wird oder war.
			<p>
			
			</p>
			
			@return der Wert von WarnZeitraum.
			*/
				public 	RelativerZeitstempel
				 getWarnZeitraum() {
				return _warnZeitraum;
			}
		
			/**
			Zeitdauer in Tagen, bei dem Änderungen des Baustellenzustandes auf dem VRZ-System durch Zustandsänderungen beim BIS-ISIS System quittiert werden müssen, wenn die Baustelle aus Sicht des VRZ-Systems in nächsten n-Arbeitstagen (WarnZeitraum) gültig ist, wird oder war.
			<p>
			
			</p>
			
			@param _warnZeitraum der neue Wert von WarnZeitraum.
			*/
			public void setWarnZeitraum(	RelativerZeitstempel
			 _warnZeitraum) {
				this._warnZeitraum = _warnZeitraum;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getEreignisBeiEntworfen() != null) {
		                if (getEreignisBeiEntworfen().isZustand()) {
		                    datum.getUnscaledValue("EreignisBeiEntworfen").setText(getEreignisBeiEntworfen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisBeiEntworfen").set(getEreignisBeiEntworfen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEreignisBeiGeplant() != null) {
		                if (getEreignisBeiGeplant().isZustand()) {
		                    datum.getUnscaledValue("EreignisBeiGeplant").setText(getEreignisBeiGeplant().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisBeiGeplant").set(getEreignisBeiGeplant().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEreignisBeiGueltig() != null) {
		                if (getEreignisBeiGueltig().isZustand()) {
		                    datum.getUnscaledValue("EreignisBeiGültig").setText(getEreignisBeiGueltig().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisBeiGültig").set(getEreignisBeiGueltig().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEreignisBeiStorniert() != null) {
		                if (getEreignisBeiStorniert().isZustand()) {
		                    datum.getUnscaledValue("EreignisBeiStorniert").setText(getEreignisBeiStorniert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisBeiStorniert").set(getEreignisBeiStorniert().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("WarnZeitraum").setMillis(getWarnZeitraum().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisBeiEntworfen").isState()) {
								setEreignisBeiEntworfen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EreignisBeiEntworfen").getText()));
							} else {
							setEreignisBeiEntworfen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EreignisBeiEntworfen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisBeiGeplant").isState()) {
								setEreignisBeiGeplant(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EreignisBeiGeplant").getText()));
							} else {
							setEreignisBeiGeplant(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EreignisBeiGeplant").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisBeiGültig").isState()) {
								setEreignisBeiGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EreignisBeiGültig").getText()));
							} else {
							setEreignisBeiGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EreignisBeiGültig").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisBeiStorniert").isState()) {
								setEreignisBeiStorniert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EreignisBeiStorniert").getText()));
							} else {
							setEreignisBeiStorniert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EreignisBeiStorniert").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setWarnZeitraum(new
							RelativerZeitstempel
							(daten.getTimeValue("WarnZeitraum").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setEreignisBeiEntworfen(getEreignisBeiEntworfen());
							klon.setEreignisBeiGeplant(getEreignisBeiGeplant());
							klon.setEreignisBeiGueltig(getEreignisBeiGueltig());
							klon.setEreignisBeiStorniert(getEreignisBeiStorniert());
							klon.setWarnZeitraum(getWarnZeitraum());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterIsis";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterIsis(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
