/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ID der Meldung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlMeldungsID implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _applikationsID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _laufendeNummer
			;
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von ApplikationsID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getApplikationsID() {
			return _applikationsID;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _applikationsID der neue Wert von ApplikationsID.
		*/
		public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _applikationsID) {
			this._applikationsID = _applikationsID;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von LaufendeNummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getLaufendeNummer() {
			return _laufendeNummer;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _laufendeNummer der neue Wert von LaufendeNummer.
		*/
		public void setLaufendeNummer(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _laufendeNummer) {
			this._laufendeNummer = _laufendeNummer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getApplikationsID() != null) {
	                if (getApplikationsID().isZustand()) {
	                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ApplikationsID").set(getApplikationsID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLaufendeNummer() != null) {
	                if (getLaufendeNummer().isZustand()) {
	                    datum.getUnscaledValue("LaufendeNummer").setText(getLaufendeNummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LaufendeNummer").set(getLaufendeNummer().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("ApplikationsID").
								longValue
						()));
				// GanzzahlAttributTyp
						setLaufendeNummer(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("LaufendeNummer").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMeldungsID clone() {
		AtlMeldungsID klon = new AtlMeldungsID();
		
						klon.setApplikationsID(getApplikationsID());
						klon.setLaufendeNummer(getLaufendeNummer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
