/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Baudraten-Definitionen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttBaud extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_300_BAUD300 = new AttBaud("Baud300", 		Integer
	.valueOf("300"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_600_BAUD600 = new AttBaud("Baud600", 		Integer
	.valueOf("600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_1200_BAUD1200 = new AttBaud("Baud1200", 		Integer
	.valueOf("1200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_2400_BAUD2400 = new AttBaud("Baud2400", 		Integer
	.valueOf("2400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_4800_BAUD4800 = new AttBaud("Baud4800", 		Integer
	.valueOf("4800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_9600_BAUD9600 = new AttBaud("Baud9600", 		Integer
	.valueOf("9600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_19200_BAUD19200 = new AttBaud("Baud19200", 		Integer
	.valueOf("19200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_38400_BAUD38400 = new AttBaud("Baud38400", 		Integer
	.valueOf("38400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_57600_BAUD57600 = new AttBaud("Baud57600", 		Integer
	.valueOf("57600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBaud ZUSTAND_115200_BAUD115200 = new AttBaud("Baud115200", 		Integer
	.valueOf("115200"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBaud getZustand(final 		Integer
	 value) {
		for (AttBaud e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBaud getZustand(final String value) {
		for (AttBaud e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBaud> getZustaende() {
		List<AttBaud> list = new ArrayList<AttBaud>();
		list.add(ZUSTAND_300_BAUD300);
		list.add(ZUSTAND_600_BAUD600);
		list.add(ZUSTAND_1200_BAUD1200);
		list.add(ZUSTAND_2400_BAUD2400);
		list.add(ZUSTAND_4800_BAUD4800);
		list.add(ZUSTAND_9600_BAUD9600);
		list.add(ZUSTAND_19200_BAUD19200);
		list.add(ZUSTAND_38400_BAUD38400);
		list.add(ZUSTAND_57600_BAUD57600);
		list.add(ZUSTAND_115200_BAUD115200);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBaud(final 		Integer
	 value) {
		super(value);
	}
	
	private AttBaud(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
