/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste von Prioritäten in Abhängigkeit der Güte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AtlGuetePrioritaetenListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete1bis10
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete11bis20
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete21bis30
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete31bis40
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete41bis50
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete51bis60
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete61bis70
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete71bis80
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete81bis90
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 _guete91bis100
			;
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 10.
		<p>
		
		</p>
		
		@return der Wert von Guete1bis10.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete1bis10() {
			return _guete1bis10;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 10.
		<p>
		
		</p>
		
		@param _guete1bis10 der neue Wert von Guete1bis10.
		*/
		public void setGuete1bis10(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete1bis10) {
			this._guete1bis10 = _guete1bis10;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 20.
		<p>
		
		</p>
		
		@return der Wert von Guete11bis20.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete11bis20() {
			return _guete11bis20;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 20.
		<p>
		
		</p>
		
		@param _guete11bis20 der neue Wert von Guete11bis20.
		*/
		public void setGuete11bis20(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete11bis20) {
			this._guete11bis20 = _guete11bis20;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 30.
		<p>
		
		</p>
		
		@return der Wert von Guete21bis30.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete21bis30() {
			return _guete21bis30;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 30.
		<p>
		
		</p>
		
		@param _guete21bis30 der neue Wert von Guete21bis30.
		*/
		public void setGuete21bis30(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete21bis30) {
			this._guete21bis30 = _guete21bis30;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 40.
		<p>
		
		</p>
		
		@return der Wert von Guete31bis40.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete31bis40() {
			return _guete31bis40;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 40.
		<p>
		
		</p>
		
		@param _guete31bis40 der neue Wert von Guete31bis40.
		*/
		public void setGuete31bis40(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete31bis40) {
			this._guete31bis40 = _guete31bis40;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 50.
		<p>
		
		</p>
		
		@return der Wert von Guete41bis50.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete41bis50() {
			return _guete41bis50;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 50.
		<p>
		
		</p>
		
		@param _guete41bis50 der neue Wert von Guete41bis50.
		*/
		public void setGuete41bis50(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete41bis50) {
			this._guete41bis50 = _guete41bis50;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 60.
		<p>
		
		</p>
		
		@return der Wert von Guete51bis60.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete51bis60() {
			return _guete51bis60;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 60.
		<p>
		
		</p>
		
		@param _guete51bis60 der neue Wert von Guete51bis60.
		*/
		public void setGuete51bis60(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete51bis60) {
			this._guete51bis60 = _guete51bis60;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 70.
		<p>
		
		</p>
		
		@return der Wert von Guete61bis70.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete61bis70() {
			return _guete61bis70;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 70.
		<p>
		
		</p>
		
		@param _guete61bis70 der neue Wert von Guete61bis70.
		*/
		public void setGuete61bis70(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete61bis70) {
			this._guete61bis70 = _guete61bis70;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 80.
		<p>
		
		</p>
		
		@return der Wert von Guete71bis80.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete71bis80() {
			return _guete71bis80;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 80.
		<p>
		
		</p>
		
		@param _guete71bis80 der neue Wert von Guete71bis80.
		*/
		public void setGuete71bis80(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete71bis80) {
			this._guete71bis80 = _guete71bis80;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 90.
		<p>
		
		</p>
		
		@return der Wert von Guete81bis90.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete81bis90() {
			return _guete81bis90;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 90.
		<p>
		
		</p>
		
		@param _guete81bis90 der neue Wert von Guete81bis90.
		*/
		public void setGuete81bis90(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete81bis90) {
			this._guete81bis90 = _guete81bis90;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 100.
		<p>
		
		</p>
		
		@return der Wert von Guete91bis100.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
			 getGuete91bis100() {
			return _guete91bis100;
		}
	
		/**
		Störfall-Priorität für den Bereich bis (einschließlich) Güte-Wert 100.
		<p>
		
		</p>
		
		@param _guete91bis100 der neue Wert von Guete91bis100.
		*/
		public void setGuete91bis100(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
		 _guete91bis100) {
			this._guete91bis100 = _guete91bis100;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getGuete1bis10() != null) {
	                if (getGuete1bis10().isZustand()) {
	                    datum.getUnscaledValue("Güte1bis10").setText(getGuete1bis10().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte1bis10").set(getGuete1bis10().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete11bis20() != null) {
	                if (getGuete11bis20().isZustand()) {
	                    datum.getUnscaledValue("Güte11bis20").setText(getGuete11bis20().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte11bis20").set(getGuete11bis20().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete21bis30() != null) {
	                if (getGuete21bis30().isZustand()) {
	                    datum.getUnscaledValue("Güte21bis30").setText(getGuete21bis30().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte21bis30").set(getGuete21bis30().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete31bis40() != null) {
	                if (getGuete31bis40().isZustand()) {
	                    datum.getUnscaledValue("Güte31bis40").setText(getGuete31bis40().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte31bis40").set(getGuete31bis40().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete41bis50() != null) {
	                if (getGuete41bis50().isZustand()) {
	                    datum.getUnscaledValue("Güte41bis50").setText(getGuete41bis50().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte41bis50").set(getGuete41bis50().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete51bis60() != null) {
	                if (getGuete51bis60().isZustand()) {
	                    datum.getUnscaledValue("Güte51bis60").setText(getGuete51bis60().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte51bis60").set(getGuete51bis60().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete61bis70() != null) {
	                if (getGuete61bis70().isZustand()) {
	                    datum.getUnscaledValue("Güte61bis70").setText(getGuete61bis70().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte61bis70").set(getGuete61bis70().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete71bis80() != null) {
	                if (getGuete71bis80().isZustand()) {
	                    datum.getUnscaledValue("Güte71bis80").setText(getGuete71bis80().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte71bis80").set(getGuete71bis80().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete81bis90() != null) {
	                if (getGuete81bis90().isZustand()) {
	                    datum.getUnscaledValue("Güte81bis90").setText(getGuete81bis90().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte81bis90").set(getGuete81bis90().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete91bis100() != null) {
	                if (getGuete91bis100().isZustand()) {
	                    datum.getUnscaledValue("Güte91bis100").setText(getGuete91bis100().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Güte91bis100").set(getGuete91bis100().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setGuete1bis10(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte1bis10").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete11bis20(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte11bis20").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete21bis30(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte21bis30").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete31bis40(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte31bis40").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete41bis50(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte41bis50").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete51bis60(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte51bis60").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete61bis70(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte61bis70").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete71bis80(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte71bis80").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete81bis90(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte81bis90").
								byteValue
						()));
				// GanzzahlAttributTyp
						setGuete91bis100(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttStoerfallGuetePrioritaet
						(daten.
							getUnscaledValue
						("Güte91bis100").
								byteValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGuetePrioritaetenListe clone() {
		AtlGuetePrioritaetenListe klon = new AtlGuetePrioritaetenListe();
		
						klon.setGuete1bis10(getGuete1bis10());
						klon.setGuete11bis20(getGuete11bis20());
						klon.setGuete21bis30(getGuete21bis30());
						klon.setGuete31bis40(getGuete31bis40());
						klon.setGuete41bis50(getGuete41bis50());
						klon.setGuete51bis60(getGuete51bis60());
						klon.setGuete61bis70(getGuete61bis70());
						klon.setGuete71bis80(getGuete71bis80());
						klon.setGuete81bis90(getGuete81bis90());
						klon.setGuete91bis100(getGuete91bis100());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
