/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abbildung einer Störfallsituation auf ein RDS-Ereignis.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsAbbildungsmatrix implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 _stoerfallSituation
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisBeschreibung
			 _rDSEreignisBeschreibung
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			> _rDSEreignisCode = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			>(0, true);
	
		/**
		Abzubildende Störfallsituation.
		<p>
		
		</p>
		
		@return der Wert von StoerfallSituation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 getStoerfallSituation() {
			return _stoerfallSituation;
		}
	
		/**
		Abzubildende Störfallsituation.
		<p>
		
		</p>
		
		@param _stoerfallSituation der neue Wert von StoerfallSituation.
		*/
		public void setStoerfallSituation(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
		 _stoerfallSituation) {
			this._stoerfallSituation = _stoerfallSituation;
		}
	
		/**
		Generelle Beschreibung des RDS-Ereignisses, auf das abgebildet wird.
		<p>
		
		</p>
		
		@return der Wert von RDSEreignisBeschreibung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisBeschreibung
			 getRDSEreignisBeschreibung() {
			return _rDSEreignisBeschreibung;
		}
	
		/**
		Generelle Beschreibung des RDS-Ereignisses, auf das abgebildet wird.
		<p>
		
		</p>
		
		@param _rDSEreignisBeschreibung der neue Wert von RDSEreignisBeschreibung.
		*/
		public void setRDSEreignisBeschreibung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisBeschreibung
		 _rDSEreignisBeschreibung) {
			this._rDSEreignisBeschreibung = _rDSEreignisBeschreibung;
		}
	
		/**
		Menge der Codes der abgebildeten konkreten RDS-Ereignisse.
		<p>
		
		</p>
		
		@return der Wert von RDSEreignisCode.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			> getRDSEreignisCode() {
			return _rDSEreignisCode;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getStoerfallSituation() != null) {
	                if (getStoerfallSituation().isZustand()) {
	                    datum.getUnscaledValue("StörfallSituation").setText(getStoerfallSituation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StörfallSituation").set(getStoerfallSituation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRDSEreignisBeschreibung() != null) {
	                if (getRDSEreignisBeschreibung().isZustand()) {
	                    datum.getUnscaledValue("RDSEreignisBeschreibung").setText(getRDSEreignisBeschreibung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("RDSEreignisBeschreibung").set(getRDSEreignisBeschreibung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRDSEreignisCode() != null) {
					final Data.NumberArray arrayRDSEreignisCode = datum.
						getUnscaledArray
						("RDSEreignisCode");
					arrayRDSEreignisCode.setLength(getRDSEreignisCode().size());
					for (int i = 0; i < arrayRDSEreignisCode.getLength(); ++i) {
						arrayRDSEreignisCode.getValue(i).set(getRDSEreignisCode().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StörfallSituation").isState()) {
							setStoerfallSituation(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
							.getZustand(daten.getScaledValue("StörfallSituation").getText()));
						} else {
						setStoerfallSituation(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
						(daten.
							getUnscaledValue
						("StörfallSituation").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RDSEreignisBeschreibung").isState()) {
							setRDSEreignisBeschreibung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisBeschreibung
							.getZustand(daten.getScaledValue("RDSEreignisBeschreibung").getText()));
						} else {
						setRDSEreignisBeschreibung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisBeschreibung
						(daten.
							getUnscaledValue
						("RDSEreignisBeschreibung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayRDSEreignisCode = daten.
						getUnscaledArray
					("RDSEreignisCode");
	
					for (int i = 0; i < arrayRDSEreignisCode.getLength(); ++i) {
	                    if (arrayRDSEreignisCode.getValue(i).isState()) {
	                        getRDSEreignisCode().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
	                        .getZustand(arrayRDSEreignisCode.getValue(i).getState().getName()));
	                    } else {
	                    getRDSEreignisCode().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
	                    (arrayRDSEreignisCode.
	                    		intValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsAbbildungsmatrix clone() {
		AtlRdsAbbildungsmatrix klon = new AtlRdsAbbildungsmatrix();
		
						klon.setStoerfallSituation(getStoerfallSituation());
						klon.setRDSEreignisBeschreibung(getRDSEreignisBeschreibung());
					klon._rDSEreignisCode = getRDSEreignisCode().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
