/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu Änderungen an Meldungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsAenderungsInfo implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _veranlasser
			= new String
			()
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _modifikationsZeitpunkt
			;
			@Defaultwert(wert = "")
			private String
			 _modifikationsKommentar
			= new String
			()
			;
	
		/**
		Name des Veranlassers der Modifikation.
		<p>
		TIC Info XML Element: ModifierUserName, Name des Nutzers, der die Meldung geändert hat oder "system", wenn der TIC Server die Änderung vorgenommen hat.
		</p>
		
		@return der Wert von Veranlasser.
		*/
			public String
			 getVeranlasser() {
			return _veranlasser;
		}
	
		/**
		Name des Veranlassers der Modifikation.
		<p>
		TIC Info XML Element: ModifierUserName, Name des Nutzers, der die Meldung geändert hat oder "system", wenn der TIC Server die Änderung vorgenommen hat.
		</p>
		
		@param _veranlasser der neue Wert von Veranlasser.
		*/
		public void setVeranlasser(String
		 _veranlasser) {
			if (_veranlasser.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._veranlasser = _veranlasser;
		}
	
		/**
		Modifikationszeitpunkt.
		<p>
		TIC Info XML Element: ModifierTime, Exakter Zeitpunkt, an dem die Meldung geändert wurde.
		</p>
		
		@return der Wert von ModifikationsZeitpunkt.
		*/
			public 	Zeitstempel
			 getModifikationsZeitpunkt() {
			return _modifikationsZeitpunkt;
		}
	
		/**
		Modifikationszeitpunkt.
		<p>
		TIC Info XML Element: ModifierTime, Exakter Zeitpunkt, an dem die Meldung geändert wurde.
		</p>
		
		@param _modifikationsZeitpunkt der neue Wert von ModifikationsZeitpunkt.
		*/
		public void setModifikationsZeitpunkt(	Zeitstempel
		 _modifikationsZeitpunkt) {
			this._modifikationsZeitpunkt = _modifikationsZeitpunkt;
		}
	
		/**
		Kommentar des Veranlassers der Änderung.
		<p>
		TIC Info XML Element: ModifierComment, Kommentar des Veranlassers zur Änderung.
		</p>
		
		@return der Wert von ModifikationsKommentar.
		*/
			public String
			 getModifikationsKommentar() {
			return _modifikationsKommentar;
		}
	
		/**
		Kommentar des Veranlassers der Änderung.
		<p>
		TIC Info XML Element: ModifierComment, Kommentar des Veranlassers zur Änderung.
		</p>
		
		@param _modifikationsKommentar der neue Wert von ModifikationsKommentar.
		*/
		public void setModifikationsKommentar(String
		 _modifikationsKommentar) {
			if (_modifikationsKommentar.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._modifikationsKommentar = _modifikationsKommentar;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVeranlasser() != null) {
					datum.getTextValue("Veranlasser").setText(getVeranlasser());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("ModifikationsZeitpunkt").setMillis(getModifikationsZeitpunkt().getTime());
				// ZeichenkettenAttributTyp
				if (getModifikationsKommentar() != null) {
					datum.getTextValue("ModifikationsKommentar").setText(getModifikationsKommentar());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setVeranlasser(daten.getTextValue("Veranlasser").getText());
				// ZeitstempelAttributTyp
					setModifikationsZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("ModifikationsZeitpunkt").getMillis()));
				// ZeichenkettenAttributTyp
					setModifikationsKommentar(daten.getTextValue("ModifikationsKommentar").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsAenderungsInfo clone() {
		AtlRdsAenderungsInfo klon = new AtlRdsAenderungsInfo();
		
						klon.setVeranlasser(getVeranlasser());
						klon.setModifikationsZeitpunkt(getModifikationsZeitpunkt());
						klon.setModifikationsKommentar(getModifikationsKommentar());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
