/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Quantitätsagaben zum Ereignis.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRdsEreignisQuantitaet implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
			 _quantitaetsKennung
			;
			private String
			 _quantitaetsWert
			= new String
			()
			;
			private String
			 _quantitaetsEinheit
			= new String
			()
			;
	
		/**
		Quantitäts-Kennung.
		<p>
		gebildet aus TIC Info XML Element: EventDataQuantitiesQualifier.
		</p>
		
		@return der Wert von QuantitaetsKennung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
			 getQuantitaetsKennung() {
			return _quantitaetsKennung;
		}
	
		/**
		Quantitäts-Kennung.
		<p>
		gebildet aus TIC Info XML Element: EventDataQuantitiesQualifier.
		</p>
		
		@param _quantitaetsKennung der neue Wert von QuantitaetsKennung.
		*/
		public void setQuantitaetsKennung(	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
		 _quantitaetsKennung) {
			this._quantitaetsKennung = _quantitaetsKennung;
		}
	
		/**
		Inhalt des zusätzlichen Wertes.
		<p>
		TIC Info XML Element: EventDataQuantitiesContent
		</p>
		
		@return der Wert von QuantitaetsWert.
		*/
			public String
			 getQuantitaetsWert() {
			return _quantitaetsWert;
		}
	
		/**
		Inhalt des zusätzlichen Wertes.
		<p>
		TIC Info XML Element: EventDataQuantitiesContent
		</p>
		
		@param _quantitaetsWert der neue Wert von QuantitaetsWert.
		*/
		public void setQuantitaetsWert(String
		 _quantitaetsWert) {
			if (_quantitaetsWert.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._quantitaetsWert = _quantitaetsWert;
		}
	
		/**
		Einheit des zusätzlichen Wertes.
		<p>
		TIC Info XML Element: EventDataQuantitiesUnitQualifier
		</p>
		
		@return der Wert von QuantitaetsEinheit.
		*/
			public String
			 getQuantitaetsEinheit() {
			return _quantitaetsEinheit;
		}
	
		/**
		Einheit des zusätzlichen Wertes.
		<p>
		TIC Info XML Element: EventDataQuantitiesUnitQualifier
		</p>
		
		@param _quantitaetsEinheit der neue Wert von QuantitaetsEinheit.
		*/
		public void setQuantitaetsEinheit(String
		 _quantitaetsEinheit) {
			if (_quantitaetsEinheit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._quantitaetsEinheit = _quantitaetsEinheit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soQuantitaetsKennung = getQuantitaetsKennung();
					final SystemObject tmpQuantitaetsKennung;
						if (soQuantitaetsKennung instanceof SystemObject) {
							tmpQuantitaetsKennung = (SystemObject)soQuantitaetsKennung;
						} else if(soQuantitaetsKennung instanceof SystemObjekt){
							tmpQuantitaetsKennung = ((SystemObjekt)soQuantitaetsKennung).getSystemObject();
						} else{
							tmpQuantitaetsKennung = null;
						}
					datum.getReferenceValue("QuantitätsKennung").setSystemObject(tmpQuantitaetsKennung);
				// ZeichenkettenAttributTyp
				if (getQuantitaetsWert() != null) {
					datum.getTextValue("QuantitätsWert").setText(getQuantitaetsWert());
				}
				// ZeichenkettenAttributTyp
				if (getQuantitaetsEinheit() != null) {
					datum.getTextValue("QuantitätsEinheit").setText(getQuantitaetsEinheit());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idQuantitaetsKennung = daten.getReferenceValue("QuantitätsKennung").getId();
					final SystemObjekt tmpQuantitaetsKennung;
					if (idQuantitaetsKennung == 0) {
						tmpQuantitaetsKennung = null;
					} else {
						final SystemObject soQuantitaetsKennung = factory.getDav().getDataModel().getObject(idQuantitaetsKennung);
						if (soQuantitaetsKennung == null) {
								tmpQuantitaetsKennung = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.impl.RdsQuantitaetUngueltig(idQuantitaetsKennung);
						} else {
							tmpQuantitaetsKennung = factory.getModellobjekt(soQuantitaetsKennung);
						}
					}
					setQuantitaetsKennung((	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
					) tmpQuantitaetsKennung);
				// ZeichenkettenAttributTyp
					setQuantitaetsWert(daten.getTextValue("QuantitätsWert").getText());
				// ZeichenkettenAttributTyp
					setQuantitaetsEinheit(daten.getTextValue("QuantitätsEinheit").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsEreignisQuantitaet clone() {
		AtlRdsEreignisQuantitaet klon = new AtlRdsEreignisQuantitaet();
		
						klon.setQuantitaetsKennung(getQuantitaetsKennung());
						klon.setQuantitaetsWert(getQuantitaetsWert());
						klon.setQuantitaetsEinheit(getQuantitaetsEinheit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
