/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eindeutige Identifikation der Information.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsId implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _iDOrganisation
			= new String
			()
			;
			@Defaultwert(wert = "")
			private String
			 _iDNummer
			= new String
			()
			;
	
		/**
		Name der Organisation, welche die Meldung publiziert hat.
		<p>
		TIC Info XML Element: IDOrganisation, Name der publizierenden Organisation.
		</p>
		
		@return der Wert von IDOrganisation.
		*/
			public String
			 getIDOrganisation() {
			return _iDOrganisation;
		}
	
		/**
		Name der Organisation, welche die Meldung publiziert hat.
		<p>
		TIC Info XML Element: IDOrganisation, Name der publizierenden Organisation.
		</p>
		
		@param _iDOrganisation der neue Wert von IDOrganisation.
		*/
		public void setIDOrganisation(String
		 _iDOrganisation) {
			if (_iDOrganisation.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._iDOrganisation = _iDOrganisation;
		}
	
		/**
		Laufende Nummer der Meldung.
		<p>
		TIC Info XML Element: IDNumber, Fortlaufende Nummer der Meldung innerhalb der publizierenden Organisation.
							Die Nummer wird von der SWE 2.1 LMS unmittelbar vor dem Versand gefüllt.
		</p>
		
		@return der Wert von IDNummer.
		*/
			public String
			 getIDNummer() {
			return _iDNummer;
		}
	
		/**
		Laufende Nummer der Meldung.
		<p>
		TIC Info XML Element: IDNumber, Fortlaufende Nummer der Meldung innerhalb der publizierenden Organisation.
							Die Nummer wird von der SWE 2.1 LMS unmittelbar vor dem Versand gefüllt.
		</p>
		
		@param _iDNummer der neue Wert von IDNummer.
		*/
		public void setIDNummer(String
		 _iDNummer) {
			if (_iDNummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._iDNummer = _iDNummer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getIDOrganisation() != null) {
					datum.getTextValue("IDOrganisation").setText(getIDOrganisation());
				}
				// ZeichenkettenAttributTyp
				if (getIDNummer() != null) {
					datum.getTextValue("IDNummer").setText(getIDNummer());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setIDOrganisation(daten.getTextValue("IDOrganisation").getText());
				// ZeichenkettenAttributTyp
					setIDNummer(daten.getTextValue("IDNummer").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsId clone() {
		AtlRdsId klon = new AtlRdsId();
		
						klon.setIDOrganisation(getIDOrganisation());
						klon.setIDNummer(getIDNummer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
