/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten einer Location.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsLocation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationCode
			;
			private String
			 _strassenNummer
			= new String
			()
			;
			private String
			 _ausfahrtNummer
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
			 _tmcOrtsTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationKoordinaten
			 _koordinaten
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationKoordinaten
			()
			;
			@Defaultwert(wert = "0")
			private String
			 _locationKilometrierung
			= new String
			()
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationCodeLinienReferenz
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationCodeGebietsReferenz
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationNextNegativ
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationNextPositiv
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
			 _locationNachricht
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
			()
			;
	
		/**
		Location-Code.
		<p>
		TIC Info XML Element: LocationLocCode, Location-Code. 
							Empfangen werden kann '4294967295' als ein spezieller Code für Locations mit LocationFormat = TIC Location.
							Das bedeutet, dass die Location nur über die geographischen Koordinaten verortet ist.
							Der Wert dieses Attributes wird in diesem Fall auf '0' gesetzt.
		</p>
		
		@return der Wert von LocationCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationCode() {
			return _locationCode;
		}
	
		/**
		Location-Code.
		<p>
		TIC Info XML Element: LocationLocCode, Location-Code. 
							Empfangen werden kann '4294967295' als ein spezieller Code für Locations mit LocationFormat = TIC Location.
							Das bedeutet, dass die Location nur über die geographischen Koordinaten verortet ist.
							Der Wert dieses Attributes wird in diesem Fall auf '0' gesetzt.
		</p>
		
		@param _locationCode der neue Wert von LocationCode.
		*/
		public void setLocationCode(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationCode) {
			this._locationCode = _locationCode;
		}
	
		/**
		Strassen-Nummer.
		<p>
		TIC Info XML Element: LocationLocRoadNumber, Strassen-Nummer.
		</p>
		
		@return der Wert von StrassenNummer.
		*/
			public String
			 getStrassenNummer() {
			return _strassenNummer;
		}
	
		/**
		Strassen-Nummer.
		<p>
		TIC Info XML Element: LocationLocRoadNumber, Strassen-Nummer.
		</p>
		
		@param _strassenNummer der neue Wert von StrassenNummer.
		*/
		public void setStrassenNummer(String
		 _strassenNummer) {
			if (_strassenNummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._strassenNummer = _strassenNummer;
		}
	
		/**
		Ausfahrt-Nummer.
		<p>
		TIC Info XML Element: LocationLocExitNumber, Ausfahrt-Nummer.
		</p>
		
		@return der Wert von AusfahrtNummer.
		*/
			public String
			 getAusfahrtNummer() {
			return _ausfahrtNummer;
		}
	
		/**
		Ausfahrt-Nummer.
		<p>
		TIC Info XML Element: LocationLocExitNumber, Ausfahrt-Nummer.
		</p>
		
		@param _ausfahrtNummer der neue Wert von AusfahrtNummer.
		*/
		public void setAusfahrtNummer(String
		 _ausfahrtNummer) {
			if (_ausfahrtNummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ausfahrtNummer = _ausfahrtNummer;
		}
	
		/**
		Ortstyp und OrtSubtyp des Ortes entsprechend der Festlegungen der LCL.
		<p>
		&lt;absatz&gt;Die Location Sub Types der TIC-Spezifikation werden wie folgt auf den &lt;verweis pid="att.tmcOrtsTyp"&gt;&lt;&#47;verweis&gt;abgebildet:&lt;&#47;absatz&gt;
								&lt;absatz&gt;Der Wert des Aufzahlungstyps att.tmcOrtsTyp ist eine sechsstellige Zahl der Form TNNSSS mit T gleich Typ (1=Punkt, 2=Linie, 3=Gebiet), NN gleich Orttypnummer und SSS gleich Untertypnummer entsprechend LCL, jeweils mit führenden Nullen.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Der TMC-Typ 'Punkt', 'Linie' oder 'Gebiet' ergibt sich aus dem XML Element LocationLocType mit folgender Kodierung:&lt;&#47;absatz&gt;
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;LocationLocType 0: 'Gebiet'&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;LocationLocType 1: 'Linie'&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;LocationLocType 2: 'Punkt'&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
								&lt;absatz&gt;Die Orttypnummer ergibt sich aus dem XML Element LocationLocSubType mit folgender Kodierung:&lt;&#47;absatz&gt;
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;LocationLocSubType div 100&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
								&lt;absatz&gt;Die Untertypnummer ergibt sich aus dem XML Element LocationLocSubType mit folgender Kodierung:&lt;&#47;absatz&gt;
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;LocationLocSubType mod 100&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
								&lt;absatz&gt;Beispiel:&lt;&#47;absatz&gt;
								&lt;absatz&gt;LocationLocType = 0  -&gt; Typ=3&lt;&#47;absatz&gt;
								&lt;absatz&gt;LocationLocSubType = 607 -&gt; Orttypnummer=6, Untertypnummer=7&lt;&#47;absatz&gt;
								&lt;absatz&gt;Wert von att.tmcOrtsTyp: 306007&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von TmcOrtsTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
			 getTmcOrtsTyp() {
			return _tmcOrtsTyp;
		}
	
		/**
		Ortstyp und OrtSubtyp des Ortes entsprechend der Festlegungen der LCL.
		<p>
		&lt;absatz&gt;Die Location Sub Types der TIC-Spezifikation werden wie folgt auf den &lt;verweis pid="att.tmcOrtsTyp"&gt;&lt;&#47;verweis&gt;abgebildet:&lt;&#47;absatz&gt;
								&lt;absatz&gt;Der Wert des Aufzahlungstyps att.tmcOrtsTyp ist eine sechsstellige Zahl der Form TNNSSS mit T gleich Typ (1=Punkt, 2=Linie, 3=Gebiet), NN gleich Orttypnummer und SSS gleich Untertypnummer entsprechend LCL, jeweils mit führenden Nullen.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Der TMC-Typ 'Punkt', 'Linie' oder 'Gebiet' ergibt sich aus dem XML Element LocationLocType mit folgender Kodierung:&lt;&#47;absatz&gt;
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;LocationLocType 0: 'Gebiet'&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;LocationLocType 1: 'Linie'&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;LocationLocType 2: 'Punkt'&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
								&lt;absatz&gt;Die Orttypnummer ergibt sich aus dem XML Element LocationLocSubType mit folgender Kodierung:&lt;&#47;absatz&gt;
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;LocationLocSubType div 100&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
								&lt;absatz&gt;Die Untertypnummer ergibt sich aus dem XML Element LocationLocSubType mit folgender Kodierung:&lt;&#47;absatz&gt;
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;LocationLocSubType mod 100&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
								&lt;absatz&gt;Beispiel:&lt;&#47;absatz&gt;
								&lt;absatz&gt;LocationLocType = 0  -&gt; Typ=3&lt;&#47;absatz&gt;
								&lt;absatz&gt;LocationLocSubType = 607 -&gt; Orttypnummer=6, Untertypnummer=7&lt;&#47;absatz&gt;
								&lt;absatz&gt;Wert von att.tmcOrtsTyp: 306007&lt;&#47;absatz&gt;
		</p>
		
		@param _tmcOrtsTyp der neue Wert von TmcOrtsTyp.
		*/
		public void setTmcOrtsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
		 _tmcOrtsTyp) {
			this._tmcOrtsTyp = _tmcOrtsTyp;
		}
	
		/**
		Die Koordinaten der Location.
		<p>
		TIC Info XML Element: LocationLocCoordinates.
		</p>
		
		@return der Wert von Koordinaten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationKoordinaten
			 getKoordinaten() {
			return _koordinaten;
		}
	
		/**
		Die Koordinaten der Location.
		<p>
		TIC Info XML Element: LocationLocCoordinates.
		</p>
		
		@param _koordinaten der neue Wert von Koordinaten.
		*/
		public void setKoordinaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationKoordinaten
		 _koordinaten) {
			this._koordinaten = _koordinaten;
		}
	
		/**
		Kilometrierungsangabe.
		<p>
		TIC Info XML Element: LocationLocMilestone, Werte im Format "123" oder "123.45" werden erwartet.
		</p>
		
		@return der Wert von LocationKilometrierung.
		*/
			public String
			 getLocationKilometrierung() {
			return _locationKilometrierung;
		}
	
		/**
		Kilometrierungsangabe.
		<p>
		TIC Info XML Element: LocationLocMilestone, Werte im Format "123" oder "123.45" werden erwartet.
		</p>
		
		@param _locationKilometrierung der neue Wert von LocationKilometrierung.
		*/
		public void setLocationKilometrierung(String
		 _locationKilometrierung) {
			if (_locationKilometrierung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationKilometrierung = _locationKilometrierung;
		}
	
		/**
		Linien-Location.
		<p>
		TIC Info XML Element: LocationLocLinearReference, Location Code der zugehörigen Linien-Location.
		</p>
		
		@return der Wert von LocationCodeLinienReferenz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationCodeLinienReferenz() {
			return _locationCodeLinienReferenz;
		}
	
		/**
		Linien-Location.
		<p>
		TIC Info XML Element: LocationLocLinearReference, Location Code der zugehörigen Linien-Location.
		</p>
		
		@param _locationCodeLinienReferenz der neue Wert von LocationCodeLinienReferenz.
		*/
		public void setLocationCodeLinienReferenz(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationCodeLinienReferenz) {
			this._locationCodeLinienReferenz = _locationCodeLinienReferenz;
		}
	
		/**
		Gebiets-Location.
		<p>
		TIC Info XML Element: LocationLocAreaReference, Location Code der zugehörigen Gebiets-Location.
		</p>
		
		@return der Wert von LocationCodeGebietsReferenz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationCodeGebietsReferenz() {
			return _locationCodeGebietsReferenz;
		}
	
		/**
		Gebiets-Location.
		<p>
		TIC Info XML Element: LocationLocAreaReference, Location Code der zugehörigen Gebiets-Location.
		</p>
		
		@param _locationCodeGebietsReferenz der neue Wert von LocationCodeGebietsReferenz.
		*/
		public void setLocationCodeGebietsReferenz(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationCodeGebietsReferenz) {
			this._locationCodeGebietsReferenz = _locationCodeGebietsReferenz;
		}
	
		/**
		Nächste Location in negativer Richtung.
		<p>
		TIC Info XML Element: LocationLocNegativeOffset, Location-Code der nächsten Location in negativer Richtung.
		</p>
		
		@return der Wert von LocationNextNegativ.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationNextNegativ() {
			return _locationNextNegativ;
		}
	
		/**
		Nächste Location in negativer Richtung.
		<p>
		TIC Info XML Element: LocationLocNegativeOffset, Location-Code der nächsten Location in negativer Richtung.
		</p>
		
		@param _locationNextNegativ der neue Wert von LocationNextNegativ.
		*/
		public void setLocationNextNegativ(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationNextNegativ) {
			this._locationNextNegativ = _locationNextNegativ;
		}
	
		/**
		Nächste Location in positiver Richtung.
		<p>
		TIC Info XML Element: LocationLocPositiveOffset, Location-Code der nächsten Location in positiver Richtung.
		</p>
		
		@return der Wert von LocationNextPositiv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationNextPositiv() {
			return _locationNextPositiv;
		}
	
		/**
		Nächste Location in positiver Richtung.
		<p>
		TIC Info XML Element: LocationLocPositiveOffset, Location-Code der nächsten Location in positiver Richtung.
		</p>
		
		@param _locationNextPositiv der neue Wert von LocationNextPositiv.
		*/
		public void setLocationNextPositiv(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationNextPositiv) {
			this._locationNextPositiv = _locationNextPositiv;
		}
	
		/**
		Nachrichtentexte.
		<p>
		TIC Info XML Element: LocationLocMessage, enthält Nachrichtentexte für die NachrichtenKlassen 40 â 59.
		</p>
		
		@return der Wert von LocationNachricht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
			 getLocationNachricht() {
			return _locationNachricht;
		}
	
		/**
		Nachrichtentexte.
		<p>
		TIC Info XML Element: LocationLocMessage, enthält Nachrichtentexte für die NachrichtenKlassen 40 â 59.
		</p>
		
		@param _locationNachricht der neue Wert von LocationNachricht.
		*/
		public void setLocationNachricht(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
		 _locationNachricht) {
			this._locationNachricht = _locationNachricht;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLocationCode() != null) {
	                if (getLocationCode().isZustand()) {
	                    datum.getUnscaledValue("LocationCode").setText(getLocationCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationCode").set(getLocationCode().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getStrassenNummer() != null) {
					datum.getTextValue("StrassenNummer").setText(getStrassenNummer());
				}
				// ZeichenkettenAttributTyp
				if (getAusfahrtNummer() != null) {
					datum.getTextValue("AusfahrtNummer").setText(getAusfahrtNummer());
				}
				// GanzzahlAttributTyp
				if (getTmcOrtsTyp() != null) {
	                if (getTmcOrtsTyp().isZustand()) {
	                    datum.getUnscaledValue("TmcOrtsTyp").setText(getTmcOrtsTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TmcOrtsTyp").set(getTmcOrtsTyp().getValue());
	                }
				}
				// AttributListenDefinition
					getKoordinaten().bean2Atl(datum.getItem("Koordinaten"), factory);
				// ZeichenkettenAttributTyp
				if (getLocationKilometrierung() != null) {
					datum.getTextValue("LocationKilometrierung").setText(getLocationKilometrierung());
				}
				// GanzzahlAttributTyp
				if (getLocationCodeLinienReferenz() != null) {
	                if (getLocationCodeLinienReferenz().isZustand()) {
	                    datum.getUnscaledValue("LocationCodeLinienReferenz").setText(getLocationCodeLinienReferenz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationCodeLinienReferenz").set(getLocationCodeLinienReferenz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationCodeGebietsReferenz() != null) {
	                if (getLocationCodeGebietsReferenz().isZustand()) {
	                    datum.getUnscaledValue("LocationCodeGebietsReferenz").setText(getLocationCodeGebietsReferenz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationCodeGebietsReferenz").set(getLocationCodeGebietsReferenz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationNextNegativ() != null) {
	                if (getLocationNextNegativ().isZustand()) {
	                    datum.getUnscaledValue("LocationNextNegativ").setText(getLocationNextNegativ().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationNextNegativ").set(getLocationNextNegativ().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationNextPositiv() != null) {
	                if (getLocationNextPositiv().isZustand()) {
	                    datum.getUnscaledValue("LocationNextPositiv").setText(getLocationNextPositiv().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationNextPositiv").set(getLocationNextPositiv().getValue());
	                }
				}
				// AttributListenDefinition
					getLocationNachricht().bean2Atl(datum.getItem("LocationNachricht"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setLocationCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationCode").
								intValue
						()));
				// ZeichenkettenAttributTyp
					setStrassenNummer(daten.getTextValue("StrassenNummer").getText());
				// ZeichenkettenAttributTyp
					setAusfahrtNummer(daten.getTextValue("AusfahrtNummer").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TmcOrtsTyp").isState()) {
							setTmcOrtsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
							.getZustand(daten.getScaledValue("TmcOrtsTyp").getText()));
						} else {
						setTmcOrtsTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcOrtsTyp
						(daten.
							getUnscaledValue
						("TmcOrtsTyp").
								intValue
						()));
						}
				// AttributListenDefinition
					getKoordinaten().atl2Bean(daten.getItem("Koordinaten"), factory);
				// ZeichenkettenAttributTyp
					setLocationKilometrierung(daten.getTextValue("LocationKilometrierung").getText());
				// GanzzahlAttributTyp
						setLocationCodeLinienReferenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationCodeLinienReferenz").
								intValue
						()));
				// GanzzahlAttributTyp
						setLocationCodeGebietsReferenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationCodeGebietsReferenz").
								intValue
						()));
				// GanzzahlAttributTyp
						setLocationNextNegativ(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationNextNegativ").
								intValue
						()));
				// GanzzahlAttributTyp
						setLocationNextPositiv(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationNextPositiv").
								intValue
						()));
				// AttributListenDefinition
					getLocationNachricht().atl2Bean(daten.getItem("LocationNachricht"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsLocation clone() {
		AtlRdsLocation klon = new AtlRdsLocation();
		
						klon.setLocationCode(getLocationCode());
						klon.setStrassenNummer(getStrassenNummer());
						klon.setAusfahrtNummer(getAusfahrtNummer());
						klon.setTmcOrtsTyp(getTmcOrtsTyp());
						klon._koordinaten = getKoordinaten().clone();
						klon.setLocationKilometrierung(getLocationKilometrierung());
						klon.setLocationCodeLinienReferenz(getLocationCodeLinienReferenz());
						klon.setLocationCodeGebietsReferenz(getLocationCodeGebietsReferenz());
						klon.setLocationNextNegativ(getLocationNextNegativ());
						klon.setLocationNextPositiv(getLocationNextPositiv());
						klon._locationNachricht = getLocationNachricht().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
