/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste von Prioritäten in Abhängigkeit der Güte pro Verkehrssituation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AtlRdsPrioritaetenmatrix implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _stau
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _stockenderVerkehr
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _zaehfliessenderVerkehr
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _dichterVerkehr
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _lebhafterVerkehr
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _freierVerkehr
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 _keineAussage
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			()
			;
	
		/**
		Gibt die Prioritäten der Störfallsituation 7 (Stau) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getStau() {
			return _stau;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 7 (Stau) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@param _stau der neue Wert von Stau.
		*/
		public void setStau(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _stau) {
			this._stau = _stau;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 6 (Stockender Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		Dieser Verkehrszustand wird derzeit nicht verwendet. Er ist für eine mögliche spätere Verwendung vorgesehen.
		</p>
		
		@return der Wert von StockenderVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getStockenderVerkehr() {
			return _stockenderVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 6 (Stockender Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		Dieser Verkehrszustand wird derzeit nicht verwendet. Er ist für eine mögliche spätere Verwendung vorgesehen.
		</p>
		
		@param _stockenderVerkehr der neue Wert von StockenderVerkehr.
		*/
		public void setStockenderVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _stockenderVerkehr) {
			this._stockenderVerkehr = _stockenderVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 5 (Zähfließender Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@return der Wert von ZaehfliessenderVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getZaehfliessenderVerkehr() {
			return _zaehfliessenderVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 5 (Zähfließender Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@param _zaehfliessenderVerkehr der neue Wert von ZaehfliessenderVerkehr.
		*/
		public void setZaehfliessenderVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _zaehfliessenderVerkehr) {
			this._zaehfliessenderVerkehr = _zaehfliessenderVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 4 (Dichter Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@return der Wert von DichterVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getDichterVerkehr() {
			return _dichterVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 4 (Dichter Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@param _dichterVerkehr der neue Wert von DichterVerkehr.
		*/
		public void setDichterVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _dichterVerkehr) {
			this._dichterVerkehr = _dichterVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 3 (Lebhafter Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@return der Wert von LebhafterVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getLebhafterVerkehr() {
			return _lebhafterVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 3 (Lebhafter Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@param _lebhafterVerkehr der neue Wert von LebhafterVerkehr.
		*/
		public void setLebhafterVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _lebhafterVerkehr) {
			this._lebhafterVerkehr = _lebhafterVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 2 (Freier Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@return der Wert von FreierVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getFreierVerkehr() {
			return _freierVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 2 (Freier Verkehr) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@param _freierVerkehr der neue Wert von FreierVerkehr.
		*/
		public void setFreierVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _freierVerkehr) {
			this._freierVerkehr = _freierVerkehr;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 1 (Keine Aussage) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@return der Wert von KeineAussage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
			 getKeineAussage() {
			return _keineAussage;
		}
	
		/**
		Gibt die Prioritäten der Störfallsituation 1 (Keine Aussage) in Abhängigkeit der ermittelten Güte an.
		<p>
		
		</p>
		
		@param _keineAussage der neue Wert von KeineAussage.
		*/
		public void setKeineAussage(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlGuetePrioritaetenListe
		 _keineAussage) {
			this._keineAussage = _keineAussage;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getStau().bean2Atl(datum.getItem("Stau"), factory);
				// AttributListenDefinition
					getStockenderVerkehr().bean2Atl(datum.getItem("stockenderVerkehr"), factory);
				// AttributListenDefinition
					getZaehfliessenderVerkehr().bean2Atl(datum.getItem("zähfließenderVerkehr"), factory);
				// AttributListenDefinition
					getDichterVerkehr().bean2Atl(datum.getItem("dichterVerkehr"), factory);
				// AttributListenDefinition
					getLebhafterVerkehr().bean2Atl(datum.getItem("lebhafterVerkehr"), factory);
				// AttributListenDefinition
					getFreierVerkehr().bean2Atl(datum.getItem("freierVerkehr"), factory);
				// AttributListenDefinition
					getKeineAussage().bean2Atl(datum.getItem("keineAussage"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getStau().atl2Bean(daten.getItem("Stau"), factory);
				// AttributListenDefinition
					getStockenderVerkehr().atl2Bean(daten.getItem("stockenderVerkehr"), factory);
				// AttributListenDefinition
					getZaehfliessenderVerkehr().atl2Bean(daten.getItem("zähfließenderVerkehr"), factory);
				// AttributListenDefinition
					getDichterVerkehr().atl2Bean(daten.getItem("dichterVerkehr"), factory);
				// AttributListenDefinition
					getLebhafterVerkehr().atl2Bean(daten.getItem("lebhafterVerkehr"), factory);
				// AttributListenDefinition
					getFreierVerkehr().atl2Bean(daten.getItem("freierVerkehr"), factory);
				// AttributListenDefinition
					getKeineAussage().atl2Bean(daten.getItem("keineAussage"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsPrioritaetenmatrix clone() {
		AtlRdsPrioritaetenmatrix klon = new AtlRdsPrioritaetenmatrix();
		
						klon._stau = getStau().clone();
						klon._stockenderVerkehr = getStockenderVerkehr().clone();
						klon._zaehfliessenderVerkehr = getZaehfliessenderVerkehr().clone();
						klon._dichterVerkehr = getDichterVerkehr().clone();
						klon._lebhafterVerkehr = getLebhafterVerkehr().clone();
						klon._freierVerkehr = getFreierVerkehr().clone();
						klon._keineAussage = getKeineAussage().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
